/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Externsheet;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArea3d;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;

public class PtgAreaErr3d
extends PtgArea3d
implements Ptg {
    private static final long serialVersionUID = -9091097082897614748L;

    @Override
    public boolean getIsRefErr() {
        return true;
    }

    @Override
    public String getString() {
        if (this.sheetname == null) {
            return "#REF!";
        }
        return String.valueOf(this.sheetname) + "!#REF!";
    }

    @Override
    public int getLength() {
        return 11;
    }

    @Override
    public void init(byte[] b) {
        this.record = b;
        this.ixti = ByteTools.readShort(this.record[1], this.record[2]);
        if (this.ixti > 0) {
            this.sheetname = GenericPtg.qualifySheetname(this.getSheetName());
        }
    }

    @Override
    public Object getValue() {
        if (this.sheetname == null) {
            return "#REF!";
        }
        return String.valueOf(this.sheetname) + "!#REF!";
    }

    @Override
    public void setReferencedSheet(Boundsheet b) {
        int boundnum = b.getSheetNum();
        Externsheet xsht = b.getWorkBook().getExternSheet(true);
        try {
            int xloc = xsht.insertLocation(boundnum, boundnum);
            this.ixti = (short)xloc;
            if (this.ixti > 0) {
                this.sheetname = GenericPtg.qualifySheetname(this.getSheetName());
            }
        }
        catch (WorkSheetNotFoundException e) {
            Logger.logErr("Unable to set referenced sheet in PtgRef3d " + e);
        }
    }

    @Override
    public void setLocation(String[] s) {
        this.sheetname = GenericPtg.qualifySheetname(s[0]);
    }

    @Override
    public int[] getRowCol() {
        return new int[]{-1, -1};
    }
}

