/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Externsheet;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.Shrfmla;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.IxtiListener;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArea;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.XLS.formulas.PtgRef3d;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;

public class PtgArea3d
extends PtgArea
implements Ptg,
IxtiListener {
    private static final long serialVersionUID = -1176168076050592292L;
    boolean quoted = false;
    public short ixti;
    private boolean isExternalRef = false;
    private Ptg[] comps = null;

    @Override
    public boolean getIsOperand() {
        return true;
    }

    @Override
    public boolean getIsReference() {
        return true;
    }

    @Override
    public String getString() {
        try {
            if (this.getIsWholeCol() || this.getIsWholeRow()) {
                String s = this.firstPtg.getLocation();
                String y = this.lastPtg.getLocation();
                String[] loc1 = ExcelTools.stripSheetNameFromRange(s);
                String[] loc2 = ExcelTools.stripSheetNameFromRange(y);
                if (this.getIsWholeCol()) {
                    int i = loc1[1].length();
                    if (Character.isDigit(loc1[1].charAt(i - 1))) {
                        while (Character.isDigit(loc1[1].charAt(--i))) {
                        }
                    }
                    loc1[1] = loc1[1].substring(0, i);
                    i = loc2[1].length();
                    if (Character.isDigit(loc2[1].charAt(i - 1))) {
                        while (Character.isDigit(loc2[1].charAt(--i))) {
                        }
                    }
                    loc2[1] = loc2[1].substring(0, i);
                } else if (this.getIsWholeRow()) {
                    int i = 0;
                    while (!Character.isDigit(loc1[1].charAt(i++))) {
                    }
                    loc1[1] = "$" + loc1[1].substring(i - 1);
                    i = 0;
                    while (!Character.isDigit(loc2[1].charAt(i++))) {
                    }
                    loc2[1] = "$" + loc2[1].substring(i - 1);
                }
                this.sheetname = PtgArea3d.qualifySheetname(this.sheetname);
                return String.valueOf(this.sheetname) + "!" + loc1[1] + ":" + loc2[1];
            }
            return this.getLocation();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void addListener() {
        try {
            this.getParentRec().getWorkBook().getExternSheet().addPtgListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        String ret = this.getString();
        return ret;
    }

    public PtgArea3d() {
        this.ptgId = (byte)59;
        this.record = new byte[11];
        this.record[0] = this.ptgId;
        this.is3dRef = true;
    }

    public PtgArea3d(boolean useReferenceTracker) {
        this();
        this.useReferenceTracker = useReferenceTracker;
    }

    @Override
    public void setPtgType(short type) {
        switch (type) {
            case 0: {
                this.ptgId = (byte)91;
                break;
            }
            case 1: {
                this.ptgId = (byte)59;
                break;
            }
            case 2: {
                this.ptgId = (byte)123;
            }
        }
        this.record[0] = this.ptgId;
    }

    @Override
    public short getIxti() {
        return this.ixti;
    }

    @Override
    public void setIxti(short ixf) {
        if (this.ixti != ixf) {
            this.ixti = ixf;
            if (this.record != null) {
                this.record[1] = (byte)ixf;
                this.populateVals();
            }
        }
    }

    public boolean isExternalRef() {
        return this.isExternalRef;
    }

    public Boundsheet getFirstSheet() {
        if (this.parent_rec != null) {
            Boundsheet[] bsa;
            WorkBook wb = this.parent_rec.getWorkBook();
            if (this.sheetname != null) {
                try {
                    return wb.getWorkSheetByName(this.sheetname);
                }
                catch (WorkSheetNotFoundException workSheetNotFoundException) {
                    // empty catch block
                }
            }
            if (wb != null && wb.getExternSheet() != null && (bsa = wb.getExternSheet().getBoundSheets(this.ixti)) != null) {
                return bsa[0];
            }
        }
        return null;
    }

    public Boundsheet getLastSheet() {
        Boundsheet[] bsa;
        WorkBook wb;
        if (this.parent_rec != null && (wb = this.parent_rec.getWorkBook()) != null && wb.getExternSheet() != null && (bsa = wb.getExternSheet().getBoundSheets(this.ixti)) != null) {
            if (bsa.length > 1) {
                return bsa[bsa.length - 1];
            }
            return bsa[0];
        }
        return null;
    }

    @Override
    public void setParentRec(XLSRecord rec) {
        super.setParentRec(rec);
        if (this.firstPtg != null) {
            this.firstPtg.setParentRec(this.parent_rec);
        }
        if (this.lastPtg != null) {
            this.lastPtg.setParentRec(this.parent_rec);
        }
    }

    public Boundsheet getSheet() {
        return this.getFirstSheet();
    }

    @Override
    public String getSheetName() {
        if (this.sheetname == null && this.parent_rec != null) {
            String[] sheets;
            WorkBook wb = this.parent_rec.getWorkBook();
            if (wb != null && wb.getExternSheet() != null && (sheets = wb.getExternSheet().getBoundSheetNames(this.ixti)) != null && sheets.length > 0) {
                this.sheetname = sheets[0];
                this.sheetname = PtgArea3d.qualifySheetname(this.sheetname);
            }
            if (this.sheetname == null && this.parent_rec != null && this.parent_rec.getSheet() != null) {
                this.sheetname = this.parent_rec.getSheet().getSheetName();
                this.sheetname = PtgArea3d.qualifySheetname(this.sheetname);
            }
        }
        return this.sheetname;
    }

    public String getLastSheetName() {
        String[] sheets;
        WorkBook wb;
        String sheetname = this.sheetname;
        if (this.parent_rec != null && (wb = this.parent_rec.getWorkBook()) != null && wb.getExternSheet() != null && (sheets = wb.getExternSheet().getBoundSheetNames(this.ixti)) != null && sheets.length > 0) {
            sheetname = sheets[sheets.length - 1];
        }
        return sheetname;
    }

    public Boundsheet[] getSheets(WorkBook b) {
        Boundsheet[] bsa = b.getExternSheet().getBoundSheets(this.ixti);
        if (bsa[0] == null) {
            Logger.logErr("PtgArea3d.getSheet: Unresolved External Worksheet");
        }
        return bsa;
    }

    public void init(byte[] b, XLSRecord parent) {
        this.ixti = ByteTools.readShort(b[1], b[2]);
        this.record = b;
        this.setParentRec(parent);
        this.populateVals();
    }

    @Override
    public void populateVals() {
        byte[] temp1 = new byte[7];
        byte[] temp2 = new byte[7];
        try {
            temp1[0] = 58;
            temp1[1] = this.record[1];
            temp1[2] = this.record[2];
            temp1[3] = this.record[3];
            temp1[4] = this.record[4];
            temp1[5] = this.record[7];
            temp1[6] = this.record[8];
            temp2[0] = 58;
            temp2[1] = this.record[1];
            temp2[2] = this.record[2];
            temp2[3] = this.record[5];
            temp2[4] = this.record[6];
            temp2[5] = this.record[9];
            temp2[6] = this.record[10];
        }
        catch (Exception e) {
            return;
        }
        this.firstPtg = new PtgRef3d(false);
        this.firstPtg.setParentRec(this.parent_rec);
        this.firstPtg.setSheetName(this.getSheetName());
        this.firstPtg.init(temp1);
        this.lastPtg = new PtgRef3d(false);
        this.lastPtg.setParentRec(this.parent_rec);
        this.lastPtg.setSheetName(this.getLastSheetName());
        this.lastPtg.init(temp2);
        this.isExternalRef = ((PtgRef3d)this.firstPtg).isExternalLink() || ((PtgRef3d)this.lastPtg).isExternalLink();
        this.setWholeRowCol();
        this.fColRel = this.firstPtg.isColRel();
        this.fRwRel = this.firstPtg.isRowRel();
        if (this.parent_rec != null && this.parent_rec instanceof Shrfmla) {
            this.lastPtg.formulaRow = ((Shrfmla)this.parent_rec).getLastRow();
            this.lastPtg.formulaCol = ((Shrfmla)this.parent_rec).getLastCol();
        }
        this.hashcode = super.getHashCode();
    }

    @Override
    public void setLocation(String address) {
        String[] s = ExcelTools.stripSheetNameFromRange(address);
        this.setLocation(s);
    }

    @Override
    public void setLocation(String[] s) {
        try {
            if (this.useReferenceTracker && this.locax != null) {
                this.removeFromRefTracker();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String sheetname2 = null;
        String range = "";
        range = s[1];
        if (s[0] != null) {
            this.sheetname = s[0];
            sheetname2 = s[2];
            if (sheetname2 == null) {
                sheetname2 = this.sheetname;
            }
            WorkBook b = null;
            Externsheet xsht = null;
            if (this.parent_rec != null && (b = this.parent_rec.getWorkBook()) == null) {
                b = this.parent_rec.getSheet().getWorkBook();
            }
            try {
                int boundnum;
                xsht = b.getExternSheet();
                int boundnum2 = boundnum = b.getWorkSheetByName(this.sheetname).getSheetNum();
                if (!this.sheetname.equals(sheetname2) && sheetname2 != null) {
                    boundnum2 = b.getWorkSheetByName(sheetname2).getSheetNum();
                }
                this.setIxti((short)xsht.insertLocation(boundnum, boundnum2));
            }
            catch (WorkSheetNotFoundException e) {
                try {
                    int boundnum = xsht.getXtiReference(s[0], s[0]);
                    if (boundnum == -1) {
                        this.setIxti((short)xsht.insertLocation(boundnum, boundnum));
                    } else {
                        this.setIxti((short)boundnum);
                        this.isExternalRef = true;
                    }
                }
                catch (Exception exception) {}
            }
        } else if (this.parent_rec != null) {
            this.sheetname = sheetname2 = this.parent_rec.getSheet().getSheetName();
        }
        int i = range.indexOf(":");
        if (i < 0) {
            range = String.valueOf(range) + ":" + range;
            i = range.indexOf(":");
        }
        String firstcell = range.substring(0, i);
        String lastcell = range.substring(i + 1);
        if (this.sheetname != null) {
            firstcell = String.valueOf(this.sheetname) + "!" + firstcell;
        }
        if (sheetname2 != null) {
            lastcell = String.valueOf(sheetname2) + "!" + lastcell;
        }
        if (s[3] != null) {
            firstcell = String.valueOf(s[3]) + firstcell;
        }
        if (s[4] != null) {
            lastcell = String.valueOf(s[4]) + lastcell;
        }
        if (this.firstPtg == null) {
            this.firstPtg = new PtgRef3d(false);
            this.firstPtg.setParentRec(this.getParentRec());
        }
        this.firstPtg.sheetname = this.sheetname;
        ((PtgRef3d)this.firstPtg).setLocation(firstcell);
        ((PtgRef3d)this.firstPtg).setIxti(this.ixti);
        if (this.lastPtg == null) {
            this.lastPtg = new PtgRef3d(false);
            this.lastPtg.setParentRec(this.getParentRec());
        }
        this.lastPtg.sheetname = sheetname2;
        ((PtgRef3d)this.lastPtg).setLocation(lastcell);
        ((PtgRef3d)this.lastPtg).setIxti(this.ixti);
        this.setWholeRowCol();
        this.updateRecord();
        this.fRwRel = this.firstPtg.fRwRel;
        this.fColRel = this.firstPtg.fColRel;
        this.hashcode = this.getHashCode();
        if (this.useReferenceTracker) {
            if (!this.getIsWholeCol() && !this.getIsWholeRow()) {
                this.addToRefTracker();
            } else {
                this.useReferenceTracker = false;
            }
        }
    }

    @Override
    public int[] getIntLocation() {
        int[] first = this.firstPtg.getIntLocation();
        int[] last = this.lastPtg.getIntLocation();
        int[] returning = new int[4];
        System.arraycopy(first, 0, returning, 0, 2);
        System.arraycopy(last, 0, returning, 2, 2);
        return returning;
    }

    @Override
    public boolean contains(CellHandle ch) {
        String chsheet = ch.getWorkSheetName();
        this.getSheetName();
        if (!chsheet.equalsIgnoreCase(this.sheetname)) {
            return false;
        }
        String adr = ch.getCellAddress();
        int[] rc = ExcelTools.getRowColFromString(adr);
        return this.contains(rc);
    }

    public void setReferencedSheet(Boundsheet b) {
        ((PtgRef3d)this.firstPtg).setReferencedSheet(b);
        ((PtgRef3d)this.lastPtg).setReferencedSheet(b);
        int boundnum = b.getSheetNum();
        Externsheet xsht = b.getWorkBook().getExternSheet(true);
        try {
            this.sheetname = null;
            int xloc = xsht.insertLocation(boundnum, boundnum);
            this.setIxti((short)xloc);
        }
        catch (WorkSheetNotFoundException e) {
            Logger.logErr("Unable to set referenced sheet in PtgRef3d " + e);
        }
    }

    public Object[] getAllVals() {
        return null;
    }

    @Override
    public void updateRecord() {
        this.comps = null;
        byte[] first = this.firstPtg.getRecord();
        byte[] last = this.lastPtg.getRecord();
        if (this.wholeRow) {
            first[5] = 0;
        }
        if (this.wholeCol) {
            first[3] = 0;
            first[4] = 0;
        }
        byte[] newrecord = new byte[11];
        newrecord[0] = 59;
        System.arraycopy(first, 1, newrecord, 1, 2);
        System.arraycopy(first, 3, newrecord, 3, 2);
        System.arraycopy(last, 3, newrecord, 5, 2);
        System.arraycopy(first, 5, newrecord, 7, 2);
        System.arraycopy(last, 5, newrecord, 9, 2);
        this.record = newrecord;
        if (this.parent_rec != null) {
            if (this.parent_rec instanceof Formula) {
                ((Formula)this.parent_rec).updateRecord();
            } else if (this.parent_rec instanceof Name) {
                ((Name)this.parent_rec).updatePtgs();
            }
        }
    }

    @Override
    public int getLength() {
        return 11;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Ptg[] getComponents() {
        block13: {
            if (this.comps != null) {
                return this.comps;
            }
            components = new ArrayList<PtgRef3d>();
            sht = "";
            if (this.toString().indexOf("!") > -1) {
                sht = this.toString();
                sht = String.valueOf(sht.substring(0, sht.indexOf("!"))) + "!";
            }
            startrow = 0;
            startcol = 0;
            endrow = 0;
            endcol = 0;
            if (this.wholeCol || this.wholeRow) break block13;
            startloc = this.firstPtg.getRealIntLocation();
            startcol = startloc[1];
            startrow = startloc[0];
            endloc = this.lastPtg.getRealIntLocation();
            endcol = endloc[1];
            endrow = endloc[0];
            ** GOTO lbl54
        }
        if (!this.wholeRow) ** GOTO lbl32
        startcol = 0;
        try {
            endcol = this.getSheet().getMaxCol();
        }
        catch (NullPointerException ne) {
            return null;
        }
        try {
            startrow = endrow = this.firstPtg.rw;
            ** GOTO lbl54
lbl32:
            // 1 sources

            if (!this.wholeCol) ** GOTO lbl54
            startrow = 0;
            startcol = endcol = this.firstPtg.col;
            try {
                endrow = this.getSheet().getMaxRow();
                if (true) ** GOTO lbl54
            }
            catch (NullPointerException ne) {
                return null;
            }
        }
        catch (Exception e) {
            Logger.logErr("calculating range value in PtgArea3d failed.", e);
        }
        {
            do {
                rowholder = startrow;
                while (rowholder <= endrow) {
                    displaycol = ExcelTools.getAlphaVal(startcol);
                    displayrow = rowholder + 1;
                    loc = String.valueOf(sht) + displaycol + displayrow;
                    pref = new PtgRef3d(false);
                    pref.setParentRec(this.parent_rec);
                    pref.setLocation(loc);
                    components.add(pref);
                    ++rowholder;
                }
                ++startcol;
lbl54:
                // 5 sources

            } while (startcol <= endcol);
        }
        pref = new PtgRef[components.size()];
        components.toArray(pref);
        this.comps = pref;
        return this.comps;
    }

    @Override
    public void setColRel(boolean relative) {
        this.fColRel = relative;
        this.firstPtg.setColRel(relative);
        this.lastPtg.setColRel(relative);
        this.updateRecord();
    }

    @Override
    public void setRowRel(boolean relative) {
        if (this.fRwRel != relative) {
            this.fRwRel = relative;
            this.firstPtg.setRowRel(relative);
            this.lastPtg.setRowRel(relative);
            this.updateRecord();
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.comps != null) {
            int i = 0;
            while (i < this.comps.length) {
                ((GenericPtg)this.comps[i]).close();
                this.comps[i] = null;
                ++i;
            }
        }
    }
}

