/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.ExtenXLS.DateConverter;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.FormulaNotFoundException;
import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.CalculationException;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgBool;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgInt;
import com.extentech.formats.XLS.formulas.PtgName;
import com.extentech.formats.XLS.formulas.PtgNameX;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.XLS.formulas.PtgRefN;
import com.extentech.formats.XLS.formulas.PtgStr;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.Calendar;

public abstract class GenericPtg
implements Ptg,
Cloneable {
    double doublePrecision = 1.0E-8;
    public static final long serialVersionUID = 666555444333222L;
    byte ptgId;
    byte[] record;
    Ptg[] vars = null;
    int lock_id = -1;
    private int locationLocked = 0;
    private BiffRec trackercell = null;
    protected XLSRecord parent_rec;

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public int getLock() {
        return this.lock_id;
    }

    @Override
    public void setLock(int x) {
        this.lock_id = x;
    }

    @Override
    public boolean getIsOperator() {
        return false;
    }

    @Override
    public boolean getIsBinaryOperator() {
        return false;
    }

    @Override
    public boolean getIsUnaryOperator() {
        return false;
    }

    @Override
    public boolean getIsStandAloneOperator() {
        return false;
    }

    @Override
    public boolean getIsPrimitiveOperator() {
        return false;
    }

    @Override
    public boolean getIsOperand() {
        return false;
    }

    @Override
    public boolean getIsFunction() {
        return false;
    }

    @Override
    public boolean getIsControl() {
        return false;
    }

    @Override
    public boolean getIsArray() {
        return false;
    }

    @Override
    public boolean getIsReference() {
        return false;
    }

    @Override
    public int getLocationPolicy() {
        return this.locationLocked;
    }

    @Override
    public void setLocationPolicy(int b) {
        this.locationLocked = b;
    }

    @Override
    public void updateRecord() {
    }

    @Override
    public int getNumParams() {
        if (this.getIsPrimitiveOperator()) {
            return 2;
        }
        return 0;
    }

    @Override
    public void setVars(Ptg[] parr) {
        this.vars = parr;
    }

    @Override
    public Ptg[] getComponents() {
        return null;
    }

    @Override
    public Object evaluate(Object[] obj) {
        return this.getString();
    }

    @Override
    public String getTextString() {
        String strx = "";
        try {
            strx = this.getString();
        }
        catch (Exception e) {
            Logger.logErr("Function not supported: " + this.parent_rec.toString());
        }
        if (strx == null) {
            return "";
        }
        StringBuffer out = new StringBuffer(strx);
        if (this.vars != null) {
            int numvars = this.vars.length;
            if (this.getIsPrimitiveOperator() && this.getIsUnaryOperator()) {
                if (numvars > 0) {
                    out.append(this.vars[0].getTextString());
                }
            } else if (this.getIsPrimitiveOperator()) {
                out.setLength(0);
                int x = 0;
                while (x < numvars) {
                    out.append(this.vars[x].getTextString());
                    if (x + 1 < numvars) {
                        out.append(this.getString());
                    }
                    ++x;
                }
            } else if (this.getIsControl()) {
                int x = 0;
                while (x < numvars) {
                    out.append(this.vars[x].getTextString());
                    ++x;
                }
            } else {
                int x = 0;
                while (x < this.vars.length) {
                    if (x != 0 || !(this.vars[x] instanceof PtgNameX)) {
                        String part = this.vars[x].getTextString();
                        out.append(part);
                        out.append(",");
                    }
                    ++x;
                }
                if (this.vars.length > 0) {
                    out.setLength(out.length() - 1);
                }
            }
        }
        out.append(this.getString2());
        return out.toString();
    }

    @Override
    public String getString() {
        return this.toString();
    }

    @Override
    public String getString2() {
        if (this.getIsPrimitiveOperator()) {
            return "";
        }
        if (this.getIsOperator()) {
            return ")";
        }
        return "";
    }

    @Override
    public byte getOpcode() {
        return this.ptgId;
    }

    public void init(byte[] b) {
        this.ptgId = b[0];
        this.record = b;
    }

    @Override
    public Ptg calculatePtg(Ptg[] parsething) throws FunctionNotSupportedException, CalculationException {
        return null;
    }

    @Override
    public Ptg getPtgVal() {
        Object value = this.getValue();
        if (value instanceof Ptg) {
            return (Ptg)value;
        }
        if (value instanceof Boolean) {
            return new PtgBool((Boolean)value);
        }
        if (value instanceof Integer) {
            return new PtgInt((Integer)value);
        }
        if (value instanceof Number) {
            return new PtgNumber(((Number)value).doubleValue());
        }
        if (value instanceof String) {
            return new PtgStr((String)value);
        }
        return new PtgErr(PtgErr.ERROR_VALUE);
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public int getIntVal() {
        try {
            return new Double(this.getValue().toString()).intValue();
        }
        catch (NumberFormatException e) {
            if (!(this instanceof PtgErr)) {
                Logger.logErr("GetIntVal failed for formula: " + this.getParentRec().toString() + " " + e);
            }
            return 0;
        }
    }

    @Override
    public double getDoubleVal() {
        Double d;
        block12: {
            Object pob;
            block11: {
                pob = null;
                d = null;
                pob = this.getValue();
                if (pob != null) break block11;
                Logger.logErr("Unable to calculate Formula at " + this.getLocation());
                return Double.NaN;
            }
            try {
                d = (Double)pob;
            }
            catch (ClassCastException e) {
                try {
                    Float f = (Float)pob;
                    d = new Double(f.doubleValue());
                }
                catch (ClassCastException e2) {
                    try {
                        Integer in = (Integer)pob;
                        d = new Double(in.doubleValue());
                    }
                    catch (Exception e3) {
                        if (pob == null || pob.toString().equals("")) {
                            d = new Double(0.0);
                            break block12;
                        }
                        try {
                            Double dd = new Double(pob.toString());
                            return dd;
                        }
                        catch (Exception e4) {
                            return Double.NaN;
                        }
                    }
                }
            }
            catch (Throwable exp) {
                Logger.logErr("Unexpected Exception in PtgCalculator.getDoubleValue()", exp);
            }
        }
        return d;
    }

    @Override
    public byte[] getRecord() {
        return this.record;
    }

    @Override
    public void setLocation(String s) {
    }

    @Override
    public String getLocation() throws FormulaNotFoundException {
        return null;
    }

    @Override
    public int[] getIntLocation() throws FormulaNotFoundException {
        return null;
    }

    @Override
    public void setParentRec(XLSRecord f) {
        this.parent_rec = f;
    }

    @Override
    public XLSRecord getParentRec() {
        return this.parent_rec;
    }

    protected static Object[] getValuesFromPtgs(Ptg[] pthings) {
        Object[] obar = new Object[pthings.length];
        int t = 0;
        while (t < obar.length) {
            if (pthings[t] instanceof PtgErr) {
                return null;
            }
            if (pthings[t] instanceof PtgArray) {
                obar[t] = ((PtgArray)pthings[t]).getComponents();
                Object[] v = null;
                try {
                    v = GenericPtg.getValuesFromObjects((Object[])obar[t]);
                }
                catch (NumberFormatException e) {
                    v = GenericPtg.getStringValuesFromPtgs((Ptg[])obar[t]);
                }
                obar[t] = v;
            } else {
                Object[] v;
                Object pval = pthings[t].getValue();
                if (pval instanceof PtgArray) {
                    obar[t] = ((PtgArray)pval).getComponents();
                    v = null;
                    try {
                        v = GenericPtg.getValuesFromObjects((Object[])obar[t]);
                    }
                    catch (NumberFormatException e) {
                        v = GenericPtg.getStringValuesFromPtgs((Ptg[])obar[t]);
                    }
                    obar[t] = v;
                } else if (pval instanceof Name) {
                    obar[t] = ((PtgName)pthings[t]).getComponents();
                    v = null;
                    try {
                        v = GenericPtg.getValuesFromPtgs((Ptg[])obar[t]);
                    }
                    catch (NumberFormatException e) {
                        v = GenericPtg.getStringValuesFromPtgs((Ptg[])obar[t]);
                    }
                    obar[t] = v;
                } else {
                    try {
                        obar[t] = new Double(GenericPtg.getDoubleValueFromObject(pval));
                    }
                    catch (NumberFormatException e) {
                        obar[t] = pval instanceof CalculationException ? ((CalculationException)pval).toString() : (String)pval;
                    }
                }
            }
            ++t;
        }
        return obar;
    }

    protected static double[] getValuesFromObjects(Object[] pthings) throws NumberFormatException {
        double[] returnDbl = new double[pthings.length];
        int i = 0;
        while (i < pthings.length) {
            Object o = pthings[i];
            if (o == null) {
                returnDbl[i] = 0.0;
            } else if (o instanceof Double) {
                returnDbl[i] = (Double)o;
            } else if (o instanceof Integer) {
                returnDbl[i] = ((Integer)o).intValue();
            } else if (o instanceof Boolean) {
                returnDbl[i] = (Boolean)o != false ? 1.0 : 0.0;
            } else if (o instanceof PtgBool) {
                returnDbl[i] = (Boolean)((PtgBool)o).getValue() != false ? 1.0 : 0.0;
            } else if (!(o instanceof PtgErr)) {
                String s = o.toString();
                Double d = new Double(s);
                returnDbl[i] = d;
            }
            ++i;
        }
        return returnDbl;
    }

    public static double getDoubleValue(Object o, XLSRecord parent) throws NumberFormatException {
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o == null || o.toString().equals("")) {
            if (parent != null && parent.getSheet().getWindow2().getShowZeroValues()) {
                return 0.0;
            }
            throw new NumberFormatException();
        }
        return new Double(o.toString());
    }

    public static double getDoubleValueFromObject(Object o) {
        double ret = 0.0;
        if (o == null) {
            ret = 0.0;
        } else if (o instanceof Double) {
            ret = (Double)o;
        } else if (o instanceof Integer) {
            ret = ((Integer)o).intValue();
        } else if (o instanceof Boolean) {
            ret = (Boolean)o != false ? 1.0 : 0.0;
        } else if (!(o instanceof PtgErr)) {
            String s = o.toString();
            if (s.indexOf("/") > -1) {
                try {
                    Calendar c = DateConverter.convertStringToCalendar(s);
                    if (c != null) {
                        ret = DateConverter.getXLSDateVal(c);
                    }
                }
                catch (Exception c) {
                    // empty catch block
                }
            }
            if (ret == 0.0) {
                Double d = new Double(s);
                ret = d;
            }
        }
        return ret;
    }

    protected static String[] getStringValuesFromPtgs(Ptg[] pthings) {
        String[] returnStr = new String[pthings.length];
        int i = 0;
        while (i < pthings.length) {
            if (pthings[i] instanceof PtgErr) {
                return new String[]{"#VALUE!"};
            }
            Object o = pthings[i].getValue();
            if (o != null) {
                try {
                    returnStr[i] = String.valueOf(((Double)o).intValue());
                }
                catch (Exception e) {
                    String s;
                    returnStr[i] = s = o.toString();
                }
            } else {
                returnStr[i] = "null";
            }
            ++i;
        }
        return returnStr;
    }

    @Override
    public void updateAddressFromTrackerCell() {
        this.initTrackerCell();
        BiffRec trk = this.getTrackercell();
        if (trk != null) {
            String nad = trk.getCellAddress();
            this.setLocation(nad);
        }
    }

    @Override
    public void initTrackerCell() {
        if (this.getTrackercell() == null) {
            try {
                BiffRec trk = this.getParentRec().getSheet().getCell(this.getLocation());
                this.setTrackercell(trk);
            }
            catch (Exception e) {
                Logger.logWarn("Formula reference could not initialize:" + e.toString());
            }
        }
    }

    @Override
    public BiffRec getTrackercell() {
        return this.trackercell;
    }

    @Override
    public void setTrackercell(BiffRec trackercell) {
        this.trackercell = trackercell;
    }

    @Override
    public boolean isBlank() {
        return false;
    }

    public static final String qualifySheetname(String s) {
        if (s == null || s.equals("")) {
            return s;
        }
        try {
            if (s.charAt(0) != '\'' && (s.indexOf(32) > -1 || s.indexOf(38) > -1 || s.indexOf(44) > -1 || s.indexOf(40) > -1)) {
                if (s.indexOf("'") == -1) {
                    return "'" + s + "'";
                }
                return "\"" + s + "\"";
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return s;
    }

    public static String qualifyCellAddress(String s) {
        String prefix = "";
        if (s.indexOf("$") == -1) {
            int i = s.indexOf("!");
            if (i > -1) {
                prefix = s.substring(0, i + 1);
                s = s.substring(i + 1);
            }
            s = "$" + s;
            i = 1;
            while (i < s.length() && !Character.isDigit(s.charAt(i++))) {
            }
            if (--i > 0 && i < s.length()) {
                s = String.valueOf(s.substring(0, i)) + "$" + s.substring(i);
            }
        }
        return String.valueOf(prefix) + s;
    }

    public static int getArrayLen(Object o) {
        int len = 0;
        if (o instanceof double[]) {
            len = ((double[])o).length;
        }
        return len;
    }

    public int readRow(byte b0, byte b1) {
        if (this.parent_rec != null && !this.parent_rec.getWorkBook().getIsExcel2007()) {
            int rw = ByteTools.readInt(b0, b1, (byte)0, (byte)0);
            if (rw >= 65535 || rw < 0 || this instanceof PtgRefN) {
                rw = ByteTools.readShort(b0, b1);
            }
            return rw;
        }
        int rw = ByteTools.readInt(b0, b1, (byte)0, (byte)0);
        if (rw == 65535) {
            rw = -1;
            ((PtgRef)this).wholeCol = true;
        }
        return rw;
    }

    @Override
    public void close() {
        this.parent_rec = null;
        this.trackercell = null;
    }
}

