/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.ExtenXLS.DateConverter;
import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgCalculator;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgInt;
import com.extentech.formats.XLS.formulas.PtgMissArg;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.toolkit.Logger;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import java.util.Vector;

public class FinancialCalculator {
    public static boolean DEBUG = false;

    static double yearFrac(int basis, long date0, long date1) {
        GregorianCalendar fromDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(new Long(date0));
        GregorianCalendar toDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(new Long(date1));
        int y0 = fromDate.get(1);
        int y1 = toDate.get(1);
        int d0 = fromDate.get(5);
        int d1 = toDate.get(5);
        int m0 = fromDate.get(2);
        int m1 = toDate.get(2);
        double yearFrac = 1.0;
        if (basis == 0) {
            if (d0 == 31) {
                d0 = 30;
            }
            if (d1 == 31 && d0 >= 30) {
                d1 = 30;
            }
            if (m0 == 1 && d0 >= 28) {
                d0 = 30;
            }
            yearFrac = (double)(360 * (y1 - y0) + 30 * (m1 - m0) + (d1 - d0)) / 360.0;
        } else if (basis == 1) {
            int ndays = 0;
            int i = y0;
            while (i <= y1) {
                ndays += FinancialCalculator.isLeapYear(i) ? 366 : 365;
                ++i;
            }
            yearFrac = i != y0 ? (double)(date1 - date0) / ((double)ndays / (double)(i - y0)) : (double)(date1 - date0);
        } else if (basis == 2) {
            yearFrac = (double)(date1 - date0) / 360.0;
        } else if (basis == 3) {
            yearFrac = (double)(date1 - date0) / 365.0;
        } else if (basis == 4) {
            yearFrac = (double)(360 * (y1 - y0) + 30 * (m1 - m0) + (d1 - d0)) / 360.0;
        }
        return yearFrac;
    }

    static double getDaysInYearFromBasis(int basis, long date0, long date1) {
        double r2 = 0.0;
        switch (basis) {
            case 0: 
            case 2: 
            case 4: {
                r2 = 360.0;
                break;
            }
            case 1: {
                GregorianCalendar fromDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(new Long(date0));
                int y0 = fromDate.get(1);
                if (FinancialCalculator.isLeapYear(y0)) {
                    r2 = 365.4;
                    break;
                }
                r2 = 365.25;
                break;
            }
            case 3: {
                r2 = 365.0;
            }
        }
        return r2;
    }

    static long getDaysFromBasis(int basis, long date0, long date1) {
        if (basis == 0 || basis == 4) {
            GregorianCalendar fromDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(new Long(date0));
            GregorianCalendar toDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(new Long(date1));
            int y0 = fromDate.get(1);
            int y1 = toDate.get(1);
            int d0 = fromDate.get(5);
            int d1 = toDate.get(5);
            int m0 = fromDate.get(2);
            int m1 = toDate.get(2);
            if (basis == 0) {
                if (d0 == 31) {
                    d0 = 30;
                }
                if (d1 == 31 && d0 >= 30) {
                    d1 = 30;
                }
            }
            int result = 360 * (y1 - y0) + 30 * (m1 - m0) + (d1 - d0);
            return result;
        }
        return date1 - date0;
    }

    static int validateDay(int y, int m, int d) {
        if (d > 28) {
            if (m == 1) {
                d = 28;
            } else if ((m == 3 || m == 5 || m == 8 || m == 10) && d == 31) {
                d = 30;
            }
        }
        return d;
    }

    protected static Ptg calcAccrint(Ptg[] operands) throws FunctionNotSupportedException {
        String wn = "WARNING: this version of ExtenXLS does not support the formula ACCRINT.";
        Logger.logWarn(wn);
        throw new FunctionNotSupportedException(wn);
    }

    protected static Ptg calcAccrintm(Ptg[] operands) {
        if (operands.length < 3) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "ACCRINTM");
        }
        try {
            double par = 1000.0;
            int basis = 0;
            GregorianCalendar dt = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            long issueDate = new Double(DateConverter.getXLSDateVal(dt)).longValue();
            dt = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            long maturityDate = new Double(DateConverter.getXLSDateVal(dt)).longValue();
            double rate = operands[2].getDoubleVal();
            if (operands.length > 3 && !(operands[3] instanceof PtgMissArg)) {
                par = operands[3].getDoubleVal();
            }
            if (operands.length > 4) {
                basis = operands[4].getIntVal();
            }
            if (rate <= 0.0 || par <= 0.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (basis < 0 || basis > 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (issueDate > maturityDate) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            double result = par * rate * FinancialCalculator.yearFrac(basis, issueDate, maturityDate);
            if (DEBUG) {
                Logger.logInfo("Result from Accrintm= " + result);
            }
            PtgNumber pnum = new PtgNumber(result);
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcAmordegrc(Ptg[] operands) {
        if (operands.length < 6) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "AMORDEGRC");
        }
        try {
            double cost = operands[0].getDoubleVal();
            GregorianCalendar dP = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            GregorianCalendar fP = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[2].getValue());
            double salvage = operands[3].getDoubleVal();
            int period = operands[4].getIntVal();
            double rate = operands[5].getDoubleVal();
            int basis = operands[6].getIntVal();
            long datePurchased = new Double(DateConverter.getXLSDateVal(dP)).longValue();
            long firstPeriod = new Double(DateConverter.getXLSDateVal(fP)).longValue();
            if (rate <= 0.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (basis < 0 || basis > 4 || basis == 2) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (datePurchased > firstPeriod) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            double life = 1.0 / rate;
            double coefficient = life < 3.0 ? 1.0 : (life < 5.0 ? 1.5 : (life <= 6.0 ? 2.0 : 2.5));
            cost -= FinancialCalculator.yearFrac(basis, datePurchased, firstPeriod) * (rate *= coefficient) * cost;
            double Remainder = cost - salvage;
            double A = 0.0;
            if (Remainder > 0.0) {
                int i = 0;
                while (i < period) {
                    A = rate * cost;
                    if ((Remainder -= A) < 0.0) {
                        if (i + 1 < period) {
                            A = 0.0;
                        }
                        i = period;
                    }
                    cost -= A;
                    ++i;
                }
            } else {
                A = Math.round(rate * salvage);
            }
            double result = Math.max(Math.round(A), 0L);
            if (DEBUG) {
                Logger.logInfo("Result from AMORDEGRC= " + result);
            }
            PtgNumber pnum = new PtgNumber(result);
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcAmorlinc(Ptg[] operands) {
        if (operands.length < 6) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "AMORLINC");
        }
        try {
            double cost = operands[0].getDoubleVal();
            GregorianCalendar dP = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            GregorianCalendar fP = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[2].getValue());
            double salvage = operands[3].getDoubleVal();
            int period = operands[4].getIntVal();
            double rate = operands[5].getDoubleVal();
            int basis = operands[6].getIntVal();
            long datePurchased = new Double(DateConverter.getXLSDateVal(dP)).longValue();
            long firstPeriod = new Double(DateConverter.getXLSDateVal(fP)).longValue();
            if (rate <= 0.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (basis < 0 || basis > 4 || basis == 2) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (datePurchased > firstPeriod) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            double A = 0.0;
            double B = cost - salvage;
            double C = FinancialCalculator.yearFrac(basis, datePurchased, firstPeriod) * rate * cost;
            double D = cost * rate;
            long n = Math.round((cost - salvage - C) / D);
            A = period == 0 || C == 0.0 ? C : ((long)period < n ? D : ((long)period == n ? Math.min(D + (B - D * (double)n - C), D) : ((long)period == n + 1L ? B - D * (double)n - C : 0.0)));
            double result = Math.max(Math.round(A), 0L);
            if (DEBUG) {
                Logger.logInfo("Result from AMORLINC= " + result);
            }
            PtgNumber pnum = new PtgNumber(result);
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcCoupDayBS(Ptg[] operands) {
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "COUPDAYSBS");
        }
        try {
            GregorianCalendar sDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            GregorianCalendar mDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            long settlementDate = new Double(DateConverter.getXLSDateVal(sDate)).longValue();
            long maturityDate = new Double(DateConverter.getXLSDateVal(mDate)).longValue();
            int frequency = operands[2].getIntVal();
            int basis = 0;
            if (operands.length > 3) {
                basis = operands[3].getIntVal();
            }
            if (basis < 0 || basis > 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (frequency != 1 && frequency != 2 && frequency != 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (settlementDate > maturityDate) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            long pcd = PtgCalculator.getLongValue(FinancialCalculator.calcCoupPCD(operands));
            double result = FinancialCalculator.getDaysFromBasis(basis, pcd, settlementDate);
            if (DEBUG) {
                Logger.logInfo("Result from calcCoupDaysBS= " + result);
            }
            PtgNumber pnum = new PtgNumber(result);
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcCoupDays(Ptg[] operands) {
        if (operands.length < 3) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "COUPDAYS");
        }
        try {
            double result;
            GregorianCalendar dt = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            long settlementDate = new Double(DateConverter.getXLSDateVal(dt)).longValue();
            dt = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            long maturityDate = new Double(DateConverter.getXLSDateVal(dt)).longValue();
            int frequency = operands[2].getIntVal();
            int basis = 0;
            if (operands.length > 3) {
                basis = operands[3].getIntVal();
            }
            if (frequency != 1 && frequency != 2 && frequency != 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (basis < 0 || basis > 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (settlementDate > maturityDate) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (basis == 1) {
                long pcd = PtgCalculator.getLongValue(FinancialCalculator.calcCoupPCD(operands));
                long ncd = PtgCalculator.getLongValue(FinancialCalculator.calcCoupNCD(operands));
                result = FinancialCalculator.getDaysFromBasis(basis, pcd, ncd);
            } else {
                result = basis == 0 || basis == 2 || basis == 4 ? 360.0 / (double)frequency : 365.0 / (double)frequency;
            }
            if (DEBUG) {
                Logger.logInfo("Result from calcCoupDays=" + result);
            }
            PtgNumber pnum = new PtgNumber(result);
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcCoupDaysNC(Ptg[] operands) {
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "COUPDAYSNC");
        }
        long settlementDate = new Long(operands[0].getValue().toString());
        long maturityDate = new Long(operands[1].getValue().toString());
        int frequency = operands[2].getIntVal();
        int basis = 0;
        if (operands.length > 3) {
            basis = operands[3].getIntVal();
        }
        if (basis < 0 || basis > 4) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (frequency != 1 && frequency != 2 && frequency != 4) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (settlementDate > maturityDate) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        long ncd = PtgCalculator.getLongValue(FinancialCalculator.calcCoupNCD(operands));
        double result = FinancialCalculator.getDaysFromBasis(basis, settlementDate, ncd);
        if (DEBUG) {
            Logger.logInfo("Result from calcCoupDaysNC= " + result);
        }
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcCoupNCD(Ptg[] operands) {
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "COUPNCD");
        }
        try {
            GregorianCalendar sDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            GregorianCalendar mDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            int frequency = operands[2].getIntVal();
            int basis = 0;
            if (operands.length > 3) {
                basis = operands[3].getIntVal();
            }
            if (basis < 0 || basis > 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (frequency != 1 && frequency != 2 && frequency != 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (!sDate.before(mDate)) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            int mm = mDate.get(2) + 1;
            int sm = sDate.get(2) + 1;
            int y = mDate.get(1);
            int d = mDate.get(5);
            if (frequency == 1) {
                while (sDate.before(new GregorianCalendar(y, mm - 1, d))) {
                    --y;
                }
                ++y;
            }
            if (frequency == 2) {
                while (sDate.before(new GregorianCalendar(y, mm - 1, d))) {
                    if ((mm -= 6) >= 1) continue;
                    mm += 12;
                    --y;
                }
                mm += 6;
            } else if (frequency == 4) {
                while (sDate.before(new GregorianCalendar(y, mm - 1, d))) {
                    if ((mm -= 3) >= 1) continue;
                    mm += 12;
                    --y;
                }
                mm += 3;
            }
            GregorianCalendar resultDate = new GregorianCalendar(y, mm - 1, d);
            double date = DateConverter.getXLSDateVal(resultDate);
            if (DEBUG) {
                Logger.logInfo("Result from calcCoupNCD= " + date + " " + DateFormat.getDateInstance().format(resultDate.getTime()));
            }
            int i = (int)date;
            PtgInt pi = new PtgInt(i);
            return pi;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcCoupNum(Ptg[] operands) {
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "COUPNUM");
        }
        try {
            GregorianCalendar sDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            GregorianCalendar mDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            long settlementDate = new Double(DateConverter.getXLSDateVal(sDate)).longValue();
            long maturityDate = new Double(DateConverter.getXLSDateVal(mDate)).longValue();
            int frequency = operands[2].getIntVal();
            int basis = 0;
            if (operands.length > 3) {
                basis = operands[3].getIntVal();
            }
            if (basis < 0 || basis > 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (frequency != 1 && frequency != 2 && frequency != 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (settlementDate > maturityDate) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            double result = Math.ceil(FinancialCalculator.yearFrac(basis, settlementDate, maturityDate) * (double)frequency);
            if (DEBUG) {
                Logger.logInfo("Result from calcCoupNUM= " + result);
            }
            PtgNumber pnum = new PtgNumber(result);
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcCoupPCD(Ptg[] operands) {
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "COUPPCD");
        }
        try {
            GregorianCalendar sDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            GregorianCalendar mDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            int frequency = operands[2].getIntVal();
            int basis = 0;
            if (operands.length > 3) {
                basis = operands[3].getIntVal();
            }
            if (basis < 0 || basis > 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (frequency != 1 && frequency != 2 && frequency != 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (!sDate.before(mDate)) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            int mm = mDate.get(2) + 1;
            int sm = sDate.get(2) + 1;
            int y = mDate.get(1);
            int d = mDate.get(5);
            if (frequency == 1) {
                while (sDate.before(new GregorianCalendar(y, mm - 1, d))) {
                    --y;
                }
            }
            if (frequency == 2) {
                while (sDate.before(new GregorianCalendar(y, mm - 1, d))) {
                    if ((mm -= 6) >= 1) continue;
                    mm += 12;
                    --y;
                }
            } else if (frequency == 4) {
                while (sDate.before(new GregorianCalendar(y, mm - 1, d))) {
                    if ((mm -= 3) >= 1) continue;
                    mm += 12;
                    --y;
                }
            }
            GregorianCalendar resultDate = new GregorianCalendar(y, mm - 1, d);
            double date = DateConverter.getXLSDateVal(resultDate);
            if (DEBUG) {
                Logger.logInfo("Result from calcCoupPCD= " + date + " " + DateFormat.getDateInstance().format(resultDate.getTime()));
            }
            int i = (int)date;
            PtgInt pi = new PtgInt(i);
            return pi;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcCumIPmt(Ptg[] operands) {
        if (operands.length < 6) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        double rate = operands[0].getDoubleVal();
        double nper = operands[1].getDoubleVal();
        double pv = operands[2].getDoubleVal();
        int startperiod = operands[3].getIntVal();
        int endperiod = operands[4].getIntVal();
        int type = operands[5].getIntVal();
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "CUMIPMT");
        }
        if (rate <= 0.0 || pv <= 0.0 || nper <= 0.0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (startperiod < 1 || endperiod < 1) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (startperiod > endperiod) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (type < 0 || type > 1) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double Rn = Math.pow(1.0 + rate, nper);
        double A = -pv * Rn * rate;
        double B = (Rn - 1.0) * (1.0 + rate * (double)type);
        double pmt = A / B;
        double n = startperiod - 1 - type;
        int period = endperiod - startperiod + 1;
        A = Math.pow(1.0 + rate, n);
        B = pmt * (1.0 + rate * (double)type);
        double fva = -(pv * A + (B *= (Math.pow(1.0 + rate, n) - 1.0) / rate));
        A = Math.pow(1.0 + rate, endperiod - type);
        B = pmt * (1.0 + rate * (double)type);
        double fvb = -(pv * A + (B *= (Math.pow(1.0 + rate, endperiod - type) - 1.0) / rate));
        double result = fva - fvb - pmt * (double)period;
        if (startperiod == 1 && type == 1) {
            result = pmt * (double)period + pv;
        }
        result *= -1.0;
        if (DEBUG) {
            Logger.logInfo("Result from calcCumIPmt= " + result);
        }
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcCumPrinc(Ptg[] operands) {
        if (operands.length < 6) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        double rate = operands[0].getDoubleVal();
        double nper = operands[1].getDoubleVal();
        double pv = operands[2].getDoubleVal();
        int startperiod = operands[3].getIntVal();
        int endperiod = operands[4].getIntVal();
        int type = operands[5].getIntVal();
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "CUMPRINC");
        }
        double Rn = Math.pow(1.0 + rate, nper);
        double A = -pv * Rn * rate;
        double B = (Rn - 1.0) * (1.0 + rate * (double)type);
        double pmt = A / B;
        A = Math.pow(1.0 + rate, startperiod - type - 1);
        B = pmt * (1.0 + rate * (double)type);
        double fva = -(pv * A + (B *= (Math.pow(1.0 + rate, startperiod - type - 1) - 1.0) / rate));
        A = Math.pow(1.0 + rate, endperiod - type);
        B = pmt * (1.0 + rate * (double)type);
        double fvb = -(pv * A + (B *= (Math.pow(1.0 + rate, endperiod - type) - 1.0) / rate));
        double result = fva - fvb;
        if (startperiod == 1 && type == 1) {
            result = pv;
        }
        if (DEBUG) {
            Logger.logInfo("Result from calcCUMPRINC= " + result);
        }
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcDB(Ptg[] operands) {
        double totalDepreciation;
        if (operands.length < 4 || operands[0].getComponents() != null) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_NULL);
            return perr;
        }
        double cost = new Double(String.valueOf(operands[0].getValue()));
        double salvage = new Double(String.valueOf(operands[1].getValue()));
        int life = Integer.valueOf(String.valueOf(operands[2].getValue()));
        int period = Integer.valueOf(String.valueOf(operands[3].getValue()));
        int month = operands.length > 4 ? (operands[4] instanceof PtgMissArg ? 12 : Integer.valueOf(String.valueOf(operands[4].getValue()))) : 12;
        double salCost = salvage / cost;
        double lifdiv = 1.0;
        double rate = Math.pow(salCost, lifdiv /= (double)life);
        rate = 1.0 - rate;
        rate *= 1000.0;
        rate = Math.round(rate);
        double result = totalDepreciation = cost * (rate /= 1000.0) * (double)month / 12.0;
        int i = 2;
        while (i < period || i == period && period <= life) {
            result = (cost - totalDepreciation) * rate;
            totalDepreciation += (cost - totalDepreciation) * rate;
            ++i;
        }
        if (period > life) {
            result = (cost - totalDepreciation) * rate * (double)(12 - month) / 12.0;
        }
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcDDB(Ptg[] operands) {
        if (operands.length < 4 || operands[0].getComponents() != null) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_NULL);
            return perr;
        }
        double cost = new Double(String.valueOf(operands[0].getValue()));
        double salvage = new Double(String.valueOf(operands[1].getValue()));
        int life = Integer.valueOf(String.valueOf(operands[2].getValue()));
        int period = Integer.valueOf(String.valueOf(operands[3].getValue()));
        int factor = 2;
        if (operands.length > 4 && !(operands[4] instanceof PtgMissArg)) {
            factor = Integer.valueOf(String.valueOf(operands[4].getValue()));
        }
        double salCost = salvage / cost;
        double facLife = (double)factor / (double)life;
        double totalDepreciation = 0.0;
        int i = 1;
        while (i < period) {
            totalDepreciation += (cost - totalDepreciation) * facLife;
            ++i;
        }
        double result = 0.0;
        if (cost - salvage - totalDepreciation > 0.0) {
            result = (cost - totalDepreciation) * facLife;
        }
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcDISC(Ptg[] operands) {
        if (operands.length < 4) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcDISC");
        }
        try {
            GregorianCalendar sDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            GregorianCalendar mDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            long settlementDate = new Double(DateConverter.getXLSDateVal(sDate)).longValue();
            long maturityDate = new Double(DateConverter.getXLSDateVal(mDate)).longValue();
            double pr = operands[2].getDoubleVal();
            double redemption = operands[3].getDoubleVal();
            int basis = 0;
            if (operands.length > 4) {
                basis = operands[4].getIntVal();
            }
            if (basis < 0 || basis > 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (settlementDate > maturityDate) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (pr <= 0.0 || redemption <= 0.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            double result = (redemption - pr) / (redemption * FinancialCalculator.yearFrac(basis, settlementDate, maturityDate));
            PtgNumber pnum = new PtgNumber(result);
            if (DEBUG) {
                Logger.logInfo("Result from calcDISC= " + result);
            }
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcDollarDE(Ptg[] operands) {
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcDOLLARDE");
        }
        double fractional_dollar = operands[0].getDoubleVal();
        int fraction = operands[1].getIntVal();
        if (fraction < 0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (fraction == 0) {
            return new PtgErr(PtgErr.ERROR_DIV_ZERO);
        }
        int n = String.valueOf(fraction).length();
        double x = Math.floor(fractional_dollar);
        double y = (fractional_dollar - x) * Math.pow(10.0, n);
        double result = x + y / (double)fraction;
        PtgNumber pnum = new PtgNumber(result);
        if (DEBUG) {
            Logger.logInfo("Result from calcDOLLARDE= " + result);
        }
        return pnum;
    }

    protected static Ptg calcDollarFR(Ptg[] operands) {
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcDOLLARFR");
        }
        double decimal_dollar = operands[0].getDoubleVal();
        int fraction = operands[1].getIntVal();
        if (fraction < 0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (fraction == 0) {
            return new PtgErr(PtgErr.ERROR_DIV_ZERO);
        }
        int n = String.valueOf(fraction).length();
        double x = Math.floor(decimal_dollar);
        double y = decimal_dollar - x;
        double result = x + y * (double)fraction / Math.pow(10.0, n);
        PtgNumber pnum = new PtgNumber(result);
        if (DEBUG) {
            Logger.logInfo("Result from calcDOLLARFR= " + result);
        }
        return pnum;
    }

    protected static Ptg calcDURATION(Ptg[] operands) {
        if (operands.length < 5) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcDURATION");
        }
        try {
            GregorianCalendar sDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            GregorianCalendar mDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            double coupon = operands[2].getDoubleVal();
            double yld = operands[3].getDoubleVal();
            int frequency = operands[4].getIntVal();
            int basis = 0;
            if (operands.length > 5) {
                basis = operands[5].getIntVal();
            }
            if (basis < 0 || basis > 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (!sDate.before(mDate)) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (coupon < 0.0 || yld < 0.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (frequency != 1 && frequency != 2 && frequency != 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            long settlementDate = new Double(DateConverter.getXLSDateVal(sDate)).longValue();
            long maturityDate = new Double(DateConverter.getXLSDateVal(mDate)).longValue();
            Ptg[] ops = new Ptg[]{operands[0], operands[1], operands[4], new PtgInt(basis)};
            double n = FinancialCalculator.calcCoupNum(ops).getDoubleVal();
            double DSC = FinancialCalculator.calcCoupDaysNC(ops).getDoubleVal();
            double E = FinancialCalculator.calcCoupDays(ops).getDoubleVal();
            double F = DSC / E;
            double R2 = coupon * 100.0;
            double Y = 1.0 + yld / (double)frequency;
            double Yx = Math.pow(Y, n - 1.0 + F);
            double SumA = 0.0;
            int i = 1;
            while ((double)i <= n) {
                SumA += R2 * ((double)(i - 1) + F) / (Math.pow(Y, (double)(i - 1) + F) * (double)frequency);
                ++i;
            }
            double SumB = 0.0;
            int i2 = 1;
            while ((double)i2 <= n) {
                SumB += R2 / (Math.pow(Y, (double)(i2 - 1) + F) * (double)frequency);
                ++i2;
            }
            double C = 0.0;
            double D = 0.0;
            if (n > 1.0) {
                C = (n - 1.0 + F) * 100.0 / Yx;
                D = 100.0 / Yx;
            }
            double result = (SumA + C) / ((SumB + D) * (double)frequency);
            PtgNumber pnum = new PtgNumber(result);
            if (DEBUG) {
                Logger.logInfo("Result from calcDURATION= " + result);
            }
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcEffect(Ptg[] operands) {
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcEFFECT");
        }
        double nominal_rate = operands[0].getDoubleVal();
        int npery = operands[1].getIntVal();
        if (npery <= 0 || npery < 1) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double x = nominal_rate / (double)npery;
        double result = Math.pow(1.0 + x, npery) - 1.0;
        PtgNumber pnum = new PtgNumber(result);
        if (DEBUG) {
            Logger.logInfo("Result from calcEFFECT= " + result);
        }
        return pnum;
    }

    protected static Ptg calcFV(Ptg[] operands) {
        if (operands.length < 3) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcFV");
        }
        double rate = operands[0].getDoubleVal();
        int nper = operands[1].getIntVal();
        double pmt = operands[2].getDoubleVal();
        double pv = 0.0;
        int type = 0;
        if (operands.length > 3 && !(operands[3] instanceof PtgMissArg)) {
            pv = operands[3].getDoubleVal();
        }
        if (operands.length > 4) {
            type = operands[4].getIntVal();
        }
        double A = Math.pow(1.0 + rate, nper);
        double B = pmt * (1.0 + rate * (double)type);
        double result = -(pv * A + (B *= (Math.pow(1.0 + rate, nper) - 1.0) / rate));
        PtgNumber pnum = new PtgNumber(result);
        if (DEBUG) {
            Logger.logInfo("Result from calcFV= " + result);
        }
        return pnum;
    }

    protected static Ptg calcFVSCHEDULE(Ptg[] operands) {
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcFVSCHEDULE");
        }
        double principal = operands[0].getDoubleVal();
        Ptg[] schedule = PtgCalculator.getAllComponents(operands[1]);
        if (DEBUG) {
            FinancialCalculator.debugOperands(schedule, "calcFVSCHEDULE");
        }
        double result = 1.0;
        int i = 0;
        while (i < schedule.length) {
            result *= principal + schedule[i].getDoubleVal();
            ++i;
        }
        PtgNumber pnum = new PtgNumber(result);
        if (DEBUG) {
            Logger.logInfo("Result from calcFVSCHEDULE= " + result);
        }
        return pnum;
    }

    protected static Ptg calcINTRATE(Ptg[] operands) {
        if (operands.length < 4) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcINTRATE");
        }
        try {
            GregorianCalendar sDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            GregorianCalendar mDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            double investment = operands[2].getDoubleVal();
            double redemption = operands[3].getDoubleVal();
            int basis = 0;
            if (operands.length > 4) {
                basis = operands[4].getIntVal();
            }
            if (basis < 0 || basis > 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (!sDate.before(mDate)) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (investment <= 0.0 || redemption <= 0.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            long settlementDate = new Double(DateConverter.getXLSDateVal(sDate)).longValue();
            long maturityDate = new Double(DateConverter.getXLSDateVal(mDate)).longValue();
            double result = (redemption - investment) / investment / FinancialCalculator.yearFrac(basis, settlementDate, maturityDate);
            PtgNumber pnum = new PtgNumber(result);
            if (DEBUG) {
                Logger.logInfo("Result from calcINTRATE= " + result);
            }
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcIPMT(Ptg[] operands) {
        if (operands.length < 4) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcIPMT");
        }
        double rate = operands[0].getDoubleVal();
        double per = operands[1].getDoubleVal();
        double nper = operands[2].getDoubleVal();
        double pv = operands[3].getDoubleVal();
        double fv = 0.0;
        int type = 0;
        if (operands.length > 4 && !(operands[4] instanceof PtgMissArg)) {
            fv = operands[4].getDoubleVal();
        }
        if (operands.length > 5) {
            type = operands[5].getIntVal();
        }
        if (per < 0.0 || per > nper) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double n = type == 0 ? per : per - 1.0;
        double Rn = Math.pow(1.0 + rate, nper);
        double A = -fv * rate - pv * Rn * rate;
        double B = (Rn - 1.0) * (1.0 + rate * (double)type);
        double pmt = A / B;
        A = Math.pow(1.0 + rate, n);
        B = pmt * (1.0 + rate * (double)type);
        double fva = -(pv * A + (B *= (Math.pow(1.0 + rate, n) - 1.0) / rate));
        A = Math.pow(1.0 + rate, n - 1.0);
        B = pmt * (1.0 + rate * (double)type);
        double fvb = -(pv * A + (B *= (Math.pow(1.0 + rate, n - 1.0) - 1.0) / rate));
        double result = pmt - (fvb - fva);
        PtgNumber pnum = new PtgNumber(result);
        if (DEBUG) {
            Logger.logInfo("Result from calcIPMT= " + result);
        }
        return pnum;
    }

    protected static Ptg calcIRR(Ptg[] operands) {
        if (operands.length < 1 || operands[0].getComponents() == null) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_NULL);
            return perr;
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcIRR");
        }
        double guess = 0.1;
        if (operands.length > 1) {
            guess = operands[1].getDoubleVal();
        }
        Ptg[] params = PtgCalculator.getAllComponents(operands);
        if (DEBUG) {
            FinancialCalculator.debugOperands(params, "calcIRR");
        }
        int n = params.length;
        double outflow = 0.0;
        double inflow = 0.0;
        int i = 0;
        while (i < n) {
            double val = params[i].getDoubleVal();
            if (val < 0.0) {
                outflow += Math.abs(val);
            } else {
                inflow += val;
            }
            ++i;
        }
        if (outflow == 0.0 || inflow == 0.0) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        double TOLERANCE = 1.0E-7;
        boolean bIsCorrect = false;
        double trial = guess;
        double xl = 0.0;
        double xh = guess;
        double delta = xh - xl;
        double fl = outflow - inflow;
        double fh = outflow;
        int i2 = 0;
        while (i2 < n) {
            double val = params[i2].getDoubleVal();
            if (val > 0.0) {
                fh -= val / Math.pow(1.0 + xh, i2);
            }
            ++i2;
        }
        int j = 0;
        while (j < 50 && !bIsCorrect) {
            trial = xl + delta * fl / (fl - fh);
            double f = outflow;
            int i3 = 0;
            while (i3 < n) {
                double val = params[i3].getDoubleVal();
                if (val > 0.0) {
                    f -= val / Math.pow(1.0 + trial, i3);
                }
                ++i3;
            }
            if (f < 0.0) {
                delta = xl - trial;
                xl = trial;
                fl = f;
            } else {
                delta = xh - trial;
                xh = trial;
                fh = f;
            }
            bIsCorrect = Math.abs(delta) <= 1.0E-7;
            delta = xh - xl;
            ++j;
        }
        if (!bIsCorrect) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (DEBUG) {
            Logger.logInfo("Result from calcIRR= " + trial);
        }
        PtgNumber pnum = new PtgNumber(trial);
        return pnum;
    }

    protected static Ptg calcISPMT(Ptg[] operands) {
        if (operands.length < 4) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcISPMT");
        }
        double rate = operands[0].getDoubleVal();
        double per = operands[1].getDoubleVal();
        double nper = operands[2].getDoubleVal();
        double pv = operands[3].getDoubleVal();
        if (per < 0.0 || per > nper) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double result = -pv * rate * (nper - per) / nper;
        PtgNumber pnum = new PtgNumber(result);
        if (DEBUG) {
            Logger.logInfo("Result from calcISPMT= " + result);
        }
        return pnum;
    }

    protected static Ptg calcMDURATION(Ptg[] operands) {
        if (operands.length < 5) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcMDURATION");
        }
        try {
            GregorianCalendar sDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            GregorianCalendar mDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            double coupon = operands[2].getDoubleVal();
            double yld = operands[3].getDoubleVal();
            int frequency = operands[4].getIntVal();
            int basis = 0;
            if (operands.length > 5) {
                basis = operands[5].getIntVal();
            }
            if (basis < 0 || basis > 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (!sDate.before(mDate)) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (coupon < 0.0 || yld < 0.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (frequency != 1 && frequency != 2 && frequency != 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            double result = FinancialCalculator.calcDURATION(operands).getDoubleVal();
            PtgNumber pnum = new PtgNumber(result /= 1.0 + yld / (double)frequency);
            if (DEBUG) {
                Logger.logInfo("Result from calcMDURATION= " + result);
            }
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcMIRR(Ptg[] operands) {
        if (operands.length < 3) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcMIRR");
        }
        double finance_rate = operands[1].getDoubleVal();
        double reinvest_rate = operands[2].getDoubleVal();
        Ptg[] params = PtgCalculator.getAllComponents(operands);
        if (DEBUG) {
            FinancialCalculator.debugOperands(params, "calcMIRR");
        }
        Vector<Ptg> posVals = new Vector<Ptg>();
        Vector<Ptg> negVals = new Vector<Ptg>();
        int n = params.length - 2;
        int i = 0;
        while (i < n) {
            double val = params[i].getDoubleVal();
            if (val < 0.0) {
                negVals.addElement(params[i]);
            } else {
                posVals.addElement(params[i]);
            }
            ++i;
        }
        Ptg[] positiveValues = new Ptg[posVals.size() + 1];
        Ptg[] negativeValues = new Ptg[negVals.size() + 1];
        System.arraycopy(posVals.toArray(), 0, positiveValues, 1, posVals.size());
        System.arraycopy(negVals.toArray(), 0, negativeValues, 1, negVals.size());
        positiveValues[0] = operands[2];
        negativeValues[0] = operands[1];
        double X = FinancialCalculator.calcNPV(positiveValues).getDoubleVal();
        X = -1.0 * X * Math.pow(1.0 + reinvest_rate, posVals.size());
        double Y = FinancialCalculator.calcNPV(negativeValues).getDoubleVal();
        double result = Math.pow(X / (Y *= 1.0 + finance_rate), 1.0 / (double)(n - 1)) - 1.0;
        if (DEBUG) {
            Logger.logInfo("Result from calcMIRR= " + result);
        }
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcNominal(Ptg[] operands) {
        if (operands.length < 2) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_NULL);
            return perr;
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcNominal");
        }
        double effect = operands[0].getDoubleVal();
        int npery = operands[1].getIntVal();
        if (effect <= 0.0 || npery < 1) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double y = effect + 1.0;
        double log10y = Math.log(y) / Math.log(10.0);
        double z = Math.pow(10.0, log10y / (double)npery);
        double result = (z - 1.0) * (double)npery;
        if (DEBUG) {
            Logger.logInfo("Result from calcNominal= " + result);
        }
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcNPER(Ptg[] operands) {
        if (operands.length < 3) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_NULL);
            return perr;
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcNPER");
        }
        double rate = operands[0].getDoubleVal();
        double pmt = operands[1].getDoubleVal();
        double pv = operands[2].getDoubleVal();
        double fv = 0.0;
        if (operands.length > 3 && !(operands[3] instanceof PtgMissArg)) {
            fv = operands[3].getDoubleVal();
        }
        int type = 0;
        if (operands.length > 4) {
            type = operands[4].getIntVal();
        }
        double A = pmt * (1.0 + (double)type * rate) - rate * fv;
        double B = pmt * (1.0 + (double)type * rate) + rate * pv;
        double C = 1.0 + rate;
        double result = Math.log(A / B) / Math.log(C);
        if (DEBUG) {
            Logger.logInfo("Result from calcNPER= " + result);
        }
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcNPV(Ptg[] operands) {
        if (operands.length < 2 || operands[0].getComponents() != null) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_NULL);
            return perr;
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcNPV");
        }
        Ptg[] params = PtgCalculator.getAllComponents(operands);
        if (DEBUG) {
            FinancialCalculator.debugOperands(params, "calcNPV");
        }
        double rate = params[0].getDoubleVal();
        int n = Math.min(params.length, 30);
        double result = 0.0;
        int i = 1;
        while (i < n) {
            double valuei = params[i].getDoubleVal();
            result += valuei / Math.pow(1.0 + rate, i);
            ++i;
        }
        if (DEBUG) {
            Logger.logInfo("Result from calcNPV= " + result);
        }
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcODDFPRICE(Ptg[] operands) throws FunctionNotSupportedException {
        String wn = "WARNING: this version of ExtenXLS does not support the formula ODDFPRICE.";
        Logger.logWarn(wn);
        throw new FunctionNotSupportedException(wn);
    }

    protected static Ptg calcODDFYIELD(Ptg[] operands) throws FunctionNotSupportedException {
        String wn = "WARNING: this version of ExtenXLS does not support the formula ODDFYIELD.";
        Logger.logWarn(wn);
        throw new FunctionNotSupportedException(wn);
    }

    protected static Ptg calcODDLPRICE(Ptg[] operands) throws FunctionNotSupportedException {
        String wn = "WARNING: this version of ExtenXLS does not support the formula ODDLPRICE.";
        Logger.logWarn(wn);
        throw new FunctionNotSupportedException(wn);
    }

    protected static Ptg calcODDLYIELD(Ptg[] operands) throws FunctionNotSupportedException {
        String wn = "WARNING: this version of ExtenXLS does not support the formula ODDLYIELD.";
        Logger.logWarn(wn);
        throw new FunctionNotSupportedException(wn);
    }

    protected static Ptg calcPmt(Ptg[] operands) {
        if (operands.length < 3) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_NULL);
            return perr;
        }
        double rate = new Double(String.valueOf(operands[0].getValue()));
        double nper = new Double(String.valueOf(operands[1].getValue()));
        double pv = new Double(String.valueOf(operands[2].getValue()));
        double fv = operands.length > 3 ? (operands[3] instanceof PtgMissArg ? 0.0 : new Double(String.valueOf(operands[3].getValue()))) : 0.0;
        double type = operands.length > 4 ? (operands[4] instanceof PtgMissArg ? 0.0 : new Double(String.valueOf(operands[4].getValue()))) : 0.0;
        double Rn = Math.pow(1.0 + rate, nper);
        double A = -fv * rate - pv * Rn * rate;
        double B = (Rn - 1.0) * (1.0 + rate * type);
        double result = A / B;
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcPPMT(Ptg[] operands) {
        if (operands.length < 4) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcPPMT");
        }
        double rate = operands[0].getDoubleVal();
        int per = operands[1].getIntVal();
        int nper = operands[2].getIntVal();
        double pv = operands[3].getDoubleVal();
        double fv = 0.0;
        int type = 0;
        if (operands.length > 4 && !(operands[4] instanceof PtgMissArg)) {
            fv = operands[4].getDoubleVal();
        }
        if (operands.length > 5) {
            type = operands[5].getIntVal();
        }
        double Rn = Math.pow(1.0 + rate, nper);
        double A = -fv * rate - pv * Rn * rate;
        double B = (Rn - 1.0) * (1.0 + rate * (double)type);
        double pmt = A / B;
        double n = type == 0 ? (double)per : (double)(per - 1);
        A = Math.pow(1.0 + rate, n);
        B = pmt * (1.0 + rate * (double)type);
        double fva = -(pv * A + (B *= (Math.pow(1.0 + rate, n) - 1.0) / rate));
        A = Math.pow(1.0 + rate, n - 1.0);
        B = pmt * (1.0 + rate * (double)type);
        double fvb = -(pv * A + (B *= (Math.pow(1.0 + rate, n - 1.0) - 1.0) / rate));
        double result = fvb - fva;
        PtgNumber pnum = new PtgNumber(result);
        if (DEBUG) {
            Logger.logInfo("Result from calcPPMT= " + result);
        }
        return pnum;
    }

    protected static Ptg calcPRICE(Ptg[] operands) {
        if (operands.length < 6) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcPRICE");
        }
        try {
            GregorianCalendar sDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            GregorianCalendar mDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            double rate = operands[2].getDoubleVal();
            double yld = operands[3].getDoubleVal();
            double redemption = operands[4].getDoubleVal();
            int frequency = operands[5].getIntVal();
            int basis = 0;
            if (operands.length > 6) {
                basis = operands[6].getIntVal();
            }
            if (basis < 0 || basis > 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (!sDate.before(mDate)) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (yld < 0.0 || rate < 0.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (redemption <= 0.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            long settlementDate = new Double(DateConverter.getXLSDateVal(sDate)).longValue();
            long maturityDate = new Double(DateConverter.getXLSDateVal(mDate)).longValue();
            Ptg[] ops = new Ptg[]{operands[0], operands[1], operands[5], new PtgInt(basis)};
            double DSC = FinancialCalculator.calcCoupDaysNC(ops).getDoubleVal();
            double E = FinancialCalculator.calcCoupDays(ops).getDoubleVal();
            double N = PtgCalculator.getLongValue(FinancialCalculator.calcCoupNum(ops));
            double A = FinancialCalculator.calcCoupDayBS(ops).getDoubleVal();
            double R2 = rate / (double)frequency;
            double Y = 1.0 + yld / (double)frequency;
            double result = redemption / Math.pow(Y, N - 1.0 + DSC / E);
            int i = 1;
            while ((double)i <= N) {
                result += R2 * 100.0 / Math.pow(Y, (double)(i - 1) + DSC / E);
                ++i;
            }
            PtgNumber pnum = new PtgNumber(result -= 100.0 * R2 * A / E);
            if (DEBUG) {
                Logger.logInfo("Result from calcPRICE= " + result);
            }
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcPRICEDISC(Ptg[] operands) {
        if (operands.length < 4) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcPRICEDISC");
        }
        try {
            GregorianCalendar sDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            GregorianCalendar mDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            double discount = operands[2].getDoubleVal();
            double redemption = operands[3].getDoubleVal();
            int basis = 0;
            if (operands.length > 4) {
                basis = operands[4].getIntVal();
            }
            if (basis < 0 || basis > 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (!sDate.before(mDate)) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (redemption <= 0.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            long settlementDate = new Double(DateConverter.getXLSDateVal(sDate)).longValue();
            long maturityDate = new Double(DateConverter.getXLSDateVal(mDate)).longValue();
            double result = redemption - discount * redemption * FinancialCalculator.yearFrac(basis, settlementDate, maturityDate);
            PtgNumber pnum = new PtgNumber(result);
            if (DEBUG) {
                Logger.logInfo("Result from calcPRICEDISC= " + result);
            }
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcPRICEMAT(Ptg[] operands) {
        if (operands.length < 4) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcPRICEMAT");
        }
        try {
            GregorianCalendar sDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            GregorianCalendar mDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            GregorianCalendar iDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[2].getValue());
            double rate = operands[3].getDoubleVal();
            double yld = operands[4].getDoubleVal();
            int basis = 0;
            if (operands.length > 5) {
                basis = operands[5].getIntVal();
            }
            if (basis < 0 || basis > 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (!sDate.before(mDate)) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (rate < 0.0 || yld < 0.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            long settlementDate = new Double(DateConverter.getXLSDateVal(sDate)).longValue();
            long maturityDate = new Double(DateConverter.getXLSDateVal(mDate)).longValue();
            long issueDate = new Double(DateConverter.getXLSDateVal(iDate)).longValue();
            double B = FinancialCalculator.getDaysInYearFromBasis(basis, settlementDate, maturityDate);
            double DSM = FinancialCalculator.getDaysFromBasis(basis, settlementDate, maturityDate);
            double DIM = FinancialCalculator.getDaysFromBasis(basis, issueDate, maturityDate);
            double A = FinancialCalculator.getDaysFromBasis(basis, issueDate, settlementDate);
            double result = (100.0 + DIM / B * rate * 100.0) / (1.0 + DSM / B * yld);
            PtgNumber pnum = new PtgNumber(result -= A / B * rate * 100.0);
            if (DEBUG) {
                Logger.logInfo("Result from calcPRICEMAT= " + result);
            }
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcPV(Ptg[] operands) {
        if (operands.length < 3) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcPV");
        }
        double rate = operands[0].getDoubleVal();
        double nper = operands[1].getDoubleVal();
        double pmt = 0.0;
        if (!(operands[2] instanceof PtgMissArg)) {
            pmt = operands[2].getDoubleVal();
        }
        double fv = 0.0;
        int type = 0;
        if (operands.length > 3 && !(operands[3] instanceof PtgMissArg)) {
            fv = operands[3].getDoubleVal();
        }
        if (operands.length > 4) {
            type = operands[4].getIntVal();
        }
        double A = Math.pow(1.0 + rate, nper);
        double B = pmt * (1.0 + rate * (double)type);
        double result = (-fv - (B *= (A - 1.0) / rate)) / A;
        PtgNumber pnum = new PtgNumber(result);
        if (DEBUG) {
            Logger.logInfo("Result from calcPV= " + result);
        }
        return pnum;
    }

    protected static Ptg calcRate(Ptg[] operands) {
        double x0;
        if (operands.length < 3) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcRate");
        }
        double nper = operands[0].getDoubleVal();
        double pmt = operands[1].getDoubleVal();
        double pv = 0.0;
        double fv = 0.0;
        int type = 0;
        double guess = 0.1;
        if (!(operands[2] instanceof PtgMissArg)) {
            pv = operands[2].getDoubleVal();
        }
        if (operands.length > 3 && !(operands[3] instanceof PtgMissArg)) {
            fv = operands[3].getDoubleVal();
        }
        if (operands.length > 4 && !(operands[4] instanceof PtgMissArg)) {
            type = operands[4].getIntVal();
        }
        if (operands.length > 5) {
            guess = operands[5].getDoubleVal();
        }
        if (type != 0 && type != 1) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (pv == 0.0 && fv == 0.0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double TOLERANCE = 1.0E-9;
        boolean bIsCorrect = false;
        double x1 = x0 = guess;
        int j = 0;
        while (j < 100 && !bIsCorrect) {
            double hprime;
            double gprime;
            double fprime;
            double R2 = Math.pow(1.0 + x0, nper);
            double U = 1.0 / x0;
            double a = pv * R2;
            double f = pmt * (1.0 + x0 * (double)type);
            double g = R2 - 1.0;
            double h = U;
            double fx0 = a + f * g * U + fv;
            double T = Math.pow(1.0 + x0, nper - 1.0);
            double aprime = pv * nper * T;
            double fprimex0 = aprime + (fprime = pmt * (double)type) * g * h + f * (gprime = nper * T) * h + f * g * (hprime = -1.0 * Math.pow(x0, -2.0));
            x1 = x0 - fx0 / fprimex0;
            double delta = x1 - x0;
            bIsCorrect = Math.abs(delta) <= 1.0E-9;
            x0 = x1;
            ++j;
        }
        if (!bIsCorrect) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (DEBUG) {
            Logger.logInfo("Result from calcRate= " + x1);
        }
        PtgNumber pnum = new PtgNumber(x1);
        return pnum;
    }

    protected static Ptg calcReceived(Ptg[] operands) {
        if (operands.length < 4) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_NULL);
            return perr;
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcRECEIVED");
        }
        try {
            GregorianCalendar sDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            GregorianCalendar mDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            double investment = operands[2].getDoubleVal();
            double rate = operands[3].getDoubleVal();
            int basis = 0;
            if (operands.length > 4) {
                basis = operands[4].getIntVal();
            }
            long settlementDate = new Double(DateConverter.getXLSDateVal(sDate)).longValue();
            long maturityDate = new Double(DateConverter.getXLSDateVal(mDate)).longValue();
            double result = investment / (1.0 - rate * FinancialCalculator.yearFrac(basis, settlementDate, maturityDate));
            if (DEBUG) {
                Logger.logInfo("Result from calcRECEIVED= " + result);
            }
            PtgNumber pnum = new PtgNumber(result);
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcSLN(Ptg[] operands) {
        if (operands.length < 3) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_NULL);
            return perr;
        }
        double cost = operands[0].getDoubleVal();
        double salvage = operands[1].getDoubleVal();
        double life = operands[2].getDoubleVal();
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcSLN");
        }
        if (life == 0.0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double result = (cost - salvage) / life;
        if (DEBUG) {
            Logger.logInfo("Result from calcSLN= " + result);
        }
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcSYD(Ptg[] operands) {
        if (operands.length < 4) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_NULL);
            return perr;
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcSYD");
        }
        double cost = operands[0].getDoubleVal();
        double salvage = operands[1].getDoubleVal();
        double life = operands[2].getDoubleVal();
        double per = operands[3].getDoubleVal();
        if (life == 0.0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double A = (cost - salvage) * (life - per + 1.0) * 2.0;
        double B = life * (life + 1.0);
        double result = A / B;
        if (DEBUG) {
            Logger.logInfo("Result from calcSYD= " + result);
        }
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcTBillEq(Ptg[] operands) {
        double result;
        long maturityDate;
        if (operands.length < 3) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_NULL);
            return perr;
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcTBILLEQ");
        }
        GregorianCalendar sDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
        GregorianCalendar mDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
        double rate = operands[2].getDoubleVal();
        long settlementDate = new Double(DateConverter.getXLSDateVal(sDate)).longValue();
        if (settlementDate >= (maturityDate = new Double(DateConverter.getXLSDateVal(mDate)).longValue())) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (maturityDate - settlementDate > 365L) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        if (rate <= 0.0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double DSM = maturityDate - settlementDate;
        if (DSM <= 182.0) {
            result = 365.0 * rate / (360.0 - rate * DSM);
        } else {
            double A = DSM / 365.0;
            double B = rate * DSM;
            double C = (2.0 * A - 1.0) * B / (B - 360.0);
            double D = Math.pow(A, 2.0) - C;
            result = (-2.0 * A + 2.0 * Math.sqrt(D)) / (2.0 * A - 1.0);
        }
        if (DEBUG) {
            Logger.logInfo("Result from calcTBILLEQ= " + result);
        }
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcTBillPrice(Ptg[] operands) {
        if (operands.length < 3) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_NULL);
            return perr;
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcTBILLPRICE");
        }
        try {
            GregorianCalendar sDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            GregorianCalendar mDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            double rate = operands[2].getDoubleVal();
            long settlementDate = new Double(DateConverter.getXLSDateVal(sDate)).longValue();
            long maturityDate = new Double(DateConverter.getXLSDateVal(mDate)).longValue();
            if (settlementDate >= maturityDate) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (maturityDate - settlementDate > 365L) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (rate <= 0.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            double DSM = maturityDate - settlementDate;
            double result = 100.0 * (1.0 - rate * DSM / 360.0);
            if (DEBUG) {
                Logger.logInfo("Result from calcTBILLPRICE= " + result);
            }
            PtgNumber pnum = new PtgNumber(result);
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcTBillYield(Ptg[] operands) {
        if (operands.length < 3) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_NULL);
            return perr;
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcTBILLYIELD");
        }
        try {
            GregorianCalendar sDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            GregorianCalendar mDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            double price = operands[2].getDoubleVal();
            long settlementDate = new Double(DateConverter.getXLSDateVal(sDate)).longValue();
            long maturityDate = new Double(DateConverter.getXLSDateVal(mDate)).longValue();
            if (settlementDate >= maturityDate) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (maturityDate - settlementDate > 365L) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (price <= 0.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            double DSM = maturityDate - settlementDate;
            double result = (100.0 - price) / price * (360.0 / DSM);
            if (DEBUG) {
                Logger.logInfo("Result from calcTBILLYIELD= " + result);
            }
            PtgNumber pnum = new PtgNumber(result);
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcVDB(Ptg[] operands) {
        if (operands.length < 5) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcVDB");
        }
        double cost = operands[0].getDoubleVal();
        double salvage = operands[1].getDoubleVal();
        int life = operands[2].getIntVal();
        int start_period = operands[3].getIntVal();
        int end_period = operands[4].getIntVal();
        int factor = 2;
        if (operands.length > 5 && !(operands[5] instanceof PtgMissArg)) {
            factor = operands[5].getIntVal();
        }
        boolean bNoSwitch = false;
        if (operands.length > 6) {
            bNoSwitch = PtgCalculator.getBooleanValue(operands[6]);
        }
        if (cost <= 0.0 || salvage <= 0.0 || life <= 0 || start_period < 0 || end_period < 0 || factor < 0 || end_period > life) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double result = 0.0;
        Ptg[] ops = new Ptg[5];
        ops[0] = new PtgNumber(cost);
        ops[1] = new PtgNumber(salvage);
        ops[2] = new PtgInt(life);
        ops[4] = new PtgInt(factor);
        if (bNoSwitch) {
            int i = start_period + 1;
            while (i <= end_period) {
                ops[3] = new PtgInt(i);
                result += FinancialCalculator.calcDDB(ops).getDoubleVal();
                ++i;
            }
        } else {
            boolean bSwitch = false;
            double A = 0.0;
            int i = start_period + 1;
            while (i <= end_period && !bSwitch) {
                double sl = (cost - A - salvage) / (double)(life - i + 1);
                ops[3] = new PtgInt(i);
                double ddb = FinancialCalculator.calcDDB(ops).getDoubleVal();
                if (sl <= ddb) {
                    A += ddb;
                    ++i;
                    continue;
                }
                bSwitch = true;
            }
            result = A;
            int j = i;
            while (j <= end_period) {
                result += (cost - A - salvage) / (double)(life - i + 1);
                ++j;
            }
        }
        if (DEBUG) {
            Logger.logInfo("Result from calcVDB= " + result);
        }
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcXIRR(Ptg[] operands) {
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcXIRR");
        }
        double guess = 0.1;
        if (operands.length > 2) {
            guess = operands[2].getDoubleVal();
        }
        Ptg[] values = PtgCalculator.getAllComponents(operands[0]);
        Ptg[] dates = PtgCalculator.getAllComponents(operands[1]);
        if (DEBUG) {
            FinancialCalculator.debugOperands(values, "calcXIRR");
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(dates, "calcXIRR");
        }
        if (values.length != dates.length) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double date0 = dates[0].getDoubleVal();
        int i = 1;
        while (i < dates.length) {
            long val = PtgCalculator.getLongValue(dates[i]);
            if ((double)val < date0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            ++i;
        }
        double outflow = 0.0;
        double inflow = 0.0;
        int i2 = 0;
        while (i2 < values.length) {
            double val = values[i2].getDoubleVal();
            if (val < 0.0) {
                outflow += Math.abs(val);
            } else {
                inflow += val;
            }
            ++i2;
        }
        if (outflow == 0.0 || inflow == 0.0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int n = values.length;
        boolean bIsCorrect = false;
        double TOLERANCE = 1.0E-8;
        double trial = guess;
        double x0 = 1.0;
        double f0 = inflow - outflow;
        trial = 1.0 + guess;
        double delta = 0.0;
        double fprime = 0.0;
        int i3 = 0;
        while (i3 < n) {
            double val = values[i3].getDoubleVal();
            double exp = ((double)PtgCalculator.getLongValue(dates[i3]) - date0) / 365.0;
            fprime += val * -exp;
            ++i3;
        }
        int j = 0;
        while (j < 100 && !bIsCorrect) {
            double f = 0.0;
            int i4 = 0;
            while (i4 < n) {
                double val = values[i4].getDoubleVal();
                double exp = (dates[i4].getDoubleVal() - date0) / 365.0;
                f += val * Math.pow(trial, -exp);
                fprime += val * Math.pow(trial, -exp) * -exp;
                ++i4;
            }
            delta = f / (fprime /= trial);
            if (trial - delta <= 0.0) {
                delta = trial / 2.0;
            }
            trial -= delta;
            bIsCorrect = Math.abs(delta) <= 1.0E-8;
            ++j;
        }
        if (!bIsCorrect) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        trial -= 1.0;
        if (DEBUG) {
            Logger.logInfo("Result from calcXIRR= " + trial);
        }
        PtgNumber pnum = new PtgNumber(trial);
        return pnum;
    }

    protected static Ptg calcXNPV(Ptg[] operands) {
        if (operands.length < 2 || operands[1].getComponents() == null) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcXNPV");
        }
        double rate = operands[0].getDoubleVal();
        Ptg[] values = PtgCalculator.getAllComponents(operands[1]);
        Ptg[] dates = PtgCalculator.getAllComponents(operands[2]);
        if (DEBUG) {
            FinancialCalculator.debugOperands(values, "calcXNPV");
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(dates, "calcXNPV");
        }
        if (values.length != dates.length) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double date0 = dates[0].getDoubleVal();
        int i = 1;
        while (i < dates.length) {
            long val = PtgCalculator.getLongValue(dates[i]);
            if ((double)val < date0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            ++i;
        }
        double outflow = 0.0;
        double inflow = 0.0;
        int i2 = 0;
        while (i2 < values.length) {
            double val = values[i2].getDoubleVal();
            if (val < 0.0) {
                outflow += Math.abs(val);
            } else {
                inflow += val;
            }
            ++i2;
        }
        if (outflow == 0.0 || inflow == 0.0) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        int n = values.length;
        double result = 0.0;
        int i3 = 0;
        while (i3 < n) {
            double val = values[i3].getDoubleVal();
            double exp = (dates[i3].getDoubleVal() - date0) / 365.0;
            result += val / Math.pow(1.0 + rate, exp);
            ++i3;
        }
        if (DEBUG) {
            Logger.logInfo("Result from calcXNPV= " + result);
        }
        PtgNumber pnum = new PtgNumber(result);
        return pnum;
    }

    protected static Ptg calcYIELD(Ptg[] operands) {
        if (operands.length < 6) {
            return new PtgErr(PtgErr.ERROR_NULL);
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcINTRATE");
        }
        try {
            GregorianCalendar sDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            GregorianCalendar mDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            double rate = operands[2].getDoubleVal();
            double pr = operands[3].getDoubleVal();
            double redemption = operands[4].getDoubleVal();
            int frequency = operands[5].getIntVal();
            int basis = 0;
            if (operands.length > 6) {
                basis = operands[6].getIntVal();
            }
            if (basis < 0 || basis > 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (!sDate.before(mDate)) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (rate < 0.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (pr <= 0.0 || redemption <= 0.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            long settlementDate = new Double(DateConverter.getXLSDateVal(sDate)).longValue();
            long maturityDate = new Double(DateConverter.getXLSDateVal(mDate)).longValue();
            Ptg[] ops = new Ptg[]{operands[0], operands[1], operands[5], new PtgInt(basis)};
            double result = 0.0;
            double n = PtgCalculator.getLongValue(FinancialCalculator.calcCoupNum(ops));
            double E = FinancialCalculator.calcCoupDays(ops).getDoubleVal();
            double A = FinancialCalculator.calcCoupDayBS(ops).getDoubleVal();
            if (n <= 1.0) {
                double DSR = FinancialCalculator.getDaysFromBasis(basis, settlementDate, maturityDate);
                double R2 = rate / (double)frequency;
                double P2 = pr / 100.0;
                result = redemption / 100.0 + R2 - (P2 + A / E * R2);
                result /= P2 + A / E * R2;
                result *= (double)frequency * E / DSR;
            } else {
                double DSC = FinancialCalculator.calcCoupDaysNC(ops).getDoubleVal();
                result = FinancialCalculator.yieldIteration(DSC, E, n, A, rate, frequency, redemption, pr);
                if (result == -1.0) {
                    return new PtgErr(PtgErr.ERROR_NUM);
                }
            }
            PtgNumber pnum = new PtgNumber(result);
            if (DEBUG) {
                Logger.logInfo("Result from calcYIELD= " + result);
            }
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    private static double yieldIteration(double DSC, double E, double n, double A, double rate, int frequency, double redemption, double pr) {
        double guess = 0.1;
        boolean bIsCorrect = false;
        double TOLERANCE = 1.0E-8;
        double trial = guess;
        double F = DSC / E;
        double G = A / E;
        double R2 = rate / (double)frequency;
        double B = R2 * 100.0;
        double Exp = n - 1.0 + F;
        double delta = 0.0;
        int j = 0;
        while (j < 100 && !bIsCorrect) {
            double Y = 1.0 + trial / (double)frequency;
            double f = redemption / Math.pow(Y, Exp);
            double fprime = 0.0;
            int i = 1;
            while ((double)i <= n) {
                f += B / Math.pow(Y, (double)(i - 1) + F);
                fprime += B / Math.pow(Y, (double)(i - 1) + F) * ((double)(i - 1) + F);
                ++i;
            }
            fprime /= Y;
            delta = (pr - (f -= B * G)) / (fprime += redemption / Math.pow(Y, Exp) * Exp * (1.0 / Y));
            trial = trial < delta ? delta - trial : (trial -= delta);
            bIsCorrect = Math.abs(pr - f) <= 1.0E-8;
            ++j;
        }
        if (bIsCorrect) {
            return trial;
        }
        return -1.0;
    }

    protected static Ptg calcYieldDisc(Ptg[] operands) {
        if (operands.length < 4) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_NULL);
            return perr;
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcYIELDDISC");
        }
        try {
            GregorianCalendar sDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            GregorianCalendar mDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            double pr = operands[2].getDoubleVal();
            double redemption = operands[3].getDoubleVal();
            int basis = 0;
            if (operands.length > 4) {
                basis = operands[4].getIntVal();
            }
            long settlementDate = new Double(DateConverter.getXLSDateVal(sDate)).longValue();
            long maturityDate = new Double(DateConverter.getXLSDateVal(mDate)).longValue();
            if (pr <= 0.0 || redemption <= 0.0) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (basis < 0 || basis > 4) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            if (maturityDate <= settlementDate) {
                return new PtgErr(PtgErr.ERROR_NUM);
            }
            double result = (redemption - pr) / pr / FinancialCalculator.yearFrac(basis, settlementDate, maturityDate);
            if (DEBUG) {
                Logger.logInfo("Result from calcYIELDDISC= " + result);
            }
            PtgNumber pnum = new PtgNumber(result);
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcYieldMat(Ptg[] operands) {
        if (operands.length < 5) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_NULL);
            return perr;
        }
        if (DEBUG) {
            FinancialCalculator.debugOperands(operands, "calcYIELDMAT");
        }
        try {
            GregorianCalendar sDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[0].getValue());
            GregorianCalendar mDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[1].getValue());
            GregorianCalendar iDate = (GregorianCalendar)DateConverter.getCalendarFromNumber(operands[2].getValue());
            double rate = operands[3].getDoubleVal();
            double price = operands[4].getDoubleVal();
            int basis = 0;
            if (operands.length > 5) {
                basis = operands[5].getIntVal();
            }
            long settlementDate = new Double(DateConverter.getXLSDateVal(sDate)).longValue();
            long maturityDate = new Double(DateConverter.getXLSDateVal(mDate)).longValue();
            long issueDate = new Double(DateConverter.getXLSDateVal(iDate)).longValue();
            double B = FinancialCalculator.getDaysInYearFromBasis(basis, settlementDate, maturityDate);
            double DSM = FinancialCalculator.getDaysFromBasis(basis, settlementDate, maturityDate);
            double DIM = FinancialCalculator.getDaysFromBasis(basis, issueDate, maturityDate);
            double A = FinancialCalculator.getDaysFromBasis(basis, issueDate, settlementDate);
            double result = (1.0 + DIM / B * rate - (price / 100.0 + A / B * rate)) / (price / 100.0 + A / B * rate) * (B / DSM);
            if (DEBUG) {
                Logger.logInfo("Result from calcYIELDMAT= " + result);
            }
            PtgNumber pnum = new PtgNumber(result);
            return pnum;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    static void debugOperands(Ptg[] operands, String f) {
        if (DEBUG) {
            Logger.logInfo("Operands for " + f);
            int i = 0;
            while (i < operands.length) {
                String s = operands[i].getString();
                if (!(operands[i] instanceof PtgMissArg)) {
                    String v = operands[i].getValue().toString();
                    Logger.logInfo("\tOperand[" + i + "]=" + s + " " + v);
                } else {
                    Logger.logInfo("\tOperand[" + i + "]=" + s + " is Missing");
                }
                ++i;
            }
        }
    }

    public static boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 100 != 0 && year % 4 == 0;
    }
}

