/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.charts.Bar;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartSeries;
import com.extentech.formats.XLS.charts.ColChart;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.HashMap;

public class StackedColumn
extends ColChart {
    int defaultShape = 0;

    public StackedColumn(GenericChartObject charttype, ChartFormat cf, WorkBook wb) {
        super(charttype, cf, wb);
        this.col = (Bar)charttype;
    }

    @Override
    public boolean isStacked() {
        return true;
    }

    @Override
    public String getSVG(HashMap<String, Double> chartMetrics, HashMap<String, Object> axisMetrics, ChartSeries s) {
        double x = chartMetrics.get("x");
        double y = chartMetrics.get("y");
        double w = chartMetrics.get("w");
        double h = chartMetrics.get("h");
        double max = chartMetrics.get("max");
        Object[] categories = s.getCategories();
        ArrayList series = s.getSeriesValues();
        String[] seriescolors = s.getSeriesBarColors();
        String[] legends = s.getLegends();
        if (series.size() == 0) {
            Logger.logErr("Bar.getSVG: error in series");
            return "";
        }
        StringBuffer svg = new StringBuffer();
        int[] dls = this.getDataLabelInts();
        double barw = 0.0;
        double yfactor = 0.0;
        if (categories.length > 0) {
            barw = w / (double)(categories.length * 2);
        }
        if (max != 0.0) {
            yfactor = h / max;
        }
        double[] totalperseries = null;
        boolean f100 = this.col.is100Percent();
        if (f100) {
            int n = series.size();
            int nSeries = ((double[])series.get(0)).length;
            totalperseries = new double[nSeries];
            int i = 0;
            while (i < n) {
                double[] seriesy = (double[])series.get(i);
                int j = 0;
                while (j < seriesy.length) {
                    double yval = seriesy[j];
                    totalperseries[j] = yval + totalperseries[j];
                    ++j;
                }
                ++i;
            }
        }
        double[] previousY = new double[]{};
        int i = 0;
        while (i < series.size()) {
            svg.append("<g>\r\n");
            double[] curseries = (double[])series.get(i);
            String[] curranges = (String[])s.getSeriesRanges().get(i);
            double yy = y + h;
            if (i == 0) {
                previousY = new double[curseries.length];
                int j = 0;
                while (j < previousY.length) {
                    previousY[j] = yy;
                    ++j;
                }
            }
            int j = 0;
            while (j < curseries.length) {
                double xx = x + (double)j * barw * 2.0 + barw / 2.0;
                if (previousY.length > j) {
                    yy = previousY[j];
                }
                double barh = f100 ? curseries[j] / totalperseries[j] * (h - 10.0) : curseries[j] * yfactor;
                svg.append("<rect " + StackedColumn.getScript(curranges[j]) + " fill='" + seriescolors[i] + "' fill-opacity='1' " + StackedColumn.getStrokeSVG() + " x='" + xx + "' y='" + (yy - barh) + "' width='" + barw + "' height='" + barh + "'/>");
                if (previousY.length > j) {
                    previousY[j] = yy - barh;
                }
                ++j;
            }
            svg.append("</g>\r\n");
            ++i;
        }
        return svg.toString();
    }
}

