/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;

public class Serfmt
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = -8307035373276421283L;
    private short grbit = 0;
    private boolean fSmoothedLine = false;
    private boolean f3dBubbles = false;
    private boolean fArShadow = false;
    private byte[] PROTOTYPE_BYTES = new byte[2];

    @Override
    public void init() {
        super.init();
        this.grbit = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.fSmoothedLine = (this.grbit & 1) == 1;
        this.f3dBubbles = (this.grbit & 2) == 2;
        this.fArShadow = (this.grbit & 4) == 4;
    }

    private void updateRecord() {
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fSmoothedLine, 0);
        this.grbit = ByteTools.updateGrBit(this.grbit, this.f3dBubbles, 1);
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fArShadow, 2);
        byte[] b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    @Override
    public boolean setChartOption(String op, String val) {
        boolean bHandled = false;
        if (op.equalsIgnoreCase("SmoothedLine")) {
            this.fSmoothedLine = val.equals("true");
            bHandled = true;
        } else if (op.equalsIgnoreCase("ThreeDBubbles")) {
            this.f3dBubbles = val.equals("true");
            bHandled = true;
        } else if (op.equalsIgnoreCase("ArShadow")) {
            this.fArShadow = val.equals("true");
            bHandled = true;
        }
        if (bHandled) {
            this.updateRecord();
        }
        return bHandled;
    }

    @Override
    public String getOptionsXML() {
        StringBuffer sb = new StringBuffer();
        if (this.fSmoothedLine) {
            sb.append(" SmoothedLine=\"true\"");
        }
        if (this.f3dBubbles) {
            sb.append(" ThreeDBubbles=\"true\"");
        }
        if (this.fArShadow) {
            sb.append(" ArShadow=\"true\"");
        }
        return sb.toString();
    }

    public static XLSRecord getPrototype() {
        Serfmt s = new Serfmt();
        s.setOpcode((short)4189);
        s.setData(s.PROTOTYPE_BYTES);
        s.init();
        return s;
    }

    public void setHas3dBubbles(boolean has3dBubbles) {
        this.f3dBubbles = has3dBubbles;
        this.updateRecord();
    }

    public boolean get3DBubbles() {
        return this.f3dBubbles;
    }

    public void setSmoothedLine(boolean b) {
        this.fSmoothedLine = b;
        this.updateRecord();
    }

    public boolean getSmoothLine() {
        return this.fSmoothedLine;
    }

    public boolean getShadow() {
        return this.fArShadow;
    }

    public void setHasShadow(boolean b) {
        this.fArShadow = b;
        this.updateRecord();
    }
}

