/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;

public class Scatter
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = -289334135036242100L;
    private short grbit = 0;
    private short pcBubbleSizeRatio = (short)100;
    private short wBubbleSize = 1;
    private boolean fBubbles = false;
    private boolean fShowNegBubbles = false;
    private boolean fHasShadow = false;
    private byte[] PROTOTYPE_BYTES;

    public Scatter() {
        byte[] byArray = new byte[6];
        byArray[0] = 100;
        byArray[2] = 1;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        this.pcBubbleSizeRatio = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.wBubbleSize = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.grbit = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.fBubbles = (this.grbit & 1) == 1;
        this.fShowNegBubbles = (this.grbit & 2) == 2;
        this.fHasShadow = (this.grbit & 4) == 4;
        this.chartType = this.fBubbles ? 9 : 5;
    }

    private void updateRecord() {
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fBubbles, 0);
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fShowNegBubbles, 1);
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fHasShadow, 2);
        byte[] b = ByteTools.shortToLEBytes(this.pcBubbleSizeRatio);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
        b = ByteTools.shortToLEBytes(this.wBubbleSize);
        this.getData()[2] = b[0];
        this.getData()[3] = b[1];
        b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[4] = b[0];
        this.getData()[5] = b[1];
    }

    public void setAsScatterChart() {
        this.fBubbles = false;
        this.chartType = 5;
        this.updateRecord();
    }

    public void setAsBubbleChart() {
        this.fBubbles = true;
        this.chartType = 9;
        this.updateRecord();
    }

    public static XLSRecord getPrototype() {
        Scatter b = new Scatter();
        b.setOpcode((short)4123);
        b.setData(b.PROTOTYPE_BYTES);
        b.init();
        b.setAsScatterChart();
        return b;
    }

    @Override
    public String getOptionsXML() {
        StringBuffer sb = new StringBuffer();
        if (this.pcBubbleSizeRatio != 100) {
            sb.append(" BubbleSizeRatio=\"" + this.pcBubbleSizeRatio + "\"");
        }
        if (this.wBubbleSize != 1) {
            sb.append(" BubbleSize=\"" + this.wBubbleSize + "\"");
        }
        if (this.fShowNegBubbles) {
            sb.append(" ShowNeg=\"true\"");
        }
        if (this.fHasShadow) {
            sb.append(" Shadow=\"true\"");
        }
        return sb.toString();
    }

    @Override
    public boolean setChartOption(String op, String val) {
        boolean bHandled = false;
        if (op.equalsIgnoreCase("BubbleSizeRatio")) {
            this.pcBubbleSizeRatio = Short.parseShort(val);
            bHandled = true;
        } else if (op.equalsIgnoreCase("BubbleSize")) {
            this.wBubbleSize = Short.parseShort(val);
            bHandled = true;
        } else if (op.equalsIgnoreCase("ShowNeg")) {
            this.fShowNegBubbles = val.equals("true");
            bHandled = true;
        } else if (op.equalsIgnoreCase("Shadow")) {
            this.fHasShadow = val.equals("true");
            bHandled = true;
        }
        if (bHandled) {
            this.updateRecord();
        }
        return bHandled;
    }
}

