/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class Scaling
implements OOXMLElement {
    private String logBase;
    private String max;
    private String min;
    private String orientation;

    public Scaling() {
    }

    public Scaling(String logBase, String max, String min, String orientation) {
        this.logBase = logBase;
        this.max = max;
        this.min = min;
        this.orientation = orientation;
    }

    public Scaling(Scaling sc) {
        this.logBase = sc.logBase;
        this.max = sc.max;
        this.min = sc.min;
        this.orientation = sc.orientation;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack lastTag) {
        String logBase = null;
        String max = null;
        String min = null;
        String orientation = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block6: {
                    String endTag;
                    block5: {
                        String tnm;
                        block9: {
                            block8: {
                                block7: {
                                    if (eventType != 2) break block5;
                                    tnm = xpp.getName();
                                    if (tnm.equals("scaling")) break block6;
                                    if (!tnm.equals("logBase")) break block7;
                                    logBase = xpp.getAttributeValue(0);
                                    break block6;
                                }
                                if (!tnm.equals("max")) break block8;
                                max = xpp.getAttributeValue(0);
                                break block6;
                            }
                            if (!tnm.equals("min")) break block9;
                            min = xpp.getAttributeValue(0);
                            break block6;
                        }
                        if (!tnm.equals("orientation")) break block6;
                        orientation = xpp.getAttributeValue(0);
                        break block6;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("scaling")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("scaling.parseOOXML: " + e.toString());
        }
        Scaling s = new Scaling(logBase, max, min, orientation);
        return s;
    }

    public String getOption(String op) {
        if (op.equals("logBase")) {
            return this.logBase;
        }
        if (op.equals("max")) {
            return this.max;
        }
        if (op.equals("min")) {
            return this.min;
        }
        if (op.equals("orientation")) {
            return this.orientation;
        }
        return null;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<c:scaling");
        if (this.logBase != null) {
            ooxml.append("<c:logBase val=\"" + this.logBase + "\"/>");
        }
        if (this.orientation != null) {
            ooxml.append("<c:orientation val=\"" + this.orientation + "\"/>");
        }
        if (this.max != null) {
            ooxml.append("<c:max val=\"" + this.max + "\"/>");
        }
        if (this.min != null) {
            ooxml.append("<c:min val=\"" + this.min + "\"/>");
        }
        ooxml.append("</scaling>\r\n");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Scaling(this);
    }
}

