/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;

public class PieFormat
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = 28305957039802849L;
    short percentage = 0;
    private byte[] PROTOTYPE_BYTES = new byte[2];

    @Override
    public void init() {
        super.init();
        this.getData();
        this.percentage = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
    }

    public static XLSRecord getPrototype() {
        PieFormat pf = new PieFormat();
        pf.setOpcode((short)4107);
        pf.setData(pf.PROTOTYPE_BYTES);
        pf.init();
        return pf;
    }

    public short getPercentage() {
        return this.percentage;
    }

    public void setPercentage(short p) {
        this.percentage = p;
        this.updateRecord();
    }

    private void updateRecord() {
        byte[] b = ByteTools.shortToLEBytes(this.percentage);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    @Override
    public String getOptionsXML() {
        return " Percentage=\"" + this.percentage + "\"";
    }

    @Override
    public String toString() {
        return "PieFormat:  Percentage=" + this.percentage;
    }
}

