/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.Layout;
import com.extentech.formats.OOXML.Legend;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.formats.OOXML.Title;
import com.extentech.formats.OOXML.TxPr;
import com.extentech.formats.XLS.charts.Chart;
import com.extentech.formats.XLS.charts.ChartType;
import com.extentech.formats.XLS.charts.ThreeD;
import com.extentech.toolkit.Logger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;

public class OOXMLChart
extends Chart {
    public String lang = "en-US";
    public boolean roundedCorners = false;
    public Title ttl = null;
    public Legend ooxmlLegend = null;
    public Layout plotAreaLayout = null;
    private SpPr plotareashapeProps = null;
    private SpPr csshapeProps = null;
    private TxPr txpr = null;
    private String editMovement = "twoCell";
    private String name = null;
    private ArrayList chartEmbeds = null;

    public OOXMLChart(Chart c, WorkBookHandle wbh) {
        Class<?> obj = c.getClass();
        while (!obj.equals(Object.class)) {
            Field[] fields = obj.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                fields[i].setAccessible(true);
                try {
                    fields[i].set(this, fields[i].get(c));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                ++i;
            }
            obj = obj.getSuperclass();
        }
        this.name = c.getTitle();
        if (c.hasDataLegend()) {
            this.ooxmlLegend = Legend.createLegend(c.getLegend());
        }
        this.wbh = wbh;
    }

    @Override
    public String toString() {
        String t = this.getTitle();
        if (!t.equals("")) {
            return t;
        }
        return this.name;
    }

    public SpPr getSpPr(int type) {
        if (type == 0) {
            return this.plotareashapeProps;
        }
        if (type == 1) {
            return this.csshapeProps;
        }
        return null;
    }

    public void setTxPr(TxPr txPr) {
        this.txpr = txPr;
    }

    public TxPr getTxPr() {
        return this.txpr;
    }

    public void setSpPr(int type, SpPr spPr) {
        if (type == 0) {
            this.plotareashapeProps = spPr;
            int lw = -1;
            int lclr = 0;
            int bgcolor = -1;
            lw = spPr.getLineWidth();
            lclr = spPr.getLineColor();
            this.getAxes().setPlotAreaBorder(lw, lclr);
        } else if (type == 1) {
            this.csshapeProps = spPr;
        }
    }

    public Title getOOXMLTitle() {
        return this.ttl;
    }

    public void setOOXMLTitle(Title t, WorkBookHandle wb) {
        this.ttl = t;
        int fid = this.ttl.getFontId(wb);
        if (fid == -1) {
            fid = 5;
        }
        float[] coords = null;
        int lw = -1;
        int lclr = 0;
        int bgcolor = 0;
        if (this.ttl.getLayout() != null) {
            coords = this.ttl.getLayout().getCoords();
        }
        if (this.ttl.getSpPr() != null) {
            SpPr sp = this.ttl.getSpPr();
            lw = sp.getLineWidth();
            lclr = sp.getLineColor();
            bgcolor = sp.getColor();
        }
        if (coords != null) {
            this.charttitle.setFrame(lw, lclr, bgcolor, coords);
        }
        if (this.charttitle != null) {
            this.charttitle.setFontId(fid);
        }
    }

    public void setEditMovement(String editMovement) {
        this.editMovement = editMovement;
        this.dirtyflag = true;
    }

    public String getEditMovement() {
        return this.editMovement;
    }

    @Override
    public void removeLegend() {
        this.showLegend(false, false);
        this.ooxmlLegend = null;
    }

    public String getOOXMLName() {
        return this.name;
    }

    public void setOOXMLName(String name) {
        this.name = name;
        this.dirtyflag = true;
    }

    public ArrayList getChartEmbeds() {
        return this.chartEmbeds;
    }

    public void addChartEmbed(String[] ce) {
        if (this.chartEmbeds == null) {
            this.chartEmbeds = new ArrayList();
        }
        this.chartEmbeds.add(ce);
    }

    public StringBuffer getOOXML(String catAxisId, String valAxisId, String serAxisId) {
        StringBuffer cooxml = new StringBuffer();
        try {
            ThreeD td;
            int[] allCharts = this.getAllChartTypes();
            cooxml.append("<c:lang val=\"" + this.lang + "\"/>");
            cooxml.append("\r\n");
            if (this.roundedCorners) {
                cooxml.append("<c:roundedCorners val=\"1\"/>");
            }
            cooxml.append("<c:chart>");
            cooxml.append("\r\n");
            if (this.getOOXMLTitle() == null && !this.getTitle().equals("")) {
                this.setOOXMLTitle(new Title(this.getTitleTd(), this.wbh.getWorkBook()), this.wbh);
            }
            if (this.getOOXMLTitle() != null) {
                cooxml.append(this.getOOXMLTitle().getOOXML());
            }
            if (allCharts[0] != 9 && (td = this.getThreeDRec(0)) != null) {
                cooxml.append(td.getOOXML());
            }
            cooxml.append("<c:plotArea>");
            cooxml.append("\r\n");
            if (this.plotAreaLayout == null) {
                HashMap chartMetrics = this.getMetrics(this.wbh);
                double x = (Double)chartMetrics.get("x") / (Double)chartMetrics.get("canvasw");
                double y = (Double)chartMetrics.get("y") / (Double)chartMetrics.get("canvash");
                double w = (Double)chartMetrics.get("w") / (Double)chartMetrics.get("canvasw");
                double h = (Double)chartMetrics.get("h") / (Double)chartMetrics.get("canvash");
                this.plotAreaLayout = new Layout("inner", new double[]{x, y, w, h});
            }
            cooxml.append(this.plotAreaLayout.getOOXML());
            for (ChartType ch : this.chartgroup) {
                cooxml.append(ch.getOOXML(catAxisId, valAxisId, serAxisId));
            }
            cooxml.append(this.getAxes().getOOXML(0, 0, catAxisId, valAxisId));
            cooxml.append(this.getAxes().getOOXML(3, 2, catAxisId, valAxisId));
            cooxml.append(this.getAxes().getOOXML(1, 1, valAxisId, catAxisId));
            cooxml.append(this.getAxes().getOOXML(2, 3, serAxisId, valAxisId));
            if (this.getSpPr(0) != null) {
                cooxml.append(this.getSpPr(0).getOOXML());
            } else if (!this.wbh.getIsExcel2007()) {
                SpPr sp = new SpPr("c", this.getPlotAreaBgColor().substring(1), 12700, this.getPlotAreaLnColor().substring(1));
                cooxml.append(sp.getOOXML());
            }
            cooxml.append("</c:plotArea>");
            cooxml.append("\r\n");
            if (this.ooxmlLegend != null) {
                cooxml.append(this.ooxmlLegend.getOOXML());
            }
            cooxml.append("<c:plotVisOnly val=\"1\"/>");
            cooxml.append("\r\n");
            cooxml.append("</c:chart>");
            cooxml.append("\r\n");
            if (this.getSpPr(1) != null) {
                cooxml.append(this.getSpPr(1).getOOXML());
            }
            if (this.getTxPr() != null) {
                cooxml.append(this.getTxPr().getOOXML());
            }
        }
        catch (Exception e) {
            Logger.logErr("OOXMLChart.getOOXML: error generating OOXML.  Chart not created: " + e.toString());
        }
        return cooxml;
    }
}

