/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;
import java.awt.Color;

public class MarkerFormat
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = 7526015026522467305L;
    private Color rgbFore;
    private Color rgbBack;
    private int miSize = 0;
    private short imk = 0;
    private short icvFore = 0;
    private short icvBack = 0;
    private short grbit = 0;
    private byte[] PROTOTYPE_BYTES;

    public MarkerFormat() {
        byte[] byArray = new byte[20];
        byArray[12] = 77;
        byArray[14] = 77;
        byArray[16] = 60;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        byte[] data = this.getData();
        this.rgbFore = new Color(data[0] < 0 ? 255 + data[0] : data[0], data[1] < 0 ? 255 + data[1] : data[1], data[2] < 0 ? 255 + data[2] : data[2]);
        this.rgbBack = new Color(data[4] < 0 ? 255 + data[4] : data[4], data[5] < 0 ? 255 + data[5] : data[5], data[6] < 0 ? 255 + data[6] : data[6]);
        this.imk = ByteTools.readShort(this.getByteAt(8), this.getByteAt(9));
        this.grbit = ByteTools.readShort(this.getByteAt(10), this.getByteAt(11));
        this.icvFore = ByteTools.readShort(this.getByteAt(12), this.getByteAt(13));
        this.icvBack = ByteTools.readShort(this.getByteAt(12), this.getByteAt(13));
        this.miSize = ByteTools.readInt(this.getBytesAt(14, 4));
    }

    public static XLSRecord getPrototype() {
        MarkerFormat mf = new MarkerFormat();
        mf.setOpcode((short)4105);
        mf.setData(mf.PROTOTYPE_BYTES);
        return mf;
    }

    @Override
    public String getOptionsXML() {
        StringBuffer sb = new StringBuffer();
        sb.append(" MarkerFormat=\"" + this.imk + "\"");
        return sb.toString();
    }

    @Override
    public boolean setChartOption(String op, String val) {
        boolean bHandled = false;
        if (op.equalsIgnoreCase("MarkerFormat")) {
            this.imk = Short.parseShort(val);
            bHandled = true;
        }
        if (bHandled) {
            this.updateRecord();
        }
        return bHandled;
    }

    private void updateRecord() {
        this.imk = ByteTools.readShort(this.getByteAt(8), this.getByteAt(9));
        byte[] b = ByteTools.shortToLEBytes(this.imk);
        this.getData()[8] = b[0];
        this.getData()[9] = b[1];
    }

    public int getMarkerFormat() {
        return this.imk;
    }

    public void setMarkerFormat(short imk) {
        this.imk = imk;
        this.updateRecord();
    }

    @Override
    public String toString() {
        return "MarkerFormat: imk= " + this.imk + " grbit=" + this.grbit;
    }

    public static String getMarkerSVGDefs() {
        return "<defs>\r\n<rect onmouseover='highLight(evt);'  onmouseout='restore(evt)' id='square1' x='0' y='-5' width='8' height='8'  stroke-width='1'/>\r\n<rect onmouseover='highLight(evt);'  onmouseout='restore(evt)' id='diamond1' x='0' y='-5' width='8' height='8'  stroke-width='1' transform='rotate(45 1 1)'/>\r\n<path id='triangle1' d='M 0,0 L 5,-10 L 10,0 z'/>\r\n<circle id='circle1' cx='1' cy='1' r='5' stroke-width='1'/>\r\n<path id='cross1' d='M0,0 H10 M5,5 V-5' stroke-width='2' transform='rotate(45 5 0)'/>\r\n<path id='plus1' d='M 0,0 H10 M5,5 V-5' stroke-width='2'/>\r\n</defs>\r\n";
    }

    public static String getMarkerSVG(double x, double y, String clr, int marker) {
        String markersvg = "<use x='" + x + "' y='" + y + "' stroke='" + clr + "' fill='" + clr + "' xlink:href='#";
        if (marker == 1) {
            markersvg = String.valueOf(markersvg) + "square1'/>";
        } else if (marker == 2) {
            markersvg = String.valueOf(markersvg) + "diamond1'/>";
        } else if (marker == 3) {
            markersvg = String.valueOf(markersvg) + "triangle1'/>";
        } else if (marker == 4) {
            markersvg = String.valueOf(markersvg) + "cross1'/>";
        } else if (marker == 5) {
            markersvg = String.valueOf(markersvg) + "circle1'/>";
        } else if (marker == 6) {
            markersvg = String.valueOf(markersvg) + "circle1'/>";
        } else if (marker == 7) {
            markersvg = String.valueOf(markersvg) + "circle1'/>";
        } else if (marker == 8) {
            markersvg = String.valueOf(markersvg) + "circle1'/>";
        } else if (marker == 9) {
            markersvg = String.valueOf(markersvg) + "plus1'/>";
        }
        return markersvg;
    }
}

