/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.AreaFormat;
import com.extentech.formats.XLS.charts.AttachedLabel;
import com.extentech.formats.XLS.charts.Chart;
import com.extentech.formats.XLS.charts.Chart3DBarShape;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.Frame;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.LineFormat;
import com.extentech.formats.XLS.charts.MarkerFormat;
import com.extentech.formats.XLS.charts.PieFormat;
import com.extentech.formats.XLS.charts.Serfmt;
import com.extentech.toolkit.ByteTools;

public class DataFormat
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = -3526272512004348462L;
    private short yi;
    private short xi;
    private short iss;
    private byte[] PROTOTYPE_BYTES;

    public DataFormat() {
        byte[] byArray = new byte[8];
        byArray[0] = -1;
        byArray[1] = -1;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        byte[] rkdata = this.getData();
        this.xi = ByteTools.readShort(rkdata[0], rkdata[1]);
        this.yi = ByteTools.readShort(rkdata[2], rkdata[3]);
        this.iss = (short)ByteTools.readUnsignedShort(rkdata[4], rkdata[5]);
    }

    public void initNew() {
        this.setOpcode((short)4102);
        this.setData(this.PROTOTYPE_BYTES);
        this.init();
        Chart3DBarShape cs = new Chart3DBarShape();
        cs.setOpcode((short)4191);
        this.addChartRecord(cs);
    }

    public static XLSRecord getPrototype() {
        DataFormat df = new DataFormat();
        df.setOpcode((short)4102);
        df.setData(df.PROTOTYPE_BYTES);
        df.init();
        Chart3DBarShape cs = new Chart3DBarShape();
        cs.setOpcode((short)4191);
        df.addChartRecord(cs);
        return df;
    }

    public static XLSRecord getPrototypeWithFormatRecs(Chart parentChart) {
        return DataFormat.getPrototypeWithFormatRecs(0, parentChart);
    }

    public static XLSRecord getPrototypeWithFormatRecs(int seriesNumber, Chart parentChart) {
        DataFormat df = new DataFormat();
        df.setOpcode((short)4102);
        df.setData(df.PROTOTYPE_BYTES);
        df.init();
        Chart3DBarShape cs = new Chart3DBarShape();
        cs.setOpcode((short)4191);
        df.addChartRecord(cs);
        df.setSeriesNumber(seriesNumber);
        LineFormat lf = (LineFormat)LineFormat.getPrototype();
        df.addChartRecord(lf);
        AreaFormat af = (AreaFormat)AreaFormat.getPrototype();
        af.setParentChart(parentChart);
        df.addChartRecord(af);
        PieFormat pf = (PieFormat)PieFormat.getPrototype();
        pf.setParentChart(parentChart);
        df.addChartRecord(pf);
        MarkerFormat mf = (MarkerFormat)MarkerFormat.getPrototype();
        mf.setParentChart(parentChart);
        df.addChartRecord(mf);
        return df;
    }

    public void setPointNumber(int idx) {
        this.xi = (short)idx;
        byte[] rkdata = this.getData();
        byte[] num = ByteTools.shortToLEBytes((short)idx);
        rkdata[0] = num[0];
        rkdata[1] = num[1];
        this.setData(rkdata);
    }

    public void setSeriesIndex(int idx) {
        this.yi = (short)idx;
        byte[] rkdata = this.getData();
        byte[] num = ByteTools.shortToLEBytes((short)idx);
        rkdata[2] = num[0];
        rkdata[3] = num[1];
        this.setData(rkdata);
    }

    public void setSeriesNumber(int idx) {
        this.iss = (short)idx;
        byte[] rkdata = this.getData();
        byte[] num = ByteTools.shortToLEBytes((short)idx);
        rkdata[4] = num[0];
        rkdata[5] = num[1];
        this.setData(rkdata);
    }

    public short getSeriesIndex() {
        return this.yi;
    }

    public short getSeriesNumber() {
        return this.iss;
    }

    public short getPointNumber() {
        return this.xi;
    }

    private AttachedLabel getAttachedLabelRec(boolean bCreate) {
        AttachedLabel al = null;
        al = (AttachedLabel)Chart.findRec(this.chartArr, AttachedLabel.class);
        if (al == null && bCreate) {
            al = (AttachedLabel)AttachedLabel.getPrototype();
            int z = Chart.findRecPosition(this.chartArr, MarkerFormat.class);
            if (z > 0) {
                this.chartArr.add(z + 1, al);
            } else {
                this.addChartRecord(al);
            }
        }
        return al;
    }

    private AreaFormat getAreaFormatRec(boolean bCreate) {
        AreaFormat af = (AreaFormat)Chart.findRec(this.chartArr, AreaFormat.class);
        if (af == null) {
            af = (AreaFormat)AreaFormat.getPrototype(0);
            this.addChartRecord((LineFormat)LineFormat.getPrototype());
            this.addChartRecord(af);
            this.addChartRecord((PieFormat)PieFormat.getPrototype());
            this.addChartRecord((MarkerFormat)MarkerFormat.getPrototype());
        }
        return af;
    }

    public short getShape() {
        Chart3DBarShape cs = (Chart3DBarShape)Chart.findRec(this.chartArr, Chart3DBarShape.class);
        return cs.getShape();
    }

    public void setShape(int shape) {
        Chart3DBarShape cs = (Chart3DBarShape)Chart.findRec(this.chartArr, Chart3DBarShape.class);
        cs.setShape((short)shape);
    }

    public void setSmoothLines(boolean smooth) {
        Serfmt sf = (Serfmt)Chart.findRec(this.chartArr, Serfmt.class);
        if (sf == null) {
            if (smooth) {
                this.setHasLines();
                sf = (Serfmt)Serfmt.getPrototype();
                int i = Chart.findRecPosition(this.chartArr, PieFormat.class);
                this.chartArr.add(i + 1, sf);
                sf.setSmoothedLine(true);
            }
        } else {
            sf.setSmoothedLine(smooth);
        }
    }

    public boolean getSmoothedLines() {
        Serfmt sf = (Serfmt)Chart.findRec(this.chartArr, Serfmt.class);
        if (sf != null) {
            return sf.getSmoothLine();
        }
        return false;
    }

    public boolean getHasLines() {
        LineFormat l = (LineFormat)Chart.findRec(this.chartArr, LineFormat.class);
        if (l != null) {
            return l.getLineStyle() != 5;
        }
        return false;
    }

    public void setHasLines() {
        this.setHasLines(0);
    }

    public void setHasLines(int lineStyle) {
        LineFormat l = (LineFormat)Chart.findRec(this.chartArr, LineFormat.class);
        if (l == null) {
            int z = Chart.findRecPosition(this.chartArr, Chart3DBarShape.class) + 1;
            LineFormat lf = (LineFormat)LineFormat.getPrototype(lineStyle, -1);
            this.chartArr.add(z++, lf);
            AreaFormat af = (AreaFormat)AreaFormat.getPrototype();
            af.setParentChart(this.parentChart);
            this.chartArr.add(z++, af);
            PieFormat pf = (PieFormat)PieFormat.getPrototype();
            pf.setParentChart(this.parentChart);
            this.chartArr.add(z++, pf);
            MarkerFormat mf = (MarkerFormat)MarkerFormat.getPrototype();
            mf.setParentChart(this.parentChart);
            this.chartArr.add(z++, mf);
        } else {
            l.setLineStyle(lineStyle);
        }
    }

    public void setHas3DBubbles(boolean b) {
        Serfmt sf = (Serfmt)Chart.findRec(this.chartArr, Serfmt.class);
        if (sf == null) {
            if (b) {
                sf = (Serfmt)Serfmt.getPrototype();
                int i = Chart.findRecPosition(this.chartArr, PieFormat.class);
                sf.setParentChart(this.getParentChart());
                this.chartArr.add(i + 1, sf);
                sf.setHas3dBubbles(true);
            }
        } else {
            sf.setHas3dBubbles(b);
        }
    }

    public boolean getHas3DBubbles() {
        Serfmt sf = (Serfmt)Chart.findRec(this.chartArr, Serfmt.class);
        if (sf != null) {
            return sf.get3DBubbles();
        }
        return false;
    }

    public boolean getHasShadow() {
        Serfmt sf = (Serfmt)Chart.findRec(this.chartArr, Serfmt.class);
        if (sf != null) {
            return sf.hasShadow();
        }
        return false;
    }

    public void setHasShadow(boolean b) {
        Serfmt sf = (Serfmt)Chart.findRec(this.chartArr, Serfmt.class);
        if (sf == null) {
            if (b) {
                sf = (Serfmt)Serfmt.getPrototype();
                int i = Chart.findRecPosition(this.chartArr, PieFormat.class);
                sf.setParentChart(this.getParentChart());
                this.chartArr.add(i + 1, sf);
                sf.setHasShadow(true);
            }
        } else {
            sf.setHasShadow(b);
        }
    }

    public void setPercentage(int p) {
        PieFormat pf = (PieFormat)Chart.findRec(this.chartArr, PieFormat.class);
        if (pf == null) {
            this.setHasLines(5);
            pf = (PieFormat)Chart.findRec(this.chartArr, PieFormat.class);
        }
        pf.setPercentage((short)p);
    }

    public int getPercentage() {
        PieFormat pf = (PieFormat)Chart.findRec(this.chartArr, PieFormat.class);
        if (pf != null) {
            return pf.getPercentage();
        }
        return 0;
    }

    public void setDataLabels(String type) {
        AttachedLabel al = this.getAttachedLabelRec(true);
        al.setType(type, "1");
    }

    public boolean getHasDataLabels() {
        return this.getAttachedLabelRec(false) != null;
    }

    public String getDataLabelType(String type) {
        AttachedLabel al = this.getAttachedLabelRec(false);
        if (al != null) {
            return al.getType(type);
        }
        return null;
    }

    public String getDataLabelType() {
        AttachedLabel al = this.getAttachedLabelRec(false);
        if (al != null) {
            return al.getType();
        }
        return null;
    }

    public int getDataLabelTypeInt() {
        AttachedLabel al = this.getAttachedLabelRec(false);
        if (al != null) {
            return al.getTypeInt();
        }
        return 0;
    }

    public void setHasDataLabels(int dl) {
        AttachedLabel al = this.getAttachedLabelRec(true);
        al.setType((short)dl);
    }

    public int getMarkerFormat() {
        MarkerFormat mf = (MarkerFormat)Chart.findRec(this.chartArr, MarkerFormat.class);
        if (mf != null) {
            return mf.getMarkerFormat();
        }
        return 0;
    }

    public void setMarkerFormat(int marker) {
        MarkerFormat mf = (MarkerFormat)Chart.findRec(this.chartArr, MarkerFormat.class);
        if (mf == null) {
            if (this.chartArr.isEmpty()) {
                Chart3DBarShape cs = new Chart3DBarShape();
                cs.setOpcode((short)4191);
                this.addChartRecord(cs);
                LineFormat lf = (LineFormat)LineFormat.getPrototype();
                lf.setParentChart(this.parentChart);
                lf.setLineStyle(5);
                this.chartArr.add(lf);
                AreaFormat af = (AreaFormat)AreaFormat.getPrototype();
                af.setParentChart(this.parentChart);
                this.chartArr.add(af);
                PieFormat pf = (PieFormat)PieFormat.getPrototype();
                pf.setParentChart(this.parentChart);
                this.chartArr.add(pf);
                mf = (MarkerFormat)MarkerFormat.getPrototype();
                mf.setParentChart(this.parentChart);
                this.chartArr.add(mf);
            } else {
                mf = (MarkerFormat)MarkerFormat.getPrototype();
                mf.setParentChart(this.parentChart);
                int z = Chart.findRecPosition(this.chartArr, PieFormat.class);
                if (z > -1) {
                    this.chartArr.add(z + 1, mf);
                } else {
                    this.chartArr.add(mf);
                }
            }
        }
        mf.setMarkerFormat((short)marker);
    }

    public void setSeriesColor(int clr) {
        AreaFormat af = this.getAreaFormatRec(true);
        af.seticvFore(clr);
    }

    public void setSeriesColor(String clr) {
        AreaFormat af = this.getAreaFormatRec(true);
        af.seticvFore(clr);
    }

    public String getBgColor() {
        String bg = Frame.getBgColor(this.chartArr);
        return bg;
    }

    public void setPieSliceColor(String clr, int slice) {
        AreaFormat af = this.getAreaFormatPie(slice);
        af.seticvFore(clr);
    }

    public void setPieSliceColor(int clr, int slice) {
        AreaFormat af = this.getAreaFormatPie(slice);
        af.seticvFore(clr);
    }

    private AreaFormat getAreaFormatPie(int slice) {
        AreaFormat af = (AreaFormat)Chart.findRec(this.chartArr, AreaFormat.class);
        return af;
    }

    private AreaFormat getAreaFormat() {
        AreaFormat af = (AreaFormat)Chart.findRec(this.chartArr, AreaFormat.class);
        if (af == null) {
            af = (AreaFormat)AreaFormat.getPrototype(0);
            this.addChartRecord((LineFormat)LineFormat.getPrototype());
            this.addChartRecord(af);
            this.addChartRecord((PieFormat)PieFormat.getPrototype());
            this.addChartRecord((MarkerFormat)MarkerFormat.getPrototype());
        }
        return af;
    }
}

