/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ChartSeriesHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.XLS.FormatConstants;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.charts.Area;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartSeries;
import com.extentech.formats.XLS.charts.ChartType;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AreaChart
extends ChartType {
    Area area = null;

    public AreaChart(GenericChartObject charttype, ChartFormat cf, WorkBook wb) {
        super(charttype, cf, wb);
        this.area = (Area)charttype;
    }

    public JSONObject getJSON(ChartSeriesHandle[] series, WorkBookHandle wbh, Double[] minMax) throws JSONException {
        JSONObject chartObjectJSON = new JSONObject();
        chartObjectJSON.put("type", (Object)this.getTypeJSON());
        double yMax = 0.0;
        double yMin = 0.0;
        int nSeries = 0;
        JSONArray seriesJSON = new JSONArray();
        JSONArray seriesCOLORS = new JSONArray();
        try {
            int i = 0;
            while (i < series.length) {
                JSONArray seriesvals = CellRange.getValuesAsJSON(series[i].getSeriesRange(), wbh);
                double sum = 0.0;
                nSeries = Math.max(nSeries, seriesvals.length());
                int j = 0;
                while (j < seriesvals.length()) {
                    try {
                        yMax = Math.max(yMax, sum += seriesvals.getDouble(j));
                        yMin = Math.min(yMin, seriesvals.getDouble(j));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ++j;
                }
                seriesJSON.put((Object)seriesvals);
                seriesCOLORS.put((Object)FormatConstants.SVGCOLORSTRINGS[series[i].getSeriesColor()]);
                ++i;
            }
            chartObjectJSON.put("Series", (Object)seriesJSON);
            chartObjectJSON.put("SeriesFills", (Object)seriesCOLORS);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        minMax[0] = new Double(yMin);
        minMax[1] = new Double(yMax);
        minMax[2] = new Double(nSeries);
        return chartObjectJSON;
    }

    @Override
    public JSONObject getTypeJSON() throws JSONException {
        JSONObject typeJSON = new JSONObject();
        String dojoType = !this.isStacked() ? "Areas" : "StackedAreas";
        typeJSON.put("type", (Object)dojoType);
        return typeJSON;
    }

    @Override
    public String getSVG(HashMap<String, Double> chartMetrics, HashMap<String, Object> axisMetrics, ChartSeries s) {
        double x = chartMetrics.get("x");
        double y = chartMetrics.get("y");
        double w = chartMetrics.get("w");
        double h = chartMetrics.get("h");
        double max = chartMetrics.get("max");
        double min = chartMetrics.get("min");
        Object[] categories = s.getCategories();
        ArrayList series = s.getSeriesValues();
        String[] seriescolors = s.getSeriesBarColors();
        String[] legends = s.getLegends();
        if (series.size() == 0) {
            Logger.logErr("Area.getSVG: error in series");
            return "";
        }
        StringBuffer svg = new StringBuffer();
        int[] dls = this.getDataLabelInts();
        double xfactor = 0.0;
        double yfactor = 0.0;
        if (categories.length > 1) {
            xfactor = w / (double)(categories.length - 1);
        }
        if (max != 0.0) {
            yfactor = h / max;
        }
        int n = series.size();
        int i = n - 1;
        while (i >= 0) {
            svg.append("<g>\r\n");
            String points = "";
            double x1 = 0.0;
            double y1 = 0.0;
            String labels = null;
            double[] curseries = (double[])series.get(i);
            int j = 0;
            while (j < curseries.length) {
                x1 = x + (double)j * xfactor;
                double yval = curseries[j];
                points = String.valueOf(points) + (x + (double)j * xfactor) + "," + (y + h - yval * yfactor);
                if (j == 0) {
                    y1 = y + h - yval * yfactor;
                }
                points = String.valueOf(points) + " ";
                String l = this.getSVGDataLabels(dls, axisMetrics, curseries[j], 0.0, i, legends, categories[j].toString());
                if (l != null) {
                    boolean showValue;
                    boolean showCategories = (dls[i] & 0x10) == 16;
                    boolean showValueLabel = (dls[i] & 0x40) == 64;
                    boolean bl = showValue = (dls[i] & 1) == 1;
                    if (showCategories && !showValue && !showValueLabel && j == 0) {
                        double hh = y1;
                        double yy = y + h - hh + 10.0;
                        if (labels == null) {
                            labels = "";
                        }
                        labels = "<text x='" + (x + w / 2.0) + "' y='" + yy + "' vertical-align='middle' " + AreaChart.getDataLabelFontSVG() + " style='text-align:middle;'>" + l + "</text>\r\n";
                    } else if (showValue || showValueLabel) {
                        if (labels == null) {
                            labels = "";
                        }
                        double yy = y + h - (yval - curseries[j] * 0.5) * yfactor;
                        labels = String.valueOf(labels) + "<text x='" + x1 + "' y='" + yy + "' style='text-anchor: middle;' " + AreaChart.getDataLabelFontSVG() + ">" + l + "</text>\r\n";
                    }
                }
                ++j;
            }
            double x0 = x;
            String pointsend = String.valueOf(x1) + "," + (y + h) + " " + x0 + "," + (y + h) + " " + x0 + "," + y1;
            svg.append("<polyline  id='series_" + (i + 1) + "' " + AreaChart.getScript("") + " fill='" + seriescolors[i] + "' fill-opacity='1' " + AreaChart.getStrokeSVG() + " points='" + points + pointsend + "' fill-rule='evenodd'/>\r\n");
            if (labels != null) {
                svg.append(labels);
            }
            svg.append("</g>\r\n");
            --i;
        }
        return svg.toString();
    }

    @Override
    public StringBuffer getOOXML(String catAxisId, String valAxisId, String serAxisId) {
        StringBuffer cooxml = new StringBuffer();
        cooxml.append("<c:areaChart>");
        cooxml.append("\r\n");
        cooxml.append("<c:grouping val=\"");
        if (this.is100PercentStacked()) {
            cooxml.append("percentStacked");
        } else if (this.isStacked()) {
            cooxml.append("stacked");
        } else {
            cooxml.append("standard");
        }
        cooxml.append("\"/>");
        cooxml.append("\r\n");
        cooxml.append(this.getParentChart().getChartSeries().getOOXML(this.getChartType(), false, 0));
        if (this.cf.getChartLinesRec() != null) {
            cooxml.append(this.cf.getChartLinesRec().getOOXML());
        }
        cooxml.append("<c:axId val=\"" + catAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("<c:axId val=\"" + valAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("</c:areaChart>");
        cooxml.append("\r\n");
        return cooxml;
    }
}

