/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.UnsupportedEncodingException;

public class Sxvi
extends XLSRecord {
    private static final long serialVersionUID = 6399665481118265257L;
    byte[] data = null;
    short itemtype = (short)-1;
    short cchName = (short)-1;
    String name = null;
    short iCache = (short)-1;
    boolean fHidden;
    boolean fHideDetail;
    boolean fFormula;
    boolean fMissing;
    public static final short itmtypeData = 0;
    public static final short itmtypeDEFAULT = 1;
    public static final short itmtypeSUM = 2;
    public static final short itmtypeCOUNTA = 3;
    public static final short itmtypeAVERAGE = 4;
    public static final short itmtypeMAX = 5;
    public static final short itmtypeMIN = 6;
    public static final short itmtypePRODUCT = 7;
    public static final short itmtypeCOUNT = 8;
    public static final short itmtypeSTDEV = 9;
    public static final short itmtypeSTDEVP = 10;
    public static final short itmtypeVAR = 11;
    public static final short itmtypeVARP = 12;
    private byte[] PROTOTYPE_BYTES;

    public Sxvi() {
        byte[] byArray = new byte[8];
        byArray[6] = -1;
        byArray[7] = -1;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        this.itemtype = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        byte b = this.getByteAt(2);
        this.fHidden = (b & 1) == 1;
        this.fHideDetail = (b & 2) == 2;
        this.fFormula = (b & 8) == 8;
        this.fMissing = (b & 0x10) == 16;
        this.iCache = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.cchName = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        if (this.cchName != -1) {
            byte encoding = this.getByteAt(10);
            byte[] tmp = this.getBytesAt(11, this.cchName * (encoding + 1));
            try {
                this.name = encoding == 0 ? new String(tmp, "ISO-8859-1") : new String(tmp, "UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logInfo("encoding PivotTable caption name in Sxvd: " + e);
            }
        }
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("SXVI - itemtype:" + this.itemtype + " iCache: " + this.iCache + " name:" + this.name);
        }
    }

    @Override
    public String toString() {
        return "SXVI - itemtype:" + this.itemtype + " iCache: " + this.iCache + " name:" + this.name;
    }

    public short getItemType() {
        return this.itemtype;
    }

    public void setItemType(int type) {
        this.itemtype = (short)type;
        byte[] b = ByteTools.shortToLEBytes(this.itemtype);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    public void setCacheItem(int icache) {
        this.iCache = (short)icache;
        byte[] b = ByteTools.shortToLEBytes(this.iCache);
        this.getData()[4] = b[0];
        this.getData()[5] = b[1];
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        byte[] data = new byte[8];
        System.arraycopy(this.getData(), 0, data, 0, 7);
        if (name != null) {
            byte[] strbytes = null;
            try {
                strbytes = this.name.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logInfo("encoding pivot table name in SXVI: " + e);
            }
            this.cchName = (short)strbytes.length;
            byte[] nm = ByteTools.shortToLEBytes(this.cchName);
            data[6] = nm[0];
            data[7] = nm[1];
            byte[] newrgch = new byte[this.cchName + 1];
            System.arraycopy(strbytes, 0, newrgch, 1, this.cchName);
            data = ByteTools.append(newrgch, data);
        } else {
            data[6] = -1;
            data[7] = -1;
        }
        this.setData(data);
    }

    public boolean getIsHidden() {
        return this.fHidden;
    }

    public void setIsHidden(boolean b) {
        this.fHidden = b;
        byte by = this.getByteAt(2);
        this.getData()[2] = this.fHidden ? (byte)(by & 1) : (byte)(by ^ 1);
    }

    public boolean getIsCollapsed() {
        return this.fHideDetail;
    }

    public void setIsCollapsed(boolean b) {
        this.fHideDetail = b;
        byte by = this.getByteAt(2);
        this.getData()[2] = this.fHideDetail ? (byte)(by & 2) : (byte)(by ^ 2);
    }

    public static XLSRecord getPrototype() {
        Sxvi si = new Sxvi();
        si.setOpcode((short)178);
        si.setData(si.PROTOTYPE_BYTES);
        si.init();
        return si;
    }
}

