/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.SXLI_Item;
import com.extentech.formats.XLS.Sxview;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;

public class Sxli
extends XLSRecord {
    private static final long serialVersionUID = 4157827774990504633L;
    ArrayList<SXLI_Item> items;
    int nItemsPerLine;

    @Override
    public void init() {
        super.init();
        Sxview sx = this.wkbook.getAllPivotTableViews()[this.wkbook.getNPivotTableViews() - 1];
        this.nItemsPerLine = sx.hasRowPivotItemsRecord() ? sx.cDimCol : sx.cDimRw;
        this.items = SXLI_Item.parse(this.getData(), this.nItemsPerLine);
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("SXLI: rgsxli:" + this.items.toString());
        }
    }

    @Override
    public String toString() {
        return "SXLI: rgsxli:" + this.items.toString();
    }

    public void addField(int repeat, int nLines, int type, short[] indexes) {
        SXLI_Item sxitem = new SXLI_Item(repeat, nLines, type, indexes, this.nItemsPerLine);
        this.items.add(sxitem);
        this.updateRecord(true);
    }

    public static XLSRecord getPrototype(WorkBook wkbook) {
        Sxli li = new Sxli();
        li.setWorkBook(wkbook);
        li.setOpcode((short)181);
        li.setData(new byte[0]);
        li.init();
        return li;
    }

    void updateRecord(boolean appendLast) {
        if (!appendLast) {
            this.data = new byte[0];
            for (SXLI_Item sxitem : this.items) {
                this.data = ByteTools.append(sxitem.getData(), this.data);
            }
        } else {
            this.data = ByteTools.append(this.items.get(this.items.size() - 1).getData(), this.data);
        }
    }
}

