/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.PivotCacheRecord;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class SxDB
extends XLSRecord
implements XLSConstants,
PivotCacheRecord {
    private static final long serialVersionUID = 9027599480633995587L;
    private int crdbdb;
    private short idstm;
    private short grbit;
    private short cfdbdb;
    private short cfdbTot;
    private short crdbUsed;
    private short vsType;
    private short cchWho;
    private boolean fInvalid;
    private boolean fRefreshOnLoad;
    private boolean fEnableRefresh;
    private String rgb;
    private byte[] PROTOTYPE_BYTES;

    public SxDB() {
        byte[] byArray = new byte[20];
        byArray[0] = 1;
        byArray[6] = 33;
        byArray[8] = -1;
        byArray[9] = 31;
        byArray[10] = 1;
        byArray[12] = 1;
        byArray[16] = 1;
        byArray[18] = -1;
        byArray[19] = -1;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        if (this.DEBUGLEVEL > 3) {
            Logger.logInfo("SXDB -" + Arrays.toString(this.getData()));
        }
        this.crdbdb = ByteTools.readInt(this.getBytesAt(0, 4));
        this.idstm = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.grbit = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        this.cfdbdb = ByteTools.readShort(this.getByteAt(10), this.getByteAt(11));
        this.cfdbTot = ByteTools.readShort(this.getByteAt(12), this.getByteAt(13));
        this.crdbUsed = ByteTools.readShort(this.getByteAt(14), this.getByteAt(15));
        this.vsType = ByteTools.readShort(this.getByteAt(16), this.getByteAt(17));
        this.cchWho = ByteTools.readShort(this.getByteAt(18), this.getByteAt(19));
        if (this.cchWho > 0) {
            byte encoding = this.getByteAt(20);
            byte[] tmp = this.getBytesAt(21, this.cchWho * (encoding + 1));
            try {
                this.rgb = encoding == 0 ? new String(tmp, "ISO-8859-1") : new String(tmp, "UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logInfo("SxDB.init: " + e);
            }
        }
    }

    @Override
    public String toString() {
        return "SXDB: nCacheRecords/rows:" + this.crdbdb + " nCacheFields:" + this.cfdbdb + " cfdbTot:" + this.cfdbTot + " sid:" + this.idstm + " vsType: " + this.vsType + Arrays.toString(this.getRecord());
    }

    public static XLSRecord getPrototype() {
        SxDB sxdb = new SxDB();
        sxdb.setOpcode((short)198);
        sxdb.setData(sxdb.PROTOTYPE_BYTES);
        sxdb.init();
        return sxdb;
    }

    @Override
    public byte[] getRecord() {
        byte[] b = new byte[4];
        System.arraycopy(ByteTools.shortToLEBytes(this.getOpcode()), 0, b, 0, 2);
        System.arraycopy(ByteTools.shortToLEBytes((short)this.getData().length), 0, b, 2, 2);
        return ByteTools.append(this.getData(), b);
    }

    public void setNCacheRecords(int n) {
        this.crdbdb = (short)n;
        System.arraycopy(ByteTools.cLongToLEBytes(this.crdbdb), 0, this.getData(), 0, 4);
    }

    public int getNCacheRecords() {
        return this.crdbdb;
    }

    public short getStreamID() {
        return this.idstm;
    }

    public void setStreamID(int sid) {
        this.idstm = (short)sid;
        byte[] b = ByteTools.shortToLEBytes(this.idstm);
        this.getData()[4] = b[0];
        this.getData()[5] = b[1];
    }

    public void setNCacheFields(int n) {
        this.cfdbdb = (short)n;
        byte[] b = ByteTools.shortToLEBytes(this.cfdbdb);
        this.getData()[10] = b[0];
        this.getData()[11] = b[1];
        this.cfdbTot = (short)n;
        b = ByteTools.shortToLEBytes(this.cfdbTot);
        this.getData()[12] = b[0];
        this.getData()[13] = b[1];
    }

    public int getNCacheFields() {
        return this.cfdbdb;
    }
}

