/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Sheet;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import java.util.Locale;

public class Setup
extends XLSRecord {
    private static final long serialVersionUID = 1835707090231884340L;
    static final int BITMASK_LEFTTORIGHT = 1;
    static final int BITMASK_LANDSCAPE = 2;
    static final int BITMASK_NOPRINTDATA = 4;
    static final int BITMASK_NOCOLOR = 8;
    static final int BITMASK_DRAFT = 16;
    static final int BITMASK_PRINTNOTES = 32;
    static final int BITMASK_NOORIENT = 64;
    static final int BITMASK_USEPAGE = 128;
    private short paperSize = (short)-1;
    private short scale = (short)-1;
    private short pageStart = (short)-1;
    private short fitWidth = (short)-1;
    private short fitHeight = (short)-1;
    private short grbit = (short)-1;
    private short resolution = (short)-1;
    private short verticalResolution = (short)-1;
    private double headerMargin = -1.0;
    private double footerMargin = -1.0;
    private short copies = (short)-1;

    @Override
    public void setSheet(Sheet sheet) {
        super.setSheet(sheet);
        ((Boundsheet)sheet).addPrintRec(this);
    }

    public boolean getDraft() {
        return (this.grbit & 0x10) == 16;
    }

    public void setDraft(boolean draft) {
        if (draft) {
            this.grbit = (short)(this.grbit | 0x10);
        } else {
            short grbittemp = (short)(this.grbit ^ 0x10);
            this.grbit = (short)(grbittemp & this.grbit);
        }
        this.setGrbit();
    }

    public boolean getLandscape() {
        short gx = (short)(this.grbit & 2);
        return gx != 2;
    }

    public void setLandscape(boolean landscape) {
        this.grbit = !landscape ? (short)(this.grbit | 2) : (short)(this.grbit & 0xFFFFFFFD);
        this.setGrbit();
        this.setInitialized(true);
    }

    public boolean getLeftToRight() {
        return (this.grbit & 1) == 1;
    }

    public void setLeftToRight(boolean leftToRight) {
        this.grbit = leftToRight ? (short)(this.grbit | 1) : (short)(this.grbit ^ 1);
        this.setGrbit();
    }

    public boolean getNoColor() {
        return (this.grbit & 8) == 8;
    }

    public void setNoColor(boolean noColor) {
        this.grbit = noColor ? (short)(this.grbit | 8) : (short)(this.grbit ^ 8);
        this.setGrbit();
    }

    public boolean getNoOrient() {
        return (this.grbit & 0x40) == 64;
    }

    public void setNoOrient(boolean noOrient) {
        this.grbit = noOrient ? (short)(this.grbit | 0x40) : (short)(this.grbit & 0xFFFFFFBF);
        this.setGrbit();
    }

    public boolean getNoPrintData() {
        return (this.grbit & 4) == 4;
    }

    public void setInitialized(boolean isInitialized) {
        if (!isInitialized) {
            this.grbit = (short)(this.grbit | 4);
        } else if ((this.grbit & 4) == 4) {
            this.grbit = (short)(this.grbit ^ 4);
        }
        this.setGrbit();
    }

    public boolean getPrintNotes() {
        return (this.grbit & 0x20) == 32;
    }

    public void setPrintNotes(boolean printNotes) {
        this.grbit = printNotes ? (short)(this.grbit | 0x20) : (short)(this.grbit ^ 0x20);
        this.setGrbit();
    }

    public boolean getUsePage() {
        return (this.grbit & 0x80) == 128;
    }

    public void setUsePage(boolean usePage) {
        this.grbit = usePage ? (short)(this.grbit | 0x80) : (short)(this.grbit ^ 0x80);
        this.setGrbit();
    }

    @Override
    public void init() {
        super.init();
        int pos = 0;
        this.paperSize = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
        this.scale = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
        this.pageStart = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
        this.fitWidth = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
        this.fitHeight = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
        this.grbit = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
        this.resolution = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
        this.verticalResolution = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
        byte[] bx1 = new byte[]{this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++)};
        this.headerMargin = ByteTools.eightBytetoLEDouble(bx1);
        byte[] bx2 = new byte[]{this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++), this.getByteAt(pos++)};
        this.footerMargin = ByteTools.eightBytetoLEDouble(bx2);
        this.copies = ByteTools.readShort(this.getByteAt(pos++), this.getByteAt(pos++));
        if ((this.grbit & 4) == 4) {
            this.scale = (short)100;
            this.grbit = (short)(this.grbit | 2);
            this.paperSize = "AR AS BR BS BM BO CA CL CO CR CU DM DO EC GD GP GU GT GY HN HT JM KN KY LC MX NI PA PE PR PY SR SV TC US UM UY VC VE VI ".indexOf(String.valueOf(Locale.getDefault().getCountry()) + " ") == -1 ? (short)9 : (short)1;
        }
    }

    public short getCopies() {
        return this.copies;
    }

    public void setCopies(short c) {
        this.copies = c;
        byte[] data = this.getData();
        byte[] b = ByteTools.shortToLEBytes(this.copies);
        System.arraycopy(b, 0, data, 32, 2);
        this.setData(data);
        this.setInitialized(true);
    }

    public short getFitHeight() {
        return this.fitHeight;
    }

    public void setFitHeight(short f) {
        this.fitHeight = f;
        byte[] data = this.getData();
        byte[] b = ByteTools.shortToLEBytes(this.fitHeight);
        System.arraycopy(b, 0, data, 8, 2);
        this.setData(data);
    }

    public short getFitWidth() {
        return this.fitWidth;
    }

    public void setFitWidth(short f) {
        this.fitWidth = f;
        byte[] data = this.getData();
        byte[] b = ByteTools.shortToLEBytes(this.fitWidth);
        System.arraycopy(b, 0, data, 6, 2);
        this.setData(data);
    }

    public double getFooterMargin() {
        return this.footerMargin;
    }

    public void setFooterMargin(double f) {
        this.footerMargin = f;
        byte[] data = this.getData();
        byte[] b = ByteTools.doubleToLEByteArray(this.footerMargin);
        System.arraycopy(b, 0, data, 24, 8);
        this.setData(data);
    }

    public double getHeaderMargin() {
        return this.headerMargin;
    }

    public void setHeaderMargin(double h) {
        this.headerMargin = h;
        byte[] data = this.getData();
        byte[] b = ByteTools.doubleToLEByteArray(this.headerMargin);
        System.arraycopy(b, 0, data, 16, 8);
        this.setData(data);
    }

    public short getPageStart() {
        return this.pageStart;
    }

    public void setPageStart(short p) {
        this.pageStart = p;
        byte[] data = this.getData();
        byte[] b = ByteTools.shortToLEBytes(this.pageStart);
        System.arraycopy(b, 0, data, 4, 2);
        this.setData(data);
    }

    public short getPaperSize() {
        return this.paperSize;
    }

    public void setPaperSize(short p) {
        this.paperSize = p;
        byte[] data = this.getData();
        byte[] b = ByteTools.shortToLEBytes(this.paperSize);
        System.arraycopy(b, 0, data, 0, 2);
        this.setData(data);
        this.setInitialized(true);
    }

    public short getResolution() {
        return this.resolution;
    }

    public void setResolution(short r2) {
        this.resolution = r2;
        byte[] data = this.getData();
        byte[] b = ByteTools.shortToLEBytes(this.resolution);
        System.arraycopy(b, 0, data, 12, 2);
        this.setData(data);
        this.setInitialized(true);
    }

    public short getScale() {
        return this.scale;
    }

    public void setScale(short s) {
        this.scale = s;
        byte[] data = this.getData();
        byte[] b = ByteTools.shortToLEBytes(this.scale);
        System.arraycopy(b, 0, data, 2, 2);
        this.setData(data);
        this.setInitialized(true);
    }

    public short getVerticalResolution() {
        return this.verticalResolution;
    }

    public void setVerticalResolution(short v) {
        this.verticalResolution = v;
        byte[] data = this.getData();
        byte[] b = ByteTools.shortToLEBytes(this.verticalResolution);
        System.arraycopy(b, 0, data, 14, 2);
        this.setData(data);
        this.setInitialized(true);
    }

    public void setGrbit() {
        byte[] data = this.getData();
        byte[] b = ByteTools.shortToLEBytes(this.grbit);
        System.arraycopy(b, 0, data, 10, 2);
        this.setData(data);
    }

    public void setGrbitOLD() {
        byte[] data = this.getData();
        byte[] b = ByteTools.shortToLEBytes(this.grbit);
        System.arraycopy(b, 0, data, 10, 2);
        this.setData(data);
    }
}

