/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Sheet;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;

public class RightMargin
extends XLSRecord {
    private static final long serialVersionUID = -3649192673573344145L;
    double margin;

    @Override
    public void init() {
        super.init();
        this.margin = ByteTools.eightBytetoLEDouble(this.getBytesAt(0, 8));
    }

    public RightMargin() {
        this.setOpcode((short)39);
        this.margin = 0.75;
        this.setData(ByteTools.doubleToLEByteArray(this.margin));
    }

    @Override
    public void setSheet(Sheet sheet) {
        super.setSheet(sheet);
        ((Boundsheet)sheet).addPrintRec(this);
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double value) {
        this.margin = value;
        this.setData(ByteTools.doubleToLEByteArray(value));
    }
}

