/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Sheet;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.Chart;
import com.extentech.toolkit.ByteTools;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;

public final class Obj
extends XLSRecord {
    private FtCmo ftCmo = null;
    private static final long serialVersionUID = -4442755911399227290L;
    public byte[] PROTOTYPE_BYTES;
    private Chart myChart;
    public static final byte otGroup = 0;
    public static final byte otLine = 1;
    public static final byte otRectangle = 2;
    public static final byte otOval = 3;
    public static final byte otArc = 4;
    public static final byte otChart = 5;
    public static final byte otText = 6;
    public static final byte otButton = 7;
    public static final byte otPicture = 8;
    public static final byte otPolygon = 9;
    public static final byte otCheckbox = 11;
    public static final byte otRadiobutton = 12;
    public static final byte otEditbox = 13;
    public static final byte otLabel = 14;
    public static final byte otDialogbox = 15;
    public static final byte otSpincontrol = 16;
    public static final byte otScrollbar = 17;
    public static final byte otList = 18;
    public static final byte otGroupbox = 19;
    public static final byte otDropdownlist = 20;
    public static final byte otNote = 25;
    public static final byte otOfficeArtobject = 30;

    protected static XLSRecord getPrototype() {
        Obj obj = new Obj();
        obj.setOpcode((short)93);
        obj.setData(obj.PROTOTYPE_BYTES);
        obj.init();
        return obj;
    }

    public Obj() {
        byte[] byArray = new byte[38];
        byArray[0] = 21;
        byArray[2] = 18;
        byArray[4] = 8;
        byArray[6] = 2;
        byArray[8] = 17;
        byArray[9] = 96;
        byArray[14] = 104;
        byArray[15] = 28;
        byArray[16] = 105;
        byArray[17] = 5;
        byArray[22] = 7;
        byArray[24] = 2;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = 8;
        byArray[30] = 2;
        this.PROTOTYPE_BYTES = byArray;
        this.ftCmo = new FtCmo();
    }

    public Obj(int obType, int obId, int grbit) {
        byte[] byArray = new byte[38];
        byArray[0] = 21;
        byArray[2] = 18;
        byArray[4] = 8;
        byArray[6] = 2;
        byArray[8] = 17;
        byArray[9] = 96;
        byArray[14] = 104;
        byArray[15] = 28;
        byArray[16] = 105;
        byArray[17] = 5;
        byArray[22] = 7;
        byArray[24] = 2;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = 8;
        byArray[30] = 2;
        this.PROTOTYPE_BYTES = byArray;
        this.setOpcode((short)93);
        this.ftCmo = new FtCmo();
        this.ftCmo.setObjId(obId);
        this.ftCmo.setObjType(obType);
        this.ftCmo.setGrbit(grbit);
        this.setData(this.ftCmo.getRec());
    }

    protected static Obj getBasicObjRecord(int obType, int obId) {
        int grbit = 8449;
        if (obType == 25) {
            grbit = 16401;
        }
        Obj obj = new Obj(obType, obId, grbit);
        ArrayList<SubRecord> subrecords = new ArrayList<SubRecord>();
        switch (obType) {
            case 8: {
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            case 16: 
            case 17: {
                break;
            }
            case 18: 
            case 20: {
                Obj obj2 = obj;
                obj2.getClass();
                SubRecord ftSbs = obj2.new SubRecord(null, null);
                byte[] byArray = new byte[24];
                byArray[0] = 12;
                byArray[2] = 20;
                byArray[12] = 100;
                byArray[14] = 1;
                byArray[16] = 10;
                byArray[20] = 16;
                byArray[22] = 1;
                ftSbs.parse(byArray);
                subrecords.add(ftSbs);
                FtLbsData ftlbsdata = obj.new FtLbsData();
                byte[] byArray2 = new byte[20];
                byArray2[0] = 19;
                byArray2[2] = -18;
                byArray2[3] = 31;
                byArray2[8] = 1;
                byArray2[10] = 1;
                byArray2[11] = 3;
                byArray2[14] = 2;
                byArray2[16] = 8;
                byArray2[18] = 87;
                ftlbsdata.parse(byArray2);
                subrecords.add(ftlbsdata);
                break;
            }
            case 13: {
                break;
            }
            case 19: {
                break;
            }
            case 7: {
                break;
            }
            case 25: {
                Obj obj3 = obj;
                obj3.getClass();
                SubRecord ftNts = obj3.new SubRecord(null, null);
                UUID uuid = UUID.randomUUID();
                byte[] guid = Obj.asByteArray(uuid);
                byte[] ntsbytes = new byte[26];
                ntsbytes[0] = 13;
                ntsbytes[2] = 22;
                System.arraycopy(guid, 0, ntsbytes, 4, 16);
                ntsbytes[22] = 16;
                ftNts.parse(ntsbytes);
                subrecords.add(ftNts);
                break;
            }
        }
        byte[] newdata = obj.getData();
        int i = 0;
        while (i < subrecords.size()) {
            SubRecord sr = (SubRecord)subrecords.get(i);
            newdata = ByteTools.append(sr.getRec(), newdata);
            ++i;
        }
        newdata = ByteTools.append(new byte[4], newdata);
        obj.setData(newdata);
        return obj;
    }

    @Override
    public String toString() {
        if (this.ftCmo != null) {
            return "OBJ type: " + this.ftCmo.getType() + " id: " + this.ftCmo.getObjId();
        }
        return "OBJ record not initialized";
    }

    @Override
    public void setSheet(Sheet b) {
        this.worksheet = b;
        ((Boundsheet)b).lastObjId = Math.max(((Boundsheet)b).lastObjId, this.ftCmo.getObjId());
    }

    @Override
    public void init() {
        super.init();
        byte[] data = this.getData();
        this.ftCmo = new FtCmo();
        this.ftCmo.parse(data, 0);
        try {
            int pos = 22;
            while (pos < data.length - 2) {
                short ft = ByteTools.readShort(data[pos], data[pos + 1]);
                int cb = 2;
                switch (ft) {
                    case 0: {
                        break;
                    }
                    case 4: {
                        cb = 4 + ByteTools.readShort(data[pos + 2], data[pos + 3]);
                        break;
                    }
                    case 5: {
                        cb = 4 + ByteTools.readShort(data[pos + 2], data[pos + 3]);
                        break;
                    }
                    case 6: {
                        cb = 6;
                        break;
                    }
                    case 7: {
                        cb = 6;
                        break;
                    }
                    case 8: {
                        cb = 6;
                        break;
                    }
                    case 9: {
                        cb = 4 + ByteTools.readShort(data[pos + 2], data[pos + 3]);
                        break;
                    }
                    case 10: {
                        cb = 16;
                        break;
                    }
                    case 11: {
                        cb = 10;
                        break;
                    }
                    case 12: {
                        cb = 4 + ByteTools.readShort(data[pos + 2], data[pos + 3]);
                        break;
                    }
                    case 13: {
                        cb = 26;
                        break;
                    }
                    case 14: {
                        cb = 4 + ByteTools.readShort(data[pos + 2], data[pos + 3]);
                        break;
                    }
                    case 15: {
                        cb = 10;
                        break;
                    }
                    case 16: {
                        cb = 12;
                        break;
                    }
                    case 17: {
                        cb = 8;
                        break;
                    }
                    case 18: {
                        cb = 12;
                        break;
                    }
                    case 19: {
                        FtLbsData ftl = new FtLbsData();
                        ftl.parse(data, pos, this.ftCmo.getObjType() == 20);
                        cb = ftl.getCb();
                        break;
                    }
                    case 20: {
                        cb = 4 + ByteTools.readShort(data[pos + 2], data[pos + 3]);
                        break;
                    }
                    default: {
                        cb = 2;
                    }
                }
                if (ft != 0) {
                    pos += cb;
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void updateRecord() {
        byte[] retData = new byte[6];
        byte[] b = ByteTools.shortToLEBytes(this.ftCmo.getObjType());
        retData[0] = b[0];
        retData[1] = b[1];
        b = ByteTools.shortToLEBytes(this.ftCmo.getObjId());
        retData[2] = b[0];
        retData[3] = b[1];
        b = ByteTools.shortToLEBytes(this.ftCmo.getGrbit());
        retData[4] = b[0];
        retData[5] = b[1];
        byte[] updated = this.getData();
        System.arraycopy(retData, 0, updated, 4, retData.length);
        this.setData(updated);
    }

    public Chart getChart() {
        return this.myChart;
    }

    public void setChart(Chart c) {
        this.myChart = c;
    }

    public int getObjType() {
        return this.ftCmo.getObjType();
    }

    public int getObjId() {
        return this.ftCmo.getObjId();
    }

    public void setObjId(int objId) {
        this.ftCmo.setObjId((short)objId);
        this.updateRecord();
    }

    public String debugOutput() {
        byte[] data = this.getData();
        StringBuffer log = new StringBuffer();
        FtCmo ftCmo = new FtCmo();
        ftCmo.parse(data, 0);
        log.append(this.toString());
        log.append("\r\n\t");
        log.append("FtCmo");
        log.append("\t" + ByteTools.getByteDump(data, 0, 22));
        try {
            int pos = 22;
            while (pos < data.length - 2) {
                log.append("\r\n\t");
                short ft = ByteTools.readShort(data[pos], data[pos + 1]);
                int cb = 2;
                switch (ft) {
                    case 0: {
                        log.append("ftEnd");
                        break;
                    }
                    case 4: {
                        log.append("ftMacro");
                        cb = 4 + ByteTools.readShort(data[pos + 2], data[pos + 3]);
                        break;
                    }
                    case 5: {
                        log.append("ftButton");
                        cb = 4 + ByteTools.readShort(data[pos + 2], data[pos + 3]);
                        break;
                    }
                    case 6: {
                        log.append("ftGmo");
                        cb = 6;
                        break;
                    }
                    case 7: {
                        log.append("ftCf");
                        cb = 6;
                        break;
                    }
                    case 8: {
                        log.append("ftPioGrbit");
                        cb = 6;
                        break;
                    }
                    case 9: {
                        log.append("ftPictFmla");
                        cb = 4 + ByteTools.readShort(data[pos + 2], data[pos + 3]);
                        break;
                    }
                    case 10: {
                        log.append("ftCbls");
                        cb = 16;
                        break;
                    }
                    case 11: {
                        log.append("ftRbo");
                        cb = 10;
                        break;
                    }
                    case 12: {
                        log.append("ftSbs");
                        cb = 4 + ByteTools.readShort(data[pos + 2], data[pos + 3]);
                        break;
                    }
                    case 13: {
                        log.append("ftNts");
                        cb = 26;
                        break;
                    }
                    case 14: {
                        log.append("ftSbsFmla");
                        cb = 4 + ByteTools.readShort(data[pos + 2], data[pos + 3]);
                        break;
                    }
                    case 15: {
                        log.append("ftGboData");
                        cb = 10;
                        break;
                    }
                    case 16: {
                        log.append("ftEboData");
                        cb = 12;
                        break;
                    }
                    case 17: {
                        log.append("ftRboData");
                        cb = 8;
                        break;
                    }
                    case 18: {
                        log.append("ftCblsData");
                        cb = 12;
                        break;
                    }
                    case 19: {
                        log.append("ftLbsData");
                        FtLbsData ftl = new FtLbsData();
                        ftl.parse(data, pos, ftCmo.getObjType() == 20);
                        cb = ftl.getCb();
                        break;
                    }
                    case 20: {
                        log.append("ftCblsFmla");
                        cb = 4 + ByteTools.readShort(data[pos + 2], data[pos + 3]);
                        break;
                    }
                    default: {
                        log.append("Unknown");
                        cb = 2;
                    }
                }
                if (ft != 0) {
                    log.append(ByteTools.getByteDump(data, pos, cb));
                    pos += cb;
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return log.toString();
    }

    private static UUID toUUID(byte[] byteArray) {
        long msb = 0L;
        long lsb = 0L;
        int i = 0;
        while (i < 8) {
            msb = msb << 8 | (long)(byteArray[i] & 0xFF);
            ++i;
        }
        i = 8;
        while (i < 16) {
            lsb = lsb << 8 | (long)(byteArray[i] & 0xFF);
            ++i;
        }
        UUID uuid = new UUID(msb, lsb);
        return uuid;
    }

    private static byte[] asByteArray(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] buffer = new byte[16];
        int i = 0;
        while (i < 8) {
            buffer[i] = (byte)(msb >>> 8 * (7 - i));
            ++i;
        }
        i = 8;
        while (i < 16) {
            buffer[i] = (byte)(lsb >>> 8 * (7 - i));
            ++i;
        }
        return buffer;
    }

    private class FtCmo
    extends SubRecord {
        private static final long serialVersionUID = 9129235555230900833L;
        short objType;
        short objId;
        short grbit;

        FtCmo() {
            this.ft = (short)21;
            this.cb = (short)22;
            this.rec = new byte[22];
            this.rec[0] = 21;
            this.rec[2] = 18;
        }

        public void parse(byte[] rec, int pos) {
            if (rec.length < 10) {
                return;
            }
            this.objType = ByteTools.readShort(rec[4], rec[5]);
            this.objId = ByteTools.readShort(rec[6], rec[7]);
            this.grbit = ByteTools.readShort(rec[8], rec[9]);
        }

        public short getObjType() {
            return this.objType;
        }

        public short getObjId() {
            return this.objId;
        }

        public short getGrbit() {
            return this.grbit;
        }

        public void setObjId(int objId) {
            this.objId = (short)objId;
            byte[] b = ByteTools.shortToLEBytes(this.objId);
            this.rec[6] = b[0];
            this.rec[7] = b[1];
        }

        public void setObjType(int objType) {
            this.objType = (short)objType;
            byte[] b = ByteTools.shortToLEBytes(this.objType);
            this.rec[4] = b[0];
            this.rec[5] = b[1];
        }

        public void setGrbit(int grbit) {
            this.grbit = (short)grbit;
            byte[] b = ByteTools.shortToLEBytes(this.grbit);
            this.rec[8] = b[0];
            this.rec[9] = b[1];
        }

        public String getType() {
            switch (this.objType) {
                case 0: {
                    return "Group";
                }
                case 1: {
                    return "Line";
                }
                case 2: {
                    return "Rectangle";
                }
                case 3: {
                    return "Oval";
                }
                case 4: {
                    return "Arc";
                }
                case 5: {
                    return "Chart";
                }
                case 6: {
                    return "Text";
                }
                case 7: {
                    return "Button";
                }
                case 8: {
                    return "Picture";
                }
                case 9: {
                    return "Polygon";
                }
                case 11: {
                    return "CheckBox";
                }
                case 12: {
                    return "Option Button";
                }
                case 13: {
                    return "Edit Box";
                }
                case 14: {
                    return "Label";
                }
                case 15: {
                    return "Dialog Box";
                }
                case 16: {
                    return "Spin Control";
                }
                case 17: {
                    return "Scrollbar";
                }
                case 18: {
                    return "List";
                }
                case 19: {
                    return "Group Box";
                }
                case 20: {
                    return "Dropdown List Box";
                }
                case 25: {
                    return "Note";
                }
                case 30: {
                    return "MSO Drawing";
                }
            }
            return "UNKNOWN TYPE " + this.objType;
        }
    }

    private class FtLbsData
    extends SubRecord {
        private static final long serialVersionUID = 4965884944498060366L;

        FtLbsData() {
            this.ft = (short)19;
        }

        public void parse(byte[] rec, int pos, boolean isListBox) {
            short cbFContinued;
            int origPos = pos;
            if ((cbFContinued = ByteTools.readShort(rec[pos += 2], rec[pos + 1])) != 0) {
                short grbit;
                short cbFmla = ByteTools.readShort(rec[pos += 2], rec[pos + 1]);
                short cLines = ByteTools.readShort(rec[pos += cbFmla + 2], rec[pos + 1]);
                short isel = ByteTools.readShort(rec[pos += 2], rec[pos + 1]);
                if (((grbit = ByteTools.readShort(rec[pos += 2], rec[pos + 1])) & 1) == 1) {
                    short s = (short)(grbit >> 8);
                }
                short iEditId = ByteTools.readShort(rec[pos += 2], rec[pos + 1]);
                if (isListBox) {
                    short droprecProps = ByteTools.readShort(rec[pos += 2], rec[pos + 1]);
                    short cLine = ByteTools.readShort(rec[pos += 2], rec[pos + 1]);
                    short s = ByteTools.readShort(rec[pos += 2], rec[pos + 1]);
                }
                this.cb = (short)(pos + 2 - origPos);
            } else {
                this.cb = (short)4;
            }
        }
    }

    private class SubRecord
    implements Serializable {
        private static final long serialVersionUID = -9040304321493078260L;
        short ft;
        short cb;
        byte[] rec;

        private SubRecord() {
        }

        public byte[] getRec() {
            return this.rec;
        }

        public void parse(byte[] rec) {
            this.ft = ByteTools.readShort(rec[0], rec[1]);
            this.cb = ByteTools.readShort(rec[2], rec[3]);
            this.rec = rec;
        }

        public int getFt() {
            return this.ft;
        }

        public int getCb() {
            return this.cb;
        }

        /* synthetic */ SubRecord(SubRecord subRecord, SubRecord subRecord2) {
            this();
        }
    }
}

