/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.DateConverter;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.ExtenXLS.WorkSheetHandle;
import com.extentech.formats.OOXML.Border;
import com.extentech.formats.OOXML.Dxf;
import com.extentech.formats.OOXML.Fill;
import com.extentech.formats.OOXML.OOXMLConstants;
import com.extentech.formats.OOXML.PivotCacheDefinition;
import com.extentech.formats.OOXML.PivotTableDefinition;
import com.extentech.formats.OOXML.Theme;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.CellNotFoundException;
import com.extentech.formats.XLS.Font;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.formats.XLS.Sst;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.extentech.formats.XLS.Xf;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.StringTool;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class OOXMLReader
extends OOXMLAdapter
implements OOXMLConstants {
    protected static boolean parsePivotTables = true;
    ArrayList borders;
    ArrayList<Integer> fontmap;
    ArrayList<Fill> fills;
    ArrayList<Dxf> dxfs;
    HashMap fmts;
    int nXfs;

    public void parseNBind(WorkBookHandle bk, String fName) throws XmlPullParserException, IOException, CellNotFoundException {
        ZipFile zip = new ZipFile(fName);
        inputEncoding = System.getProperty("file.encoding");
        if (inputEncoding == null) {
            inputEncoding = "UTF-8";
        }
        bk.getWorkBook().setIsExcel2007(true);
        int origcalcmode = bk.getWorkBook().getCalcMode();
        bk.getWorkBook().setCalcMode(1);
        ZipEntry rels = OOXMLReader.getEntry(zip, "_rels/.rels");
        if (this.DEBUG) {
            Logger.logInfo("parseNBind about to call parseRels on: " + rels.toString());
        }
        this.mainContentList = OOXMLReader.parseRels(OOXMLReader.wrapInputStream(zip.getInputStream(rels)));
        bk.getWorkBook().getFactory().setFileName(fName);
        bk.setDupeStringMode(1);
        bk.getWorkBook().removeXfRecs();
        bk.getWorkBook().setDefaultIxfe(0);
        this.externalDir = OOXMLReader.getTempDir(bk.getWorkBook().getFactory().getFileName());
        ArrayList formulas = new ArrayList();
        ArrayList hyperlinks = new ArrayList();
        HashMap inlineStrs = new HashMap();
        this.parseBookLevelElements(bk, null, zip, this.mainContentList, "", formulas, hyperlinks, inlineStrs, null, null);
        zip.close();
        if (!bk.getWorkBook().getFactory().getFileName().endsWith(".tmp")) {
            OOXMLReader.deleteDir(new File(this.externalDir));
        }
        bk.getWorkBook().setCalcMode(origcalcmode);
    }

    protected void parseBookLevelElements(WorkBookHandle bk, WorkSheetHandle sheet, ZipFile zip, ArrayList cl, String parentDir, ArrayList formulas, ArrayList hyperlinks, HashMap inlineStrs, HashMap<String, String> pivotCaches, HashMap<String, WorkSheetHandle> pivotTables) throws XmlPullParserException, CellNotFoundException {
        ArrayList sst = new ArrayList();
        try {
            int i = 0;
            while (i < cl.size()) {
                ZipEntry target;
                String[] c = (String[])cl.get(i);
                if (this.DEBUG) {
                    Logger.logInfo("OOXMLReader.parse: " + c[0] + ":" + c[1] + ":" + c[2]);
                }
                String p = StringTool.getPath(c[1]);
                p = OOXMLReader.parsePathForZip(p, parentDir);
                String ooxmlElement = c[0];
                if (!ooxmlElement.equals("hyperlink")) {
                    c[1] = StringTool.stripPath(c[1]);
                }
                String f = c[1];
                String rId = c[2];
                if (ooxmlElement.equals("styles")) {
                    target = OOXMLReader.getEntry(zip, String.valueOf(p) + f);
                    this.parseStylesXML(bk, OOXMLReader.wrapInputStream(zip.getInputStream(target)));
                } else if (ooxmlElement.equals("sst")) {
                    target = OOXMLReader.getEntry(zip, String.valueOf(p) + f);
                    sst = Sst.parseOOXML(bk, OOXMLReader.wrapInputStream(zip.getInputStream(target)));
                } else if (ooxmlElement.equals("sheet")) {
                    target = OOXMLReader.getEntry(zip, String.valueOf(p) + f);
                    try {
                        int sheetnum = 1;
                        try {
                            String s = rId.substring(3);
                            sheetnum = Integer.valueOf(s) - 1;
                        }
                        catch (Exception e) {
                            Logger.logWarn("OOXMLAdapter couldn't get sheet number from rid:" + rId);
                        }
                        sheet = bk.getWorkSheet(sheetnum);
                        sheet.setFastCellAdds(true);
                        sheet.getMysheet().parseOOXML(bk, sheet, OOXMLReader.wrapInputStream(zip.getInputStream(target)), sst, formulas, hyperlinks, inlineStrs);
                        target = OOXMLReader.getEntry(zip, String.valueOf(p) + "_rels/" + f.substring(f.lastIndexOf("/") + 1) + ".rels");
                        if (target != null) {
                            try {
                                HashMap<String, WorkSheetHandle> pts = new HashMap<String, WorkSheetHandle>();
                                sheet.getMysheet().parseSheetElements(bk, zip, OOXMLReader.parseRels(OOXMLReader.wrapInputStream(OOXMLReader.wrapInputStream(zip.getInputStream(target)))), p, this.externalDir, formulas, hyperlinks, inlineStrs, pts);
                                if (pts.size() > 0) {
                                    pivotTables.putAll(pts);
                                }
                            }
                            catch (Exception e) {
                                Logger.logWarn("OOXMLAdapter.parse problem parsing rels in: " + bk.toString() + " " + e.toString());
                            }
                        }
                        sheet.setFastCellAdds(false);
                    }
                    catch (WorkSheetNotFoundException we) {
                        Logger.logErr("OOXMLAdapter.parse: " + we.toString());
                    }
                } else if (ooxmlElement.equals("document")) {
                    target = OOXMLReader.getEntry(zip, String.valueOf(p) + f);
                    if (this.DEBUG) {
                        Logger.logInfo("About to parseWBOOXML:" + bk.toString());
                    }
                    pivotCaches = new HashMap();
                    this.parsewbOOXML(zip, bk, OOXMLReader.wrapInputStream(zip.getInputStream(target)), p, pivotCaches);
                    pivotTables = new HashMap();
                    this.parseBookLevelElements(bk, sheet, zip, this.wbContentList, p, formulas, hyperlinks, inlineStrs, pivotCaches, pivotTables);
                    if (inlineStrs != null) {
                        this.addInlineStrings(bk, inlineStrs);
                    }
                    this.addFormulas(bk, formulas);
                    this.addPivotTables(bk, zip, pivotTables);
                } else if (parsePivotTables && ooxmlElement.equals("pivotCacheDefinition")) {
                    target = OOXMLReader.getEntry(zip, String.valueOf(p) + f);
                    PivotCacheDefinition.parseOOXML(bk, pivotCaches.get(rId), OOXMLReader.wrapInputStream(zip.getInputStream(target)));
                    target = OOXMLReader.getEntry(zip, String.valueOf(p) + "_rels/" + f.substring(f.lastIndexOf("/") + 1) + ".rels");
                    if (target != null) {
                        try {
                            this.parseBookLevelElements(bk, sheet, zip, OOXMLReader.parseRels(OOXMLReader.wrapInputStream(OOXMLReader.wrapInputStream(zip.getInputStream(target)))), p, formulas, hyperlinks, inlineStrs, pivotCaches, pivotTables);
                        }
                        catch (Exception e) {
                            Logger.logWarn("OOXMLAdapter.parse problem parsing rels in: " + bk.toString() + " " + e.toString());
                        }
                    }
                } else if (!parsePivotTables || !ooxmlElement.equals("pivotCacheRecords")) {
                    if (ooxmlElement.equals("theme") || ooxmlElement.equals("themeOverride")) {
                        target = OOXMLReader.getEntry(zip, String.valueOf(p) + f);
                        if (target != null) {
                            if (bk.getWorkBook().getTheme() == null) {
                                bk.getWorkBook().setTheme(Theme.parseThemeOOXML(bk, OOXMLReader.wrapInputStream(zip.getInputStream(target))));
                            } else {
                                bk.getWorkBook().getTheme().parseOOXML(bk, OOXMLReader.wrapInputStream(zip.getInputStream(target)));
                            }
                        }
                        OOXMLReader.handlePassThroughs(zip, bk, p, this.externalDir, c);
                    } else if (ooxmlElement.equals("props") || ooxmlElement.equals("exprops") || ooxmlElement.equals("custprops") || ooxmlElement.equals("connections") || ooxmlElement.equals("calc") || ooxmlElement.equals("vba") || ooxmlElement.equals("externalLink")) {
                        OOXMLReader.handlePassThroughs(zip, bk, p, this.externalDir, c);
                    } else {
                        Logger.logWarn("OOXMLReader.parse:  XLSX Option Not yet Implemented " + ooxmlElement);
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            Logger.logErr("OOXMLReader.parse failed: " + e.toString());
        }
    }

    protected static void handlePassThroughs(ZipFile zip, WorkBookHandle bk, String parentDir, String externalDir, String[] c) throws IOException {
        OOXMLReader.passThrough(zip, String.valueOf(parentDir) + c[1], String.valueOf(externalDir) + c[1]);
        ZipEntry target = OOXMLReader.getEntry(zip, String.valueOf(parentDir) + "_rels/" + c[1].substring(c[1].lastIndexOf("/") + 1) + ".rels");
        if (target == null) {
            bk.getWorkBook().addOOXMLObject(new String[]{c[0], parentDir, String.valueOf(externalDir) + c[1]});
        } else {
            String[] stringArray = new String[6];
            stringArray[0] = c[0];
            stringArray[1] = parentDir;
            stringArray[2] = String.valueOf(externalDir) + c[1];
            stringArray[3] = c[2];
            stringArray[5] = Arrays.asList(OOXMLReader.storeEmbeds(zip, target, parentDir, externalDir)).toString();
            bk.getWorkBook().addOOXMLObject(stringArray);
        }
    }

    protected static void handleSheetPassThroughs(ZipFile zip, WorkBookHandle bk, Boundsheet sht, String parentDir, String externalDir, String[] c, String attrs) throws IOException {
        OOXMLReader.passThrough(zip, String.valueOf(parentDir) + c[1], String.valueOf(externalDir) + c[1]);
        ZipEntry target = OOXMLReader.getEntry(zip, String.valueOf(parentDir) + "_rels/" + c[1].substring(c[1].lastIndexOf("/") + 1) + ".rels");
        if (target == null) {
            sht.addOOXMLObject(new String[]{c[0], parentDir, String.valueOf(externalDir) + c[1], c[2], attrs});
        } else {
            sht.addOOXMLObject(new String[]{c[0], parentDir, String.valueOf(externalDir) + c[1], c[2], attrs, Arrays.asList(OOXMLReader.storeEmbeds(zip, target, parentDir, externalDir)).toString()});
        }
    }

    protected static void passThrough(ZipFile zip, String fin, String fout) throws IOException {
        try {
            File outfile = new File(fout);
            outfile.deleteOnExit();
            File dirs = outfile.getParentFile();
            if (dirs != null && !dirs.exists()) {
                dirs.mkdirs();
                dirs.deleteOnExit();
            }
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(outfile));
            InputStream fis = OOXMLReader.wrapInputStream(zip.getInputStream(OOXMLReader.getEntry(zip, fin)));
            int i = fis.read();
            while (i != -1) {
                fos.write(i);
                i = fis.read();
            }
            fos.flush();
            fos.close();
            dirs.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    ArrayList parsewbOOXML(ZipFile zip, WorkBookHandle bk, InputStream ii, String p, HashMap<String, String> pivotCaches) {
        ArrayList<String[]> namedRanges = new ArrayList<String[]>();
        ArrayList<String[]> contentList = new ArrayList<String[]>();
        ArrayList<Object> sheets = new ArrayList<Object>();
        bk.getWorkBook().dateFormat = DateConverter.DateFormat.OOXML_1900;
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput(new InputStreamReader(ii));
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("sheet")) {
                        String name = "";
                        int id = 0;
                        int rId = 0;
                        String hidden = "";
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String nm = xpp.getAttributeName(i);
                            String v = xpp.getAttributeValue(i);
                            if (nm.equalsIgnoreCase("name")) {
                                name = v;
                            } else if (nm.equalsIgnoreCase("SheetId")) {
                                id = Integer.valueOf(v) - 1;
                            } else if (nm.equalsIgnoreCase("id")) {
                                rId = Integer.valueOf(v.substring(3)) - 1;
                            } else if (nm.equals("state")) {
                                hidden = v;
                            }
                            ++i;
                        }
                        i = sheets.size();
                        while (i < rId) {
                            sheets.add("");
                            ++i;
                        }
                        sheets.add(rId, new String[]{name, hidden});
                        contentList.add(new String[]{"sheet", name});
                    } else if (tnm.equals("workbookPr")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String attrName = xpp.getAttributeName(i);
                            String attrValue = xpp.getAttributeValue(i);
                            if (attrName.equalsIgnoreCase("codeName")) {
                                bk.getWorkBook().setCodename(attrValue);
                            } else if (attrName.equalsIgnoreCase("dateCompatibility") && attrValue.equals("1")) {
                                bk.getWorkBook().dateFormat = DateConverter.DateFormat.LEGACY_1900;
                            } else if (attrName.equalsIgnoreCase("date1904") && attrValue.equals("1")) {
                                bk.getWorkBook().dateFormat = DateConverter.DateFormat.LEGACY_1904;
                            }
                            ++i;
                        }
                    } else if (tnm.equals("workbookView")) {
                        String n = "";
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            n = xpp.getAttributeName(i);
                            if (n.equalsIgnoreCase("firstSheet")) {
                                bk.getWorkBook().setFirstSheet(Integer.valueOf(xpp.getAttributeValue(i)));
                            } else if (n.equals("showSheetTabs")) {
                                boolean b = !xpp.getAttributeValue(i).equals("0");
                                bk.getWorkBook().setShowSheetTabs(b);
                            }
                            ++i;
                        }
                    } else if (tnm.equals("definedName")) {
                        String nm = "";
                        String id = "";
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String n = xpp.getAttributeName(i);
                            if (n.equals("name")) {
                                nm = xpp.getAttributeValue(i);
                            } else if (n.equals("localSheetId")) {
                                id = xpp.getAttributeValue(i);
                            }
                            ++i;
                        }
                        String name = OOXMLReader.getNextText(xpp);
                        if (!id.equals("") && name.startsWith("[")) {
                            int n = 0;
                            while ((n = name.indexOf("[")) > -1) {
                                name = String.valueOf(name.substring(0, n)) + name.substring(n + name.substring(n).indexOf("]") + 1);
                            }
                        }
                        namedRanges.add(new String[]{nm, id, name});
                    } else if (tnm.equals("pivotCache")) {
                        String cid = "";
                        String rid = "";
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String n = xpp.getAttributeName(i);
                            if (n.equals("cacheId")) {
                                cid = xpp.getAttributeValue(i);
                            } else if (n.equals("id")) {
                                rid = xpp.getAttributeValue(i);
                            }
                            ++i;
                        }
                        pivotCaches.put(rid, cid);
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("OOXMLAdapter.parsewbOOXML failed: " + e.toString());
        }
        int i = 0;
        while (i < sheets.size()) {
            Object obx = sheets.get(i);
            String[] sh = null;
            sh = obx instanceof String ? new String[]{obx.toString()} : (String[])obx;
            String name = sh[0];
            if (name != null && !name.equals("")) {
                bk.createWorkSheet(name, i);
                try {
                    bk.getWorkBook().setDefaultIxfe(0);
                    if (sh[1].equals("hidden")) {
                        bk.getWorkSheet(i).setHidden(true);
                    } else if (sh[1].equals("veryHidden")) {
                        bk.getWorkSheet(i).setVeryHidden(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        ZipEntry target = OOXMLReader.getEntry(zip, String.valueOf(p) + "_rels/workbook.xml.rels");
        try {
            this.wbContentList = OOXMLReader.parseRels(OOXMLReader.wrapInputStream(OOXMLReader.wrapInputStream(zip.getInputStream(target))));
        }
        catch (IOException e) {
            Logger.logWarn("OOXMLReader.parseWbOOXML: " + e.toString());
        }
        this.reorderWbContentList(this.wbContentList);
        this.addNames(bk, namedRanges);
        return contentList;
    }

    protected static String parsePathForZip(String p, String parentDir) {
        if (p.indexOf("/") != 0 || p.indexOf("\\") == 0) {
            while (p.indexOf("..") == 0) {
                int z;
                p = p.substring(3);
                if (!(parentDir.equals("") || parentDir.charAt(parentDir.length() - 1) != '/' && parentDir.charAt(parentDir.length() - 1) != '\\')) {
                    parentDir = parentDir.substring(0, parentDir.length() - 2);
                }
                if ((z = parentDir.lastIndexOf("/")) == -1) {
                    z = parentDir.lastIndexOf("\\");
                }
                parentDir = parentDir.substring(0, z + 1);
            }
            p = String.valueOf(parentDir) + p;
        } else if (!p.equals("")) {
            p = p.substring(1);
        }
        return p;
    }

    protected static String getCurrentElement(XmlPullParser xpp) {
        StringBuffer el = new StringBuffer();
        try {
            int eventType = xpp.getEventType();
            String elname = xpp.getName();
            while (eventType != 1) {
                if (eventType == 2 || eventType == 4) {
                    el.append(xpp.getText());
                } else if (eventType == 3) {
                    String t = xpp.getText();
                    if (t.indexOf("</") == 0) {
                        el.append(t);
                    }
                    if (xpp.getName().equals(elname)) break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("OOXMLAdapter.getCurrentElement: " + e.toString());
        }
        return el.toString();
    }

    protected static String getInlineString(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int eventType = xpp.next();
        String ret = "";
        while (eventType != 1 && eventType != 3 && eventType != 4) {
            eventType = xpp.next();
        }
        if (eventType == 4) {
            ret = xpp.getText();
        }
        try {
            return new String(ret.getBytes(), inputEncoding);
        }
        catch (Exception exception) {
            return ret;
        }
    }

    void parseStylesXML(WorkBookHandle bk, InputStream ii) {
        try {
            this.borders = new ArrayList();
            this.fontmap = new ArrayList();
            this.fills = new ArrayList();
            this.dxfs = new ArrayList();
            this.fmts = new HashMap();
            this.nXfs = 0;
            int indexedColor = 0;
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput(new InputStreamReader(ii));
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("font")) {
                        Font f = Font.parseOOXML(xpp, bk);
                        int idx = FormatHandle.addFont(f, bk);
                        this.fontmap.add(idx);
                    } else if (!tnm.equals("dxfs")) {
                        if (tnm.equals("dxf")) {
                            Dxf d = (Dxf)Dxf.parseOOXML(xpp, bk).cloneElement();
                            this.dxfs.add(d);
                        } else if (tnm.equals("fill")) {
                            Fill f = (Fill)Fill.parseOOXML(xpp, false, bk);
                            this.fills.add(f);
                        } else if (tnm.equals("numFmt")) {
                            int fmtId = 0;
                            short newFmtId = 0;
                            String xmlFormatPattern = "";
                            int i = 0;
                            while (i < xpp.getAttributeCount()) {
                                String nm = xpp.getAttributeName(i);
                                if (nm.equals("numFmtId")) {
                                    fmtId = Integer.valueOf(xpp.getAttributeValue(i));
                                } else if (nm.equals("formatCode")) {
                                    xmlFormatPattern = xpp.getAttributeValue(i);
                                    xmlFormatPattern = Xf.unescapeFormatPattern(xmlFormatPattern);
                                }
                                ++i;
                            }
                            newFmtId = Xf.addFormatPattern(bk.getWorkBook(), xmlFormatPattern);
                            this.fmts.put(fmtId, Integer.valueOf(newFmtId));
                        } else if (tnm.equals("border")) {
                            Border b = (Border)Border.parseOOXML(xpp, bk).cloneElement();
                            this.borders.add(b);
                        } else if (tnm.equals("cellXfs")) {
                            while (eventType != 1) {
                                if (eventType == 2) {
                                    this.parseCellXf(xpp, bk);
                                } else if (eventType == 3 && xpp.getName().equals("cellXfs")) break;
                                eventType = xpp.next();
                            }
                        } else if (tnm.equals("rgbColor")) {
                            String clr = "#" + xpp.getAttributeValue(0).substring(2);
                            try {
                                bk.getWorkBook().getColorTable()[indexedColor++] = FormatHandle.HexStringToColor(clr);
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                        }
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("worksheet")) break;
                if (eventType == 1) continue;
                eventType = xpp.next();
            }
            if (this.dxfs.size() > 0) {
                bk.getWorkBook().setDxfs(this.dxfs);
            }
        }
        catch (Exception e) {
            Logger.logErr("OOXMLReader.parseStylesXML: " + e.toString());
        }
    }

    private void parseCellXf(XmlPullParser xpp, WorkBookHandle bk) {
        block35: {
            String tnm;
            block36: {
                block34: {
                    tnm = xpp.getName();
                    if (!tnm.equals("xf")) break block34;
                    int f = 0;
                    int fmtId = -1;
                    int fillId = -1;
                    int borderId = -1;
                    int i = 0;
                    while (i < xpp.getAttributeCount()) {
                        String nm = xpp.getAttributeName(i);
                        if (nm.equals("fontId")) {
                            f = Integer.valueOf(xpp.getAttributeValue(i));
                        } else if (nm.equals("numFmtId")) {
                            fmtId = Integer.valueOf(xpp.getAttributeValue(i));
                        } else if (nm.equals("fillId")) {
                            fillId = Integer.valueOf(xpp.getAttributeValue(i));
                        } else if (nm.equals("borderId")) {
                            borderId = Integer.valueOf(xpp.getAttributeValue(i));
                        }
                        ++i;
                    }
                    f = this.fontmap.get(f);
                    Xf xf = null;
                    if (this.nXfs < bk.getWorkBook().getXfrecs().size()) {
                        xf = (Xf)bk.getWorkBook().getXfrecs().get(this.nXfs);
                    }
                    if (xf == null) {
                        xf = Xf.updateXf(null, f, bk.getWorkBook());
                    } else {
                        xf.setFont(f);
                        xf.setFormat((short)0);
                    }
                    if (fmtId > 0) {
                        if (this.fmts.get(fmtId) != null) {
                            fmtId = (Integer)this.fmts.get(fmtId);
                        }
                        xf.setFormat((short)fmtId);
                    }
                    if (borderId > -1) {
                        Border b = (Border)this.borders.get(borderId);
                        xf.setAllBorderLineStyles(b.getBorderStyles());
                        xf.setAllBorderColors(b.getBorderColorInts());
                    }
                    if (fillId > 0) {
                        xf.setFill(this.fills.get(fillId));
                    }
                    if (this.nXfs == 15 && xf.toString().equals(bk.getWorkBook().getXf(0).toString())) {
                        bk.getWorkBook().setDefaultIxfe(15);
                    }
                    ++this.nXfs;
                    break block35;
                }
                if (!tnm.equals("protection")) break block36;
                Xf xf = bk.getWorkBook().getXf(this.nXfs - 1);
                int j = 0;
                while (j < xpp.getAttributeCount()) {
                    String n = xpp.getAttributeName(j);
                    String v = xpp.getAttributeValue(j);
                    if (n.equals("hidden")) {
                        xf.setFormulaHidden(v.equals("1"));
                    } else if (n.equals("locked")) {
                        xf.setLocked(v.equals("1"));
                    }
                    ++j;
                }
                break block35;
            }
            if (!tnm.equals("alignment")) break block35;
            Xf xf = bk.getWorkBook().getXf(this.nXfs - 1);
            int j = 0;
            while (j < xpp.getAttributeCount()) {
                String n = xpp.getAttributeName(j);
                String v = xpp.getAttributeValue(j);
                if (n.equals("horizontal")) {
                    int ha = this.sLookup(v, horizontalAlignment);
                    xf.setHorizontalAlignment(ha);
                } else if (n.equals("vertical")) {
                    int va = this.sLookup(v, verticalAlignment);
                    xf.setVerticalAlignment(va);
                } else if (n.equals("indent")) {
                    xf.setIndent(Integer.valueOf(v));
                } else if (n.equals("wrapText")) {
                    xf.setWrapText(true);
                } else if (n.equals("textRotation")) {
                    xf.setRotation(Integer.valueOf(v));
                } else if (n.equals("shrinkToFit")) {
                    xf.setShrinkToFit(true);
                } else if (n.equals("readingOrder")) {
                    xf.setRightToLeftReadingOrder(Integer.valueOf(v));
                }
                ++j;
            }
        }
    }

    private int sLookup(String s, String[] sarr) {
        if (sarr != null && s != null) {
            int i = 0;
            while (i < sarr.length) {
                if (s.equals(sarr[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    static CellHandle sheetAdd(WorkSheetHandle sheet, Object val, int r2, int c, int fmtid) {
        return sheet.add(val, r2, c, fmtid);
    }

    protected static String[] storeEmbeds(ZipFile zip, ZipEntry target, String p, String externalDir) throws IOException {
        ArrayList embeds = OOXMLReader.parseRels(OOXMLReader.wrapInputStream(OOXMLReader.wrapInputStream(zip.getInputStream(target))));
        Collections.sort(embeds, new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer a = Integer.valueOf(((String[])o1)[2].substring(3));
                Integer b = Integer.valueOf(((String[])o2)[2].substring(3));
                return a.compareTo(b);
            }
        });
        String[] strEmbeds = new String[embeds.size()];
        int j = 0;
        while (j < embeds.size()) {
            String[] v = (String[])embeds.get(j);
            String path = StringTool.getPath(v[1]);
            path = OOXMLReader.parsePathForZip(path, p);
            v[1] = StringTool.stripPath(v[1]);
            if (!v[0].equalsIgnoreCase("externalLinkPath")) {
                try {
                    OOXMLReader.passThrough(zip, String.valueOf(path) + v[1], String.valueOf(externalDir) + v[1]);
                }
                catch (NullPointerException e) {
                    throw new NullPointerException();
                }
            }
            strEmbeds[j] = String.valueOf(v[0]) + "/" + path + v[1];
            ++j;
        }
        return strEmbeds;
    }

    void addNames(WorkBookHandle bk, ArrayList namedRanges) {
        int j = 0;
        while (j < namedRanges.size()) {
            String[] s = (String[])namedRanges.get(j);
            if (!s[0].equals("") || !s[2].equals("")) {
                try {
                    if (s[0].indexOf("_xlnm") == 0) {
                        String sh = s[2].substring(0, s[2].indexOf("!"));
                        if (s[0].equals("_xlnm.Print_Area")) {
                            try {
                                bk.getWorkSheet(sh).getMysheet().setPrintArea(s[2]);
                            }
                            catch (OutOfMemoryError e) {
                                Logger.logWarn("OOXMLAdapter.parse OOME setting PrintArea");
                            }
                        } else if (s[0].equals("_xlnm.Print_Titles")) {
                            try {
                                bk.getWorkSheet(sh).getMysheet().setPrintTitles(s[2]);
                            }
                            catch (OutOfMemoryError e) {
                                Logger.logWarn("OOXMLAdapter.parse OOME setting PrintTitles");
                            }
                        }
                    } else if (!s[2].startsWith("[")) {
                        int scope = 0;
                        if (!s[1].equals("")) {
                            scope = Integer.parseInt(s[1]) + 1;
                        }
                        new Name(bk.getWorkBook(), s[0], s[2], scope);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (Exception exception) {}
            } else {
                Logger.logErr("OOXMLAdapter.parse: failed retrieving Named Range");
            }
            ++j;
        }
    }

    void addInlineStrings(WorkBookHandle bk, HashMap inlineStrs) {
        for (String cellAddr : inlineStrs.keySet()) {
            String s = (String)inlineStrs.get(cellAddr);
            int[] rc = ExcelTools.getRowColFromString(cellAddr);
            try {
                CellHandle ch = bk.getCell(cellAddr);
                ch.setVal(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected CellHandle sheetAdd(WorkSheetHandle sheet, Object val, Object cachedval, int r2, int c, int fmtid) {
        CellHandle ch = OOXMLReader.sheetAdd(sheet, val, r2, c, fmtid);
        ((Formula)ch.getCell()).setCachedValue(cachedval);
        return ch;
    }

    void addFormulas(WorkBookHandle bk, ArrayList formulas) {
        WorkSheetHandle sheet = null;
        HashMap<Integer, Object[]> sharedFormulas = new HashMap<Integer, Object[]>();
        int j = 0;
        while (j < formulas.size()) {
            String[] s = (String[])formulas.get(j);
            if (!s[0].equals("") && !s[1].equals("") && s.length >= 8) {
                try {
                    BiffRec br;
                    String addr = s[1];
                    int[] rc = ExcelTools.getRowColFromString(addr);
                    String fStr = s[2];
                    String type = s[5];
                    String fType = "";
                    if (s[5].indexOf(47) > 0) {
                        type = s[5].split("/")[0];
                        fType = s[5].split("/")[1];
                    }
                    int fmtid = 0;
                    try {
                        fmtid = Integer.valueOf(s[7]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Object cachedValue = s[8];
                    if (type.equals("n")) {
                        try {
                            cachedValue = Integer.valueOf((String)cachedValue);
                        }
                        catch (NumberFormatException e) {
                            cachedValue = new Double((String)cachedValue);
                        }
                    } else if (type.equals("b")) {
                        cachedValue = Boolean.valueOf((String)cachedValue);
                    }
                    CellHandle ch = null;
                    try {
                        sheet = bk.getWorkSheet(s[0]);
                        ch = sheet.getCell(addr);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (fStr.equals("null")) {
                        Logger.logWarn("OOXMLAdapter.parse: invalid formula encountered at " + addr);
                    }
                    if (fType.equals("array")) {
                        int[] arrayref = null;
                        if (s[4] != null) {
                            sheet.getMysheet().addParentArrayRef(s[1], s[4]);
                            arrayref = ExcelTools.getRangeRowCol(s[4]);
                        } else {
                            arrayref = rc;
                        }
                        int r2 = arrayref[0];
                        while (r2 <= arrayref[2]) {
                            int c = arrayref[1];
                            while (c <= arrayref[3]) {
                                try {
                                    ch = sheet.getCell(r2, c);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (ch == null) {
                                    ch = this.sheetAdd(sheet, "{" + fStr + "}", cachedValue, r2, c, fmtid);
                                } else {
                                    ch.setFormatId(fmtid);
                                    ch.setFormula("{" + fStr + "}", cachedValue);
                                }
                                ++c;
                            }
                            ++r2;
                        }
                    } else if (fType.equals("datatable")) {
                        if (ch == null) {
                            ch = this.sheetAdd(sheet, fStr, cachedValue, rc[0], rc[1], fmtid);
                        } else {
                            ch.setFormatId(fmtid);
                            ch.setFormula(fStr, cachedValue);
                        }
                    } else if (fType.equals("shared") && !s[3].equals("")) {
                        Integer si = Integer.valueOf(s[3]);
                        if (!sharedFormulas.containsKey(si)) {
                            if (ch == null) {
                                ch = this.sheetAdd(sheet, fStr, cachedValue, rc[0], rc[1], fmtid);
                            } else {
                                ch.setFormatId(fmtid);
                                ch.setFormula(fStr, cachedValue);
                            }
                            int[] range = ExcelTools.getRangeCoords(s[3]);
                            range[0] = range[0] - 1;
                            range[2] = range[2] - 1;
                            Stack expressionStack = this.cloneStack(ch.getFormulaHandle().getFormulaRec().getExpression());
                            sharedFormulas.put(si, new Object[]{expressionStack, rc, range});
                        } else {
                            Object[] o = (Object[])sharedFormulas.get(si);
                            Stack ss = this.cloneStack((Stack)o[0]);
                            int[] rcOrig = (int[])o[1];
                            Formula.incrementSharedFormula(ss, rc[0] - rcOrig[0], rc[1] - rcOrig[1], (int[])o[2]);
                            if (ch == null) {
                                ch = this.sheetAdd(sheet, "=0", null, rc[0], rc[1], fmtid);
                                ch.setFormula(ss, cachedValue);
                            } else {
                                ch.setFormula(ss, cachedValue);
                                ch.setFormatId(fmtid);
                            }
                        }
                    } else if (ch == null) {
                        ch = this.sheetAdd(sheet, fStr, cachedValue, rc[0], rc[1], fmtid);
                    } else {
                        ch.setFormatId(fmtid);
                        ch.setFormula(fStr, cachedValue);
                    }
                    if (s[6] != null && ch != null && (br = ch.getCell()) instanceof Formula) {
                        ch.getFormulaHandle().setCalcAlways(true);
                    }
                }
                catch (FunctionNotSupportedException e) {
                    Logger.logErr("OOXMLAdapter.parse: failed setting formula " + s[1] + " to cell " + s[0] + ": " + e.toString());
                }
                catch (Exception e) {
                    Logger.logErr("OOXMLAdapter.parse: failed setting formula " + s[1] + " to cell " + s[0] + ": " + e.toString());
                }
            }
            ++j;
        }
    }

    void addPivotTables(WorkBookHandle bk, ZipFile zip, HashMap<String, WorkSheetHandle> pivotTables) throws IOException {
        for (String key : pivotTables.keySet()) {
            ZipEntry target = zip.getEntry(key);
            WorkSheetHandle sheet = pivotTables.get(key);
            PivotTableDefinition.parseOOXML(bk, sheet.getMysheet(), OOXMLReader.wrapInputStream(zip.getInputStream(target)));
        }
    }

    public static void refreshExternalFiles(ZipFile zipIn, String externalDir) {
        Enumeration<? extends ZipEntry> ee = zipIn.entries();
        while (ee.hasMoreElements()) {
            ZipEntry ze = ee.nextElement();
            String zename = ze.getName();
            if (zename.equals("xl/workbook.xml") || zename.equals("xl/styles.xml") || zename.equals("xl/sharedStrings.xml") || zename.equals("[Content_Types].xml") || zename.equals("_rels/.rels") || zename.equals("xl/workbook.xml.rels") || zename.startsWith("xl/charts") || zename.startsWith("xl/worksheets")) continue;
            try {
                int z = zename.lastIndexOf("/");
                OOXMLReader.passThrough(zipIn, zename, String.valueOf(externalDir) + zename.substring(z));
            }
            catch (Exception e) {
                Logger.logErr("OOXMLReader.refreshExternalFiles: error retrieving zip entries: " + e.toString());
            }
        }
    }

    private Object lookupRid(ArrayList lst, String rid) {
        int i = 0;
        while (i < lst.size()) {
            Object[] o = (Object[])lst.get(i);
            if (rid.equals(o[0])) {
                return o[1];
            }
            ++i;
        }
        return null;
    }
}

