/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.OOXML.Text;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Continue;
import com.extentech.formats.XLS.MSODrawing;
import com.extentech.formats.XLS.Obj;
import com.extentech.formats.XLS.Sheet;
import com.extentech.formats.XLS.Sst;
import com.extentech.formats.XLS.Txo;
import com.extentech.formats.XLS.Unicodestring;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;

public final class Note
extends XLSRecord {
    private short id;
    boolean hidden = true;
    private String author;
    private byte auth_encoding;
    private MSODrawing mso = null;
    private static final long serialVersionUID = -1571461658267879478L;
    Txo txo = null;
    private byte[] PROTOTYPE_BYTES;

    public Note() {
        byte[] byArray = new byte[10];
        byArray[6] = 1;
        byArray[8] = 4;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        this.rw = ByteTools.readShort(this.getData()[0], this.getData()[1]);
        this.col = ByteTools.readShort(this.getData()[2], this.getData()[3]);
        this.hidden = this.getData()[4] != 2;
        this.id = ByteTools.readShort(this.getData()[6], this.getData()[7]);
        byte authorlen = this.getData()[8];
        this.auth_encoding = this.getData()[9];
        byte[] authorbytes = new byte[authorlen];
        System.arraycopy(this.getData(), 11, authorbytes, 0, authorlen);
        if (this.auth_encoding == 0) {
            this.author = new String(authorbytes);
        } else {
            try {
                this.author = new String(authorbytes, "UTF-16LE");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setSheet(Sheet bs) {
        super.setSheet(bs);
        this.txo = this.getAssociatedTxo();
    }

    @Override
    public String toString() {
        String s = "";
        if (this.txo != null) {
            s = this.txo.getStringVal();
        }
        if (this.author != null) {
            s = String.valueOf(s) + " author:" + this.author;
        }
        return "NOTE at [" + this.getCellAddressWithSheet() + "]: " + s;
    }

    public static XLSRecord getPrototype(String author) {
        Note n = new Note();
        n.setOpcode((short)28);
        byte[] authbytes = author.getBytes();
        byte[] data = new byte[n.PROTOTYPE_BYTES.length + authbytes.length + 1];
        data[8] = (byte)author.length();
        System.arraycopy(authbytes, 0, data, 11, authbytes.length);
        n.setData(data);
        n.init();
        return n;
    }

    public void setRowCol(int row, int col) {
        this.rw = (short)row;
        this.col = (short)col;
        byte[] b = ByteTools.shortToLEBytes((short)this.rw);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
        b = ByteTools.shortToLEBytes(this.col);
        this.getData()[2] = b[0];
        this.getData()[3] = b[1];
    }

    public void setId(int id) {
        this.id = (short)id;
        byte[] b = ByteTools.shortToLEBytes(this.id);
        this.getData()[6] = b[0];
        this.getData()[7] = b[1];
    }

    public int getId() {
        return this.id;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        if (this.mso == null) {
            this.mso = this.getAssociatedMso();
        }
        if (this.hidden) {
            this.getData()[4] = 0;
            this.mso.setOPTSubRecord(959, false, false, 131074, null);
        } else {
            this.getData()[4] = 2;
            this.mso.setOPTSubRecord(959, false, false, 131072, null);
        }
    }

    public String getText() {
        if (this.txo != null) {
            return this.txo.getStringVal();
        }
        return null;
    }

    public void setText(String txt) {
        if (this.txo != null) {
            try {
                this.txo.setStringVal(txt);
            }
            catch (IllegalArgumentException e) {
                Logger.logErr(e.toString());
            }
        }
    }

    public void setText(Unicodestring txt) {
        if (this.txo != null) {
            try {
                this.txo.setStringVal(txt);
            }
            catch (IllegalArgumentException e) {
                Logger.logErr(e.toString());
            }
        }
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
        byte[] authbytes = this.author.getBytes();
        byte[] oldData = this.getData();
        byte[] newData = new byte[authbytes.length + 11];
        System.arraycopy(oldData, 0, newData, 0, 8);
        newData[8] = (byte)author.length();
        System.arraycopy(authbytes, 0, newData, 11, authbytes.length);
        this.setData(newData);
        this.init();
    }

    /*
     * Unable to fully structure code
     */
    private Txo getAssociatedTxo() {
        block4: {
            bs = this.getSheet();
            idx = -1;
            if (bs == null) break block4;
            idx = bs.getIndexOf((short)93);
            if (idx != -1) ** GOTO lbl14
            return null;
lbl-1000:
            // 1 sources

            {
                if (((BiffRec)bs.getSheetRecs().get(idx)).getOpcode() == 93 && (o = (Obj)bs.getSheetRecs().get(idx)).getObjType() == 25 && o.getObjId() == this.id) {
                    ++idx;
                    while (idx < bs.getSheetRecs().size() && ((BiffRec)bs.getSheetRecs().get(idx)).getOpcode() != 438) {
                        ++idx;
                    }
                    break;
                }
                ++idx;
lbl14:
                // 2 sources

                ** while (idx < bs.getSheetRecs().size())
            }
        }
        if (idx < bs.getSheetRecs().size()) {
            return (Txo)bs.getSheetRecs().get(idx);
        }
        return null;
    }

    public short[] getTextBoxBounds() {
        if (this.mso == null) {
            this.mso = this.getAssociatedMso();
        }
        return this.mso.getBounds();
    }

    public void setTextBoxBounds(short[] bounds) {
        if (this.mso == null) {
            this.mso = this.getAssociatedMso();
        }
        this.mso.setBounds(bounds);
    }

    public void setTextBoxWidth(short width) {
        if (this.mso == null) {
            this.mso = this.getAssociatedMso();
        }
        this.mso.setWidth((short)Math.round((double)width / 6.4));
    }

    public void setTextBoxHeight(short height) {
        if (this.mso == null) {
            this.mso = this.getAssociatedMso();
        }
        this.mso.setHeight((short)Math.round(height));
    }

    public void setFormattingRuns(ArrayList formattingRuns) {
        if (this.txo != null) {
            this.txo.setFormattingRuns(formattingRuns);
        }
    }

    public ArrayList getFormattingRuns() {
        if (this.txo != null) {
            this.txo.getFormattingRuns();
        }
        return null;
    }

    public int getSPID() {
        if (this.mso == null) {
            this.mso = this.getAssociatedMso();
        }
        return this.mso.getSPID();
    }

    /*
     * Unable to fully structure code
     */
    private MSODrawing getAssociatedMso() {
        block4: {
            bs = this.getSheet();
            idx = -1;
            if (bs == null) break block4;
            idx = bs.getIndexOf((short)93);
            if (idx != -1) ** GOTO lbl15
            return null;
lbl-1000:
            // 1 sources

            {
                if (((BiffRec)bs.getSheetRecs().get(idx)).getOpcode() == 93 && (o = (Obj)bs.getSheetRecs().get(idx)).getObjType() == 25 && o.getObjId() == this.id) {
                    opcodeprev = ((BiffRec)bs.getSheetRecs().get(idx - 1)).getOpcode();
                    opcodenext = ((BiffRec)bs.getSheetRecs().get(idx + 1)).getOpcode();
                    if (opcodeprev == 236) {
                        return (MSODrawing)bs.getSheetRecs().get(idx - 1);
                    }
                    if (opcodenext == 60 && idx + 5 < bs.getSheetRecs().size()) {
                        return ((Continue)bs.getSheetRecs().get((int)(idx + 5))).maskedMso;
                    }
                }
                ++idx;
lbl15:
                // 2 sources

                ** while (idx < bs.getSheetRecs().size())
            }
        }
        return null;
    }

    public String getOOXML() {
        if (this.txo == null) {
            return "";
        }
        Text t = new Text(Sst.createUnicodeString(this.getText(), this.txo.getFormattingRuns(), 1));
        return t.getOOXML(this.getWorkBook());
    }
}

