/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.Mul;
import com.extentech.formats.XLS.Rk;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Mulrk
extends XLSRecord
implements Mul {
    private static final long serialVersionUID = 1438740082267768419L;
    boolean removed = false;
    short colFirst;
    int colLast;
    int datalen;
    int numRkRecs = 0;
    List rkrecs;

    @Override
    public boolean removed() {
        return this.removed;
    }

    Mulrk() {
    }

    @Override
    public void init() {
        super.init();
        int datalen = this.getData().length;
        if (datalen <= 0) {
            if (this.DEBUGLEVEL > -1) {
                Logger.logInfo("no data in MULRk");
            }
        } else {
            short s;
            super.initRowCol();
            this.col = this.colFirst = (s = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3)));
            s = ByteTools.readShort(this.getByteAt(datalen - 2), this.getByteAt(datalen - 1));
            this.colLast = s;
            byte[] rkdatax = this.getBytesAt(4, datalen -= 6);
            this.numRkRecs = datalen / 6;
            this.rkrecs = new ArrayList(this.numRkRecs);
            int reccount = 0;
            int rkcol = this.col;
            int i = 4;
            while (i < rkdatax.length) {
                byte[] rkd = this.getBytesAt(i, 6);
                Rk r2 = new Rk();
                r2.init(rkd, this.rw, rkcol++);
                if (this.DEBUGLEVEL > 5) {
                    Logger.logInfo(" rk@" + (rkcol - 1) + ":" + r2.getStringVal());
                }
                i += 6;
                if (reccount == this.numRkRecs) break;
                r2.setMyMul(this);
                r2.setSheet(this.getSheet());
                r2.streamer = this.streamer;
                this.rkrecs.add(r2);
                ++reccount;
            }
            if (this.DEBUGLEVEL > 5) {
                Logger.logInfo("Done adding Rk recs to: " + this.getCellAddress());
            }
        }
    }

    void deleteRk(Rk rik) {
        this.rkrecs.remove(rik);
    }

    void addRk(Rk rik) {
        this.rkrecs.add(rik);
    }

    int getColFirst() {
        return this.colFirst;
    }

    @Override
    public List getRecs() {
        return this.rkrecs;
    }

    Rk getRk(int rnum) {
        return (Rk)this.rkrecs.get(rnum);
    }

    public Mulrk splitMulrk(int splitcol) {
        if (splitcol < this.colFirst || splitcol > this.colLast) {
            return null;
        }
        Mulrk newmul = new Mulrk();
        newmul.colFirst = (short)splitcol;
        newmul.colLast = this.colLast;
        this.colLast = splitcol - 1;
        for (Rk r2 : this.getRecs()) {
            if (r2.getRowNumber() < splitcol) continue;
            this.deleteRk(r2);
            newmul.addRk(r2);
        }
        newmul.setOpcode(this.getOpcode());
        newmul.setLength(this.getLength());
        return newmul;
    }

    CompatibleVector removeRk(Rk rok) {
        int z;
        CompatibleVector rez = new CompatibleVector();
        this.colLast = rok.getColNumber() - 1;
        this.rkrecs.remove(rok);
        int i = z = this.rkrecs.size() - 1;
        while (i >= 0) {
            Rk rec = (Rk)this.rkrecs.get(i);
            if (rec.getColNumber() > this.colLast) {
                rez.add(rec);
                this.rkrecs.remove(i);
            }
            --i;
        }
        this.updateRks();
        return rez;
    }

    public void setRow(int i) {
        byte[] r2 = ByteTools.shortToLEBytes((short)i);
        System.arraycopy(r2, 0, this.getData(), 0, 2);
        this.rw = i;
    }

    void updateRks() {
        if (this.getRecs().size() < 1) {
            this.getSheet().removeRecFromVec(this);
            return;
        }
        byte[] tmp = new byte[4];
        System.arraycopy(this.getData(), 0, tmp, 0, 4);
        Iterator it = this.getRecs().iterator();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(tmp);
            while (it.hasNext()) {
                out.write(((Rk)it.next()).getBytes());
            }
            out.write(ByteTools.shortToLEBytes((short)this.colLast));
        }
        catch (IOException a) {
            Logger.logInfo("parsing record continues failed: " + a);
        }
        this.setData(out.toByteArray());
    }
}

