/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.XLSConstants;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

class HLinkStruct
implements XLSConstants,
Serializable {
    private static final long serialVersionUID = -1915454683496117350L;
    boolean isLink;
    boolean isAbsoluteLink;
    boolean hasDescription;
    boolean hasTextMark;
    boolean hasTargetFrame;
    boolean isUNCPath;
    byte[] grbit;
    boolean DEBUG;
    String url;
    String linktext;
    String textMark;
    String targetFrame;
    int int1;
    int urlcch;
    int int4;
    private byte[] mybytes;
    static final byte[] URL_GUID;
    static final byte[] FILE_GUID;

    static {
        byte[] byArray = new byte[16];
        byArray[0] = -32;
        byArray[1] = -55;
        byArray[2] = -22;
        byArray[3] = 121;
        byArray[4] = -7;
        byArray[5] = -70;
        byArray[6] = -50;
        byArray[7] = 17;
        byArray[8] = -116;
        byArray[9] = -126;
        byArray[11] = -86;
        byArray[13] = 75;
        byArray[14] = -87;
        byArray[15] = 11;
        URL_GUID = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[0] = 3;
        byArray2[1] = 3;
        byArray2[8] = -64;
        byArray2[15] = 70;
        FILE_GUID = byArray2;
    }

    void decodeGrbit(byte[] grbytes) {
        if ((byte)(grbytes[0] & 1) > 0) {
            this.isLink = true;
        }
        if ((byte)(grbytes[0] & 2) > 0) {
            this.isAbsoluteLink = true;
        }
        if ((byte)(grbytes[0] & 0x14) >= 20) {
            this.hasDescription = true;
        }
        if ((byte)(grbytes[0] & 8) > 0) {
            this.hasTextMark = true;
        }
        if ((byte)(grbytes[0] & 0x80) > 0) {
            this.hasTargetFrame = true;
        }
        if ((byte)(grbytes[0] & 0x100) > 0) {
            this.isUNCPath = true;
        }
    }

    void setGrbit() {
        this.grbit[0] = 0;
        if (this.isLink) {
            this.grbit[0] = (byte)(1 | this.grbit[0]);
        }
        if (this.isAbsoluteLink) {
            this.grbit[0] = (byte)(2 | this.grbit[0]);
        }
        if (this.hasDescription) {
            this.grbit[0] = (byte)(0x14 | this.grbit[0]);
        }
        if (this.hasTextMark) {
            this.grbit[0] = (byte)(8 | this.grbit[0]);
        }
        if (this.hasTargetFrame) {
            this.grbit[0] = (byte)(0x80 | this.grbit[0]);
        }
        if (this.isUNCPath) {
            this.grbit[0] = (byte)(0x100 | this.grbit[0]);
        }
        this.mybytes[28] = this.grbit[0];
    }

    int getUrlPos() {
        return this.urlcch;
    }

    byte[] getBytes() {
        return this.mybytes;
    }

    String getUrl() {
        if (this.textMark.equals("")) {
            return this.url;
        }
        return String.valueOf(this.url) + "#" + this.textMark;
    }

    public String getLinkText() {
        return this.linktext;
    }

    void setUrl(String url) {
        this.setUrl(url, url, "");
    }

    void setUrl(String ur, String desc) {
        this.setUrl(this.url, desc, "");
    }

    void setUrl(String ur, String desc, String textMark) {
        this.isLink = true;
        this.isAbsoluteLink = true;
        this.isUNCPath = false;
        this.hasDescription = desc.length() > 0;
        this.hasTextMark = textMark.length() > 0;
        this.setBytes(ur, desc, textMark);
    }

    void setFileURL(String ur, String desc, String textMark) {
        this.isLink = true;
        this.isAbsoluteLink = false;
        this.isUNCPath = false;
        this.hasDescription = desc.length() > 0;
        this.hasTextMark = textMark.length() > 0;
        this.setBytes(ur, desc, textMark);
    }

    void setBytes(String ur, String desc, String tm) {
        try {
            byte[] newcchbytes;
            int newcch;
            this.setGrbit();
            int pos = 32;
            byte[] blankbytes = new byte[2];
            byte[] newbytes = new byte[pos];
            System.arraycopy(this.mybytes, 0, newbytes, 0, pos);
            if (this.hasDescription) {
                byte[] descbytes = desc.getBytes("UTF-16LE");
                newcch = descbytes.length;
                newcchbytes = ByteTools.cLongToLEBytes(newcch / 2 + 1);
                newbytes = ByteTools.append(newcchbytes, newbytes);
                newbytes = ByteTools.append(descbytes, newbytes);
                newbytes = ByteTools.append(blankbytes, newbytes);
            }
            newbytes = ByteTools.append(URL_GUID, newbytes);
            if (this.isLink) {
                byte[] urlbytes = ur.getBytes("UTF-16LE");
                newcch = urlbytes.length;
                newcchbytes = ByteTools.cLongToLEBytes(newcch + 2);
                newbytes = ByteTools.append(newcchbytes, newbytes);
                newbytes = ByteTools.append(urlbytes, newbytes);
                newbytes = ByteTools.append(blankbytes, newbytes);
            }
            if (this.hasTextMark) {
                byte[] tmbytes = tm.getBytes("UTF-16LE");
                newcch = tmbytes.length;
                newcchbytes = ByteTools.cLongToLEBytes(newcch / 2 + 1);
                newbytes = ByteTools.append(newcchbytes, newbytes);
                newbytes = ByteTools.append(tmbytes, newbytes);
                newbytes = ByteTools.append(blankbytes, newbytes);
            }
            this.mybytes = newbytes;
            this.linktext = desc;
            this.textMark = tm;
            this.url = ur;
        }
        catch (UnsupportedEncodingException e) {
            Logger.logWarn("Setting URL failed: " + ur + ": " + e);
        }
    }

    HLinkStruct(byte[] barr) {
        block28: {
            int cch;
            int pos;
            block27: {
                block26: {
                    int cch2;
                    block25: {
                        this.isLink = false;
                        this.isAbsoluteLink = false;
                        this.hasDescription = false;
                        this.hasTextMark = false;
                        this.hasTargetFrame = false;
                        this.isUNCPath = false;
                        this.grbit = new byte[4];
                        this.DEBUG = false;
                        this.url = "";
                        this.linktext = "";
                        this.textMark = "";
                        this.targetFrame = "";
                        this.int1 = -1;
                        this.urlcch = -1;
                        this.int4 = -1;
                        this.mybytes = null;
                        this.mybytes = barr;
                        pos = 28;
                        System.arraycopy(barr, 28, this.grbit, 0, 4);
                        this.decodeGrbit(this.grbit);
                        pos += 4;
                        if (this.hasDescription && (cch2 = ByteTools.readInt(barr[pos++], barr[pos++], barr[pos++], barr[pos++])) > 0) {
                            try {
                                byte[] descripbytes = new byte[cch2 * 2 - 2];
                                System.arraycopy(barr, pos, descripbytes, 0, cch2 * 2 - 2);
                                this.linktext = new String(descripbytes, "UTF-16LE");
                                pos += cch2 * 2;
                                if (this.DEBUG) {
                                    Logger.logInfo("Hlink.hlstruct Display URL: " + this.linktext);
                                }
                            }
                            catch (Exception e) {
                                if (!this.DEBUG) break block25;
                                Logger.logWarn("decoding Display URL in Hlink: " + e);
                            }
                        }
                    }
                    if (this.hasTargetFrame && (cch2 = ByteTools.readInt(barr[pos++], barr[pos++], barr[pos++], barr[pos++])) > 0) {
                        try {
                            byte[] tfbytes = new byte[cch2 * 2 - 2];
                            System.arraycopy(barr, pos, tfbytes, 0, cch2 * 2 - 2);
                            this.targetFrame = new String(tfbytes, "UTF-16LE");
                            if (this.DEBUG) {
                                Logger.logInfo("Hlink.hlstruct targetFrame: " + this.targetFrame);
                            }
                            pos += cch2 * 2;
                        }
                        catch (Exception e) {
                            if (!this.DEBUG) break block26;
                            Logger.logWarn("Hlink Decode of targetFrame failed: " + e);
                        }
                    }
                }
                if (this.isLink) {
                    byte[] GUID = new byte[16];
                    System.arraycopy(barr, pos, GUID, 0, 16);
                    boolean bIsCurrentFileRef = Arrays.equals(GUID, FILE_GUID);
                    pos += 16;
                    if (!bIsCurrentFileRef) {
                        this.urlcch = ByteTools.readInt(barr[pos++], barr[pos++], barr[pos++], barr[pos++]);
                        if (this.urlcch > 0) {
                            try {
                                byte[] urlbytes = new byte[this.urlcch - 2];
                                System.arraycopy(barr, pos, urlbytes, 0, this.urlcch - 2);
                                this.url = new String(urlbytes, "UTF-16LE");
                                if (this.DEBUG) {
                                    Logger.logInfo("Hlink.hlstruct URL: " + this.url);
                                }
                                pos += this.urlcch;
                            }
                            catch (Exception e) {
                                if (this.DEBUG) {
                                    Logger.logWarn("Hlink Decode of URL failed: " + e);
                                }
                            }
                        }
                    } else {
                        short dirUps = ByteTools.readShort(barr[pos++], barr[pos++]);
                        this.urlcch = ByteTools.readInt(barr[pos++], barr[pos++], barr[pos++], barr[pos++]);
                        if (this.urlcch > 0) {
                            try {
                                int extraInfo;
                                byte[] urlbytes = new byte[this.urlcch - 1];
                                System.arraycopy(barr, pos, urlbytes, 0, this.urlcch - 1);
                                this.url = new String(urlbytes, "ISO-8859-1");
                                if (this.DEBUG) {
                                    Logger.logInfo("Hlink.hlstruct File URL: " + this.url);
                                }
                                pos += this.urlcch + 24;
                                if ((extraInfo = ByteTools.readInt(barr[pos++], barr[pos++], barr[pos++], barr[pos++])) > 0) {
                                    pos += extraInfo;
                                    int n = ByteTools.readInt(barr[pos++], barr[pos++], barr[pos++], barr[pos++]);
                                }
                            }
                            catch (Exception e) {
                                if (!this.DEBUG) break block27;
                                Logger.logWarn("Hlink Decode of File URL failed: " + e);
                            }
                        }
                    }
                }
            }
            if (this.hasTextMark && (cch = ByteTools.readInt(barr[pos++], barr[pos++], barr[pos++], barr[pos++])) > 0) {
                try {
                    byte[] tmbytes = new byte[cch * 2 - 2];
                    System.arraycopy(barr, pos, tmbytes, 0, cch * 2 - 2);
                    this.textMark = new String(tmbytes, "UTF-16LE");
                    if (this.DEBUG) {
                        Logger.logInfo("Hlink.hlstruct textMark: " + this.textMark);
                    }
                    pos += cch * 2;
                }
                catch (Exception e) {
                    if (!this.DEBUG) break block28;
                    Logger.logWarn("Hlink Decode of textmark failed: " + e);
                }
            }
        }
    }
}

