/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;

public final class Externname
extends XLSRecord {
    private static final long serialVersionUID = -7153354861666069899L;
    static final byte[] ENDOFRECORDBYTES;
    static final int STRINGLENPOS = 6;
    static final int STRINGPOS = 8;
    static final int STATICPORTIONSIZE = 12;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 2;
        byArray[2] = 28;
        byArray[3] = 23;
        ENDOFRECORDBYTES = byArray;
    }

    @Override
    public void setWorkBook(WorkBook bk) {
        super.setWorkBook(bk);
    }

    @Override
    public void init() {
        super.init();
        short externnametype = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        if (externnametype == 0) {
            short len = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
            byte[] b = this.getBytesAt(8, len);
            String s = new String(b);
            this.getWorkBook().addExternalName(s);
        }
    }

    protected static XLSRecord getPrototype(String s) {
        Externname x = new Externname();
        int len = s.length();
        x.setLength((short)(12 + len));
        x.setOpcode((short)35);
        byte[] dta = new byte[12 + len];
        try {
            byte[] slen = ByteTools.shortToLEBytes((short)len);
            dta[6] = slen[0];
            dta[7] = slen[1];
            byte[] bts = s.getBytes();
            System.arraycopy(bts, 0, dta, 8, bts.length);
            System.arraycopy(ENDOFRECORDBYTES, 0, dta, 8 + len, ENDOFRECORDBYTES.length);
            x.setData(dta);
            x.originalsize = 12 + len;
        }
        catch (Exception e) {
            Logger.logWarn("Exception excountered writing Externname: " + e.toString());
        }
        return x;
    }

    public String[] getExternalNames() {
        return this.getWorkBook().getExternalNames();
    }

    public String getExternalName(int t) {
        return this.getWorkBook().getExternalName(t);
    }
}

