/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.FormulaNotFoundException;
import com.extentech.formats.XLS.Shrfmla;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgAdd;
import com.extentech.formats.XLS.formulas.PtgArea;
import com.extentech.formats.XLS.formulas.PtgArea3d;
import com.extentech.formats.XLS.formulas.PtgAreaErr3d;
import com.extentech.formats.XLS.formulas.PtgAreaN;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgAtr;
import com.extentech.formats.XLS.formulas.PtgBool;
import com.extentech.formats.XLS.formulas.PtgConcat;
import com.extentech.formats.XLS.formulas.PtgDiv;
import com.extentech.formats.XLS.formulas.PtgEQ;
import com.extentech.formats.XLS.formulas.PtgEndSheet;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgExp;
import com.extentech.formats.XLS.formulas.PtgFunc;
import com.extentech.formats.XLS.formulas.PtgFuncVar;
import com.extentech.formats.XLS.formulas.PtgGE;
import com.extentech.formats.XLS.formulas.PtgGT;
import com.extentech.formats.XLS.formulas.PtgInt;
import com.extentech.formats.XLS.formulas.PtgIsect;
import com.extentech.formats.XLS.formulas.PtgLE;
import com.extentech.formats.XLS.formulas.PtgLT;
import com.extentech.formats.XLS.formulas.PtgMemArea;
import com.extentech.formats.XLS.formulas.PtgMemAreaA;
import com.extentech.formats.XLS.formulas.PtgMemAreaN;
import com.extentech.formats.XLS.formulas.PtgMemAreaNV;
import com.extentech.formats.XLS.formulas.PtgMemErr;
import com.extentech.formats.XLS.formulas.PtgMemFunc;
import com.extentech.formats.XLS.formulas.PtgMissArg;
import com.extentech.formats.XLS.formulas.PtgMlt;
import com.extentech.formats.XLS.formulas.PtgMystery;
import com.extentech.formats.XLS.formulas.PtgNE;
import com.extentech.formats.XLS.formulas.PtgName;
import com.extentech.formats.XLS.formulas.PtgNameX;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.formats.XLS.formulas.PtgParen;
import com.extentech.formats.XLS.formulas.PtgPercent;
import com.extentech.formats.XLS.formulas.PtgPower;
import com.extentech.formats.XLS.formulas.PtgRange;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.XLS.formulas.PtgRef3d;
import com.extentech.formats.XLS.formulas.PtgRefErr;
import com.extentech.formats.XLS.formulas.PtgRefErr3d;
import com.extentech.formats.XLS.formulas.PtgRefN;
import com.extentech.formats.XLS.formulas.PtgStr;
import com.extentech.formats.XLS.formulas.PtgSub;
import com.extentech.formats.XLS.formulas.PtgUMinus;
import com.extentech.formats.XLS.formulas.PtgUPlus;
import com.extentech.formats.XLS.formulas.PtgUnion;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public final class ExpressionParser
implements Serializable {
    private static final long serialVersionUID = 4745215965823234010L;
    private static int DEBUGLEVEL = 0;
    public static final short ptgExp = 1;
    public static final short ptgAdd = 3;
    public static final short ptgSub = 4;
    public static final short ptgMlt = 5;
    public static final short ptgDiv = 6;
    public static final short ptgPower = 7;
    public static final short ptgConcat = 8;
    public static final short ptgLT = 9;
    public static final short ptgLE = 10;
    public static final short ptgEQ = 11;
    public static final short ptgGE = 12;
    public static final short ptgGT = 13;
    public static final short ptgNE = 14;
    public static final short ptgIsect = 15;
    public static final short ptgUnion = 16;
    public static final short ptgRange = 17;
    public static final short ptgUPlus = 18;
    public static final short ptgUMinus = 19;
    public static final short ptgPercent = 20;
    public static final short ptgParen = 21;
    public static final short ptgAtr = 25;
    public static final short ptgMissArg = 22;
    public static final short ptgStr = 23;
    public static final short ptgEndSheet = 27;
    public static final short ptgErr = 28;
    public static final short ptgBool = 29;
    public static final short ptgInt = 30;
    public static final short ptgNum = 31;
    public static final short ptgArray = 32;
    public static final short ptgFunc = 33;
    public static final short ptgFuncVar = 34;
    public static final short ptgName = 35;
    public static final short ptgRef = 36;
    public static final short ptgArea = 37;
    public static final short ptgMemArea = 38;
    public static final short ptgMemErr = 39;
    public static final short ptgMemFunc = 41;
    public static final short ptgRefErr = 42;
    public static final short ptgAreaErr = 43;
    public static final short ptgRefN = 44;
    public static final short ptgAreaN = 45;
    public static final short ptgNameX = 57;
    public static final short ptgRef3d = 58;
    public static final short ptgArea3d = 59;
    public static final short ptgRefErr3d = 60;
    public static final short ptgAreaErr3d = 61;
    public static final short ptgMemAreaA = 102;
    public static final short ptgMemAreaNV = 78;
    public static final short ptgMemAreaN = 46;

    public static Stack parseExpression(byte[] function, XLSRecord rec) {
        return ExpressionParser.parseExpression(function, rec, function.length);
    }

    public static Stack parseExpression(byte[] function, XLSRecord rec, int expressionLen) {
        byte[] b;
        Stack<GenericPtg> stack = new Stack<GenericPtg>();
        short ptg = 0;
        int ptgLen = 0;
        boolean hasArrays = false;
        CompatibleVector arrayLocs = new CompatibleVector();
        if (expressionLen > function.length) {
            expressionLen = function.length;
        }
        XLSRecord p = rec;
        int i = 0;
        while (i < expressionLen) {
            ptg = (function[i] & 0x40) == 64 ? (short)((function[i] | 0x20) & 0x3F) : (short)(function[i] & 0x3F);
            switch (ptg) {
                case 1: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgExp Located");
                    }
                    if (i == 0) {
                        PtgExp px = new PtgExp();
                        ptgLen = px.getLength();
                        byte[] b2 = new byte[ptgLen];
                        if (ptgLen + i <= function.length) {
                            System.arraycopy(function, i, b2, 0, ptgLen);
                        }
                        px.setParentRec(p);
                        px.init(b2);
                        stack.push(px);
                        break;
                    }
                }
                case 23: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgStr Located");
                    }
                    int x = i;
                    ptgLen = function[++x] & 0xFF;
                    byte theGrbit = function[x + 1];
                    if ((theGrbit & 1) == 1) {
                        ptgLen *= 2;
                    }
                    PtgStr pst = new PtgStr();
                    b = new byte[ptgLen += 3];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pst.init(b);
                    pst.setParentRec(p);
                    stack.push(pst);
                    break;
                }
                case 102: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgMemAreaA Located" + function[i]);
                    }
                    int x = i;
                    ptgLen = ByteTools.readShort(function[x += 5], function[x + 1]);
                    PtgMemAreaA pmema = new PtgMemAreaA();
                    b = new byte[ptgLen += 7];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pmema.init(b);
                    pmema.setParentRec(p);
                    stack.push(pmema);
                    break;
                }
                case 46: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgMemAreaN Located" + function[i]);
                    }
                    PtgMemAreaN pmemn = new PtgMemAreaN();
                    ptgLen = pmemn.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pmemn.init(b);
                    pmemn.setParentRec(p);
                    stack.push(pmemn);
                    break;
                }
                case 78: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgMemAreaNV Located" + function[i]);
                    }
                    int x = i;
                    ptgLen = ByteTools.readShort(function[x += 5], function[x + 1]);
                    PtgMemAreaNV pmemv = new PtgMemAreaNV();
                    b = new byte[ptgLen += 7];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pmemv.init(b);
                    pmemv.setParentRec(p);
                    stack.push(pmemv);
                    break;
                }
                case 38: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgMemArea Located" + function[i]);
                    }
                    ptgLen = 7;
                    PtgMemArea pmem = new PtgMemArea();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pmem.init(b);
                    pmem.setParentRec(p);
                    i += ptgLen;
                    ptgLen = pmem.getnTokens();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pmem.setSubExpression(b);
                    stack.push(pmem);
                    break;
                }
                case 41: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgMemFunc Located");
                    }
                    PtgMemFunc pmemf = new PtgMemFunc();
                    int x = i;
                    ptgLen = ByteTools.readShort(function[++x], function[x + 1]);
                    b = new byte[ptgLen += 3];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pmemf.setParentRec(p);
                    pmemf.init(b);
                    stack.push(pmemf);
                    break;
                }
                case 30: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgInt Located");
                    }
                    PtgInt pi = new PtgInt();
                    ptgLen = pi.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pi.init(b);
                    pi.setParentRec(p);
                    stack.push(pi);
                    break;
                }
                case 28: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgErr Located");
                    }
                    PtgErr perr = new PtgErr();
                    ptgLen = perr.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    perr.init(b);
                    perr.setParentRec(p);
                    stack.push(perr);
                    break;
                }
                case 31: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgNum Located");
                    }
                    PtgNumber pnum = new PtgNumber();
                    ptgLen = pnum.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pnum.init(b);
                    pnum.setParentRec(p);
                    stack.push(pnum);
                    break;
                }
                case 29: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgBool Located");
                    }
                    PtgBool pboo = new PtgBool();
                    ptgLen = pboo.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pboo.init(b);
                    pboo.setParentRec(p);
                    stack.push(pboo);
                    break;
                }
                case 35: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgName Located");
                    }
                    PtgName pn = new PtgName();
                    ptgLen = pn.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pn.setParentRec(p);
                    pn.init(b);
                    pn.addListener();
                    stack.push(pn);
                    int chk = i + ptgLen;
                    if (chk >= function.length || function[i + ptgLen] != 0) break;
                    if (DEBUGLEVEL > 1) {
                        Logger.logWarn("Undocumented Name Record mystery byte encountered in Formula: ");
                    }
                    ++i;
                    break;
                }
                case 57: {
                    if (DEBUGLEVEL > 1) {
                        Logger.logInfo("ptgNameX Located");
                    }
                    if (DEBUGLEVEL > 0) {
                        Logger.logWarn("referencing external spreadsheets unsupported.");
                    }
                    PtgNameX pnx = new PtgNameX();
                    ptgLen = pnx.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pnx.init(b);
                    pnx.setParentRec(p);
                    pnx.addListener();
                    stack.push(pnx);
                    break;
                }
                case 36: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgRef Located ");
                    }
                    PtgRef pt = new PtgRef();
                    ptgLen = pt.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pt.setParentRec(p);
                    pt.init(b);
                    pt.addToRefTracker();
                    stack.push(pt);
                    break;
                }
                case 32: {
                    hasArrays = true;
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgArray Located ");
                    }
                    PtgArray pa = new PtgArray();
                    ptgLen = 8;
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pa.init(b);
                    Integer ingr = stack.size();
                    arrayLocs.add(ingr);
                    stack.push(pa);
                    break;
                }
                case 44: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgRefN Located ");
                    }
                    PtgRefN ptn = new PtgRefN(false);
                    ptgLen = ptn.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    ptn.setParentRec(rec);
                    ptn.init(b);
                    if (rec.getOpcode() == 1212) {
                        ptn.addToRefTracker();
                    }
                    stack.push(ptn);
                    break;
                }
                case 37: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgArea Located ");
                    }
                    PtgArea pg = new PtgArea();
                    ptgLen = pg.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pg.setParentRec(p);
                    pg.init(b);
                    pg.addToRefTracker();
                    stack.push(pg);
                    break;
                }
                case 59: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgArea3d Located ");
                    }
                    PtgArea3d pg3 = new PtgArea3d();
                    ptgLen = pg3.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pg3.init(b, p);
                    pg3.addListener();
                    pg3.addToRefTracker();
                    stack.push(pg3);
                    break;
                }
                case 45: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgAreaN Located ");
                    }
                    PtgAreaN pgn = new PtgAreaN();
                    ptgLen = pgn.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pgn.setParentRec(rec);
                    pgn.init(b);
                    if (rec.getOpcode() == 1212) {
                        pgn.addToRefTracker();
                    }
                    stack.push(pgn);
                    break;
                }
                case 61: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgAreaErr3d Located");
                    }
                    PtgAreaErr3d ptfa = new PtgAreaErr3d();
                    ptgLen = ptfa.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    ptfa.setParentRec(p);
                    ptfa.init(b);
                    stack.push(ptfa);
                    break;
                }
                case 60: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgRefErr3d Located");
                    }
                    PtgRefErr3d ptfr = new PtgRefErr3d();
                    ptgLen = ptfr.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    ptfr.setParentRec(p);
                    ptfr.init(b);
                    stack.push(ptfr);
                    break;
                }
                case 39: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgMemErr Located");
                    }
                    PtgMemErr pm = new PtgMemErr();
                    ptgLen = pm.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pm.setParentRec(p);
                    pm.init(b);
                    stack.push(pm);
                    break;
                }
                case 42: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgRefErr Located");
                    }
                    PtgRefErr pr = new PtgRefErr();
                    ptgLen = pr.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pr.setParentRec(p);
                    pr.init(b);
                    stack.push(pr);
                    break;
                }
                case 27: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgEndSheet Located");
                    }
                    PtgEndSheet prs = new PtgEndSheet();
                    ptgLen = prs.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    prs.init(b);
                    prs.setParentRec(p);
                    stack.push(prs);
                    break;
                }
                case 58: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgRef3d Located");
                    }
                    PtgRef3d pr3 = new PtgRef3d();
                    ptgLen = pr3.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pr3.setParentRec(p);
                    pr3.init(b);
                    pr3.addListener();
                    pr3.addToRefTracker();
                    stack.push(pr3);
                    if (!pr3.isExternalLink() || p.getOpcode() != 6) break;
                    ((Formula)p).setIsExternalRef(true);
                    break;
                }
                case 25: {
                    PtgAtr pat = new PtgAtr(0);
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("PtgAtr Located");
                    }
                    ptgLen = pat.getLength();
                    if ((function[i + 1] & 4) == 4) {
                        ptgLen = ByteTools.readShort(function[i + 2], function[i + 3]);
                        ++ptgLen;
                        ptgLen *= 2;
                        ptgLen += 4;
                    }
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pat.init(b);
                    pat.init();
                    pat.setParentRec(p);
                    stack.push(pat);
                    break;
                }
                case 33: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgFunc Located");
                    }
                    PtgFunc ptf = new PtgFunc();
                    ptgLen = ptf.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    ptf.init(b);
                    ptf.setParentRec(p);
                    stack.push(ptf);
                    break;
                }
                case 34: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgFuncVar Located");
                    }
                    PtgFuncVar ptfv = new PtgFuncVar();
                    ptgLen = ptfv.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    ptfv.init(b);
                    ptfv.setParentRec(p);
                    if (ptfv.getFunctionId() == 148) {
                        if (rec.getOpcode() == 6) {
                            ((Formula)rec).setContainsIndirectFunction(true);
                        } else if (rec.getOpcode() == 1212) {
                            ((Shrfmla)rec).setContainsIndirectFunction(true);
                        }
                    }
                    stack.push(ptfv);
                    break;
                }
                case 3: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgAdd Located");
                    }
                    PtgAdd pad = new PtgAdd();
                    ptgLen = pad.getLength();
                    b = new byte[ptgLen];
                    System.arraycopy(function, i, b, 0, ptgLen);
                    pad.init(b);
                    pad.setParentRec(p);
                    stack.push(pad);
                    break;
                }
                case 22: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgMissArg Located");
                    }
                    PtgMissArg pmar = new PtgMissArg();
                    ptgLen = pmar.getLength();
                    b = new byte[ptgLen];
                    System.arraycopy(function, i, b, 0, ptgLen);
                    pmar.init(b);
                    pmar.setParentRec(p);
                    stack.push(pmar);
                    break;
                }
                case 4: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("PtgSub Located");
                    }
                    PtgSub psb = new PtgSub();
                    ptgLen = psb.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    psb.init(b);
                    psb.setParentRec(p);
                    stack.push(psb);
                    break;
                }
                case 5: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("PtgMlt Located");
                    }
                    PtgMlt pml = new PtgMlt();
                    ptgLen = pml.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pml.init(b);
                    pml.setParentRec(p);
                    stack.push(pml);
                    break;
                }
                case 6: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("PtgDiv Located");
                    }
                    PtgDiv pdiv = new PtgDiv();
                    ptgLen = pdiv.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pdiv.init(b);
                    pdiv.setParentRec(p);
                    stack.push(pdiv);
                    break;
                }
                case 18: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("PtgUPlus Located");
                    }
                    PtgUPlus puplus = new PtgUPlus();
                    ptgLen = puplus.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    puplus.init(b);
                    puplus.setParentRec(p);
                    stack.push(puplus);
                    break;
                }
                case 19: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("PtgUminus Located");
                    }
                    PtgUMinus puminus = new PtgUMinus();
                    ptgLen = puminus.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    puminus.init(b);
                    puminus.setParentRec(p);
                    stack.push(puminus);
                    break;
                }
                case 20: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgPercent Located");
                    }
                    PtgPercent pperc = new PtgPercent();
                    ptgLen = pperc.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pperc.init(b);
                    pperc.setParentRec(p);
                    stack.push(pperc);
                    break;
                }
                case 7: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("PtgPower Located");
                    }
                    PtgPower pow = new PtgPower();
                    ptgLen = pow.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pow.init(b);
                    pow.setParentRec(p);
                    stack.push(pow);
                    break;
                }
                case 8: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("PtgConcat Located");
                    }
                    PtgConcat pcon = new PtgConcat();
                    ptgLen = pcon.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pcon.init(b);
                    pcon.setParentRec(p);
                    stack.push(pcon);
                    break;
                }
                case 9: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("PtgLT Located");
                    }
                    PtgLT plt = new PtgLT();
                    ptgLen = plt.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    plt.init(b);
                    plt.setParentRec(p);
                    stack.push(plt);
                    break;
                }
                case 10: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("PtgLE Located");
                    }
                    PtgLE ple = new PtgLE();
                    ptgLen = ple.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    ple.init(b);
                    ple.setParentRec(p);
                    stack.push(ple);
                    break;
                }
                case 11: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("PtgEQ Located");
                    }
                    PtgEQ peq = new PtgEQ();
                    ptgLen = peq.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    peq.init(b);
                    peq.setParentRec(p);
                    stack.push(peq);
                    break;
                }
                case 12: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("PtgGE Located");
                    }
                    PtgGE pge = new PtgGE();
                    ptgLen = pge.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pge.init(b);
                    pge.setParentRec(p);
                    stack.push(pge);
                    break;
                }
                case 13: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("PtgGT Located");
                    }
                    PtgGT pgt = new PtgGT();
                    ptgLen = pgt.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pgt.init(b);
                    pgt.setParentRec(p);
                    stack.push(pgt);
                    break;
                }
                case 14: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("PtgNE Located");
                    }
                    PtgNE pne = new PtgNE();
                    ptgLen = pne.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pne.init(b);
                    pne.setParentRec(p);
                    stack.push(pne);
                    break;
                }
                case 15: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("PtgIsect Located");
                    }
                    PtgIsect pist = new PtgIsect();
                    ptgLen = pist.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pist.init(b);
                    pist.setParentRec(p);
                    stack.push(pist);
                    break;
                }
                case 16: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgUnion Located");
                    }
                    PtgUnion pun = new PtgUnion();
                    ptgLen = pun.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pun.init(b);
                    pun.setParentRec(p);
                    stack.push(pun);
                    break;
                }
                case 17: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("ptgRange Located");
                    }
                    PtgRange pran = new PtgRange();
                    ptgLen = pran.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pran.init(b);
                    pran.setParentRec(p);
                    stack.push(pran);
                    break;
                }
                case 21: {
                    if (DEBUGLEVEL > 5) {
                        Logger.logInfo("PtgParens Located");
                    }
                    PtgParen pp = new PtgParen();
                    ptgLen = pp.getLength();
                    b = new byte[ptgLen];
                    if (ptgLen + i <= function.length) {
                        System.arraycopy(function, i, b, 0, ptgLen);
                    }
                    pp.init(b);
                    pp.setParentRec(p);
                    stack.push(pp);
                    break;
                }
                default: {
                    PtgMystery pmy = new PtgMystery();
                    ptgLen = function.length - i;
                    b = new byte[ptgLen];
                    if (DEBUGLEVEL > 0) {
                        Logger.logWarn("Unsupported Formula Function: 0x" + Integer.toHexString(ptg) + " length: " + ptgLen);
                    }
                    System.arraycopy(function, i, b, 0, ptgLen);
                    pmy.init(b);
                    pmy.setParentRec(p);
                    stack.push(pmy);
                }
            }
            i += ptgLen;
        }
        if (hasArrays && rec instanceof Formula) {
            int startPos = expressionLen;
            int i2 = 0;
            while (i2 < arrayLocs.size()) {
                block164: {
                    Integer ingr = (Integer)arrayLocs.elementAt(i2);
                    PtgArray parr = (PtgArray)stack.elementAt(ingr);
                    b = new byte[function.length - startPos];
                    System.arraycopy(function, startPos, b, 0, b.length);
                    try {
                        parr.setParentRec(rec);
                        startPos += parr.setArrVals(b);
                    }
                    catch (Exception e) {
                        if (DEBUGLEVEL <= 0) break block164;
                        Logger.logInfo("ExpressionParser.parseExpression: Array: " + e);
                    }
                }
                ++i2;
            }
        }
        if (DEBUGLEVEL > 5) {
            Logger.logInfo("finished formula");
        }
        return stack;
    }

    public static List getPtgsByLocation(String loc, Stack expression) throws FormulaNotFoundException {
        Vector<Ptg> lv = new Vector<Ptg>();
        int i = 0;
        while (i < expression.size()) {
            Object o = expression.elementAt(i);
            if (o == null) {
                throw new FormulaNotFoundException("Couldn't get Ptg at: " + loc);
            }
            if (!(o instanceof Byte) && o instanceof Ptg) {
                Ptg part = (Ptg)o;
                String lo = part.getLocation();
                if (lo == null) {
                    lo = "none";
                }
                String comp = loc;
                if (loc.indexOf("!") > -1 && lo.indexOf("!") == -1) {
                    comp = loc.substring(loc.indexOf("!") + 1);
                }
                if (comp.equalsIgnoreCase(lo)) {
                    lv.add(part);
                } else {
                    lo = part.toString();
                    if (loc.equalsIgnoreCase(lo)) {
                        lv.add(part);
                    } else if (!(o instanceof PtgRef3d) && o instanceof PtgArea) {
                        PtgRef first = ((PtgArea)o).getFirstPtg();
                        PtgRef last = ((PtgArea)o).getLastPtg();
                        if (first.getLocation().equalsIgnoreCase(loc)) {
                            lv.add(first);
                        }
                        if (last.getLocation().equalsIgnoreCase(loc)) {
                            lv.add(last);
                        }
                    }
                }
            }
            ++i;
        }
        return lv;
    }

    public static int getExpressionLocByLocation(String loc, Stack expression) throws FormulaNotFoundException {
        int i = 0;
        while (i < expression.size()) {
            Object o = expression.elementAt(i);
            if (o == null) {
                throw new FormulaNotFoundException("Couldn't get Ptg at: " + loc);
            }
            if (!(o instanceof Byte) && o instanceof Ptg) {
                Ptg part = (Ptg)o;
                String lo = part.getLocation();
                if (loc.equalsIgnoreCase(lo)) {
                    return i;
                }
                lo = part.toString();
                if (loc.equalsIgnoreCase(lo)) {
                    return i;
                }
                if (o instanceof PtgArea) {
                    PtgRef first = ((PtgArea)o).getFirstPtg();
                    PtgRef last = ((PtgArea)o).getLastPtg();
                    if (first.getLocation().equalsIgnoreCase(loc)) {
                        return i;
                    }
                    if (last.getLocation().equalsIgnoreCase(loc)) {
                        return i;
                    }
                }
            }
            ++i;
        }
        return -1;
    }

    public static int getExpressionLocByPtg(Ptg ptg, Stack expression) throws FormulaNotFoundException {
        int i = 0;
        while (i < expression.size()) {
            Object o = expression.elementAt(i);
            if (o == null) {
                throw new FormulaNotFoundException("Couldn't get Ptg at: " + ptg.toString());
            }
            if (!(o instanceof Byte) && o instanceof Ptg && ((Ptg)o).equals(ptg)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Ptg[] getCellRangePtgs(Stack expression) throws FormulaNotFoundException {
        Vector<Object> ret = new Vector<Object>();
        int i = 0;
        while (i < expression.size()) {
            Object o = expression.elementAt(i);
            if (o == null) {
                throw new FormulaNotFoundException("Couldn't get Ptg at: " + i);
            }
            if (!(o instanceof Byte) && o instanceof Ptg) {
                String lox;
                Ptg part = (Ptg)o;
                if (part instanceof PtgExp) {
                    lox = part.getLocation();
                    PtgRef ref = new PtgRef();
                    ref.setParentRec(part.getParentRec());
                    ref.setLocation(lox);
                    ret.add(ref);
                } else if (part instanceof PtgRefErr || part instanceof PtgAreaErr3d) {
                    ret.add("#REF!");
                } else if (part instanceof PtgMemFunc) {
                    Ptg[] p = ((PtgMemFunc)part).getComponents();
                    int z = 0;
                    while (z < p.length) {
                        ret.add(p[z]);
                        ++z;
                    }
                } else {
                    lox = part.getLocation();
                    if (lox != null) {
                        ret.add(part);
                    }
                }
            }
            ++i;
        }
        Ptg[] retp = new Ptg[ret.size()];
        return ret.toArray(retp);
    }
}

