/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.XLS.ColumnRange;
import java.io.Serializable;
import java.util.Comparator;

public interface CellAddressible
extends ColumnRange {
    public int getRowNumber();

    public static final class ColumnMajorComparator
    implements Comparator<CellAddressible>,
    Serializable {
        private static final long serialVersionUID = -1193867650674693873L;
        private static final ColumnRange.Comparator colComp = new ColumnRange.Comparator();

        @Override
        public int compare(CellAddressible cell1, CellAddressible cell2) {
            int cols = colComp.compare(cell1, cell2);
            if (cols != 0) {
                return cols;
            }
            return cell1.getRowNumber() - cell2.getRowNumber();
        }
    }

    public static class RangeBoundary
    extends Reference {
        private static final long serialVersionUID = -1357617242449928095L;
        private final boolean before;

        public RangeBoundary(int row, int col, boolean before) {
            super(row, col, col);
            this.before = before;
        }

        public int comareToRange() {
            return this.before ? -1 : 1;
        }
    }

    public static class Reference
    implements CellAddressible,
    Serializable {
        private static final long serialVersionUID = -9071483662123798966L;
        private final int row;
        private final int colFirst;
        private final int colLast;

        public Reference(int row, int colFirst, int colLast) {
            this.row = row;
            this.colFirst = colFirst;
            this.colLast = colLast;
        }

        public Reference(int row, int col) {
            this(row, col, col);
        }

        @Override
        public int getColFirst() {
            return this.colFirst;
        }

        @Override
        public int getColLast() {
            return this.colLast;
        }

        @Override
        public int getRowNumber() {
            return this.row;
        }

        @Override
        public boolean isSingleCol() {
            return this.getColFirst() == this.getColLast();
        }
    }

    public static final class RowMajorComparator
    implements Comparator<CellAddressible>,
    Serializable {
        private static final long serialVersionUID = 5477030152120715766L;
        private static final ColumnRange.Comparator colComp = new ColumnRange.Comparator();

        @Override
        public int compare(CellAddressible cell1, CellAddressible cell2) {
            int rows = cell1.getRowNumber() - cell2.getRowNumber();
            if (rows != 0) {
                return rows;
            }
            return colComp.compare(cell1, cell2);
        }
    }
}

