/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.formats.LEO.BIGBLOCK;
import com.extentech.formats.LEO.LEOFile;
import com.extentech.formats.LEO.Storage;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Blank;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Continue;
import com.extentech.formats.XLS.ContinueHandler;
import com.extentech.formats.XLS.Crn;
import com.extentech.formats.XLS.Dbcell;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.Index;
import com.extentech.formats.XLS.InvalidRecordException;
import com.extentech.formats.XLS.Label;
import com.extentech.formats.XLS.Labelsst;
import com.extentech.formats.XLS.MSODrawing;
import com.extentech.formats.XLS.MSODrawingGroup;
import com.extentech.formats.XLS.Mulblank;
import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.NumberRec;
import com.extentech.formats.XLS.Obj;
import com.extentech.formats.XLS.Pls;
import com.extentech.formats.XLS.Rk;
import com.extentech.formats.XLS.Sst;
import com.extentech.formats.XLS.Supbook;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.WorkBookException;
import com.extentech.formats.XLS.XLSConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.SeriesText;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.FastAddVector;
import com.extentech.toolkit.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ByteStreamer
implements Serializable,
XLSConstants {
    private static final long serialVersionUID = -8188652784510579406L;
    AbstractList records = new FastAddVector();
    private byte[] bytes;
    private String myname = "";
    boolean DEBUG = false;
    protected WorkBook workbook = null;
    private OutputStream out = null;
    int dlen = -1;
    int ridx = 0;

    public int getRecordIndex(int opcode) {
        int i = 0;
        while (i < this.records.size()) {
            XLSRecord rec = (XLSRecord)this.records.get(i);
            if (rec.getOpcode() == opcode) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void initTestRecVect() {
        Logger.logInfo("TestVector on in bytestreamer.stream");
        Vector testVect = new Vector();
        testVect.addAll(this.records);
        Logger.logInfo("TESTING Recvec done.");
    }

    public ByteStreamer(WorkBook bk) {
        this.workbook = bk;
    }

    public Object[] getBiffRecords() {
        return this.records.toArray();
    }

    public void setBiffRecords(Collection recs) {
        if (Arrays.equals(this.records.toArray(), recs.toArray())) {
            return;
        }
        this.records.clear();
        this.records.addAll(recs);
    }

    public void setBytes(byte[] b) {
        this.bytes = b;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getRecVecSize() {
        return this.records.size();
    }

    public String getName() {
        return this.myname;
    }

    public String getSubstreamTypeName() {
        return "ByteStreamer";
    }

    public short getSubstreamType() {
        return 16;
    }

    public BiffRec getRecordAt(int t, BiffRec rec) {
        if (rec instanceof Boundsheet || rec instanceof Dbcell) {
            return this.getRecordAt(t);
        }
        if (rec.getSheet() != null) {
            Boundsheet bs = rec.getSheet();
            return (BiffRec)bs.getSheetRecs().get(t);
        }
        throw new InvalidRecordException("ERROR: ByteStreamer.getRecord() could not retrieve record from");
    }

    public BiffRec getRecordAt(int t) {
        return (BiffRec)this.records.get(t);
    }

    public boolean removeRecord(BiffRec rec) {
        Boundsheet bs;
        if (rec.getSheet() != null && (bs = rec.getSheet()).getSheetRecs().contains(rec)) {
            return bs.getSheetRecs().remove(rec);
        }
        return this.records.remove(rec);
    }

    public int getRecordIndex(BiffRec rec) {
        if (rec.getSheet() != null) {
            Boundsheet bs = rec.getSheet();
            int ret = bs.getSheetRecs().indexOf(rec);
            if (ret > -1) {
                return ret;
            }
            return this.records.indexOf(rec);
        }
        return this.records.indexOf(rec);
    }

    public int getRealRecordIndex(BiffRec rec) {
        return this.records.indexOf(rec);
    }

    public void addRecord(BiffRec rec) {
        rec.setStreamer(this);
        Boundsheet sht = rec.getSheet();
        if (sht != null) {
            sht.getSheetRecs().add(rec);
        } else {
            this.records.add(rec);
        }
    }

    public void addRecordToBookStreamerAt(BiffRec rec, int idx) {
        try {
            this.records.add(idx, rec);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.records.add(this.records.size(), rec);
        }
    }

    public void addRecordToSheetStreamerAt(BiffRec rec, int idx, Boundsheet sht) {
        rec.setStreamer(this);
        List sr = sht.getSheetRecs();
        sr.add(idx, rec);
    }

    public void addRecordAt(BiffRec rec, int idx) {
        rec.setStreamer(this);
        Boundsheet sht = rec.getSheet();
        if (sht != null) {
            List sr = sht.getSheetRecs();
            sr.add(idx, rec);
        } else {
            try {
                this.records.add(idx, rec);
            }
            catch (Exception e) {
                this.records.add(this.records.size(), rec);
            }
        }
    }

    public int streamOut(OutputStream _out) {
        this.writeOut(_out);
        return this.dlen - 4;
    }

    public void writeRecord(OutputStream out, BiffRec rec) throws IOException {
        byte[] op = ByteTools.shortToLEBytes(rec.getOpcode());
        byte[] dt = rec.getData();
        byte[] ln = ByteTools.shortToLEBytes((short)dt.length);
        out.write(op);
        out.write(ln);
        if (dt.length > 0) {
            out.write(dt);
        }
        rec.postStream();
    }

    public StringBuffer writeOut(OutputStream out) {
        StringBuffer lockdown = new StringBuffer();
        boolean lockit = false;
        if (System.getProperties().get("com.extentech.ExtenXLS.autocreatelockdown") != null) {
            lockit = System.getProperties().get("com.extentech.ExtenXLS.autocreatelockdown").equals("true");
        }
        this.workbook.prestream();
        int recpos = 0;
        int recctr = 0;
        int dlen = 0;
        FastAddVector rex = new FastAddVector(this.records.size());
        ((AbstractCollection)rex).addAll(this.records);
        BiffRec rec2 = null;
        for (BiffRec rec2 : rex) {
            ++recctr;
            if (rec2 != null) {
                if (rec2.getByteReader() != null) {
                    rec2.getByteReader().setApplyRelativePosition(true);
                }
                if (rec2.getOpcode() == 133) {
                    List lst = ((Boundsheet)rec2).assembleSheetRecs();
                    ((AbstractList)rex).addAll(((AbstractCollection)rex).size(), lst);
                    continue;
                }
                if (rec2.getOpcode() == 252) {
                    rec2.preStream();
                    recpos = ((Sst)rec2).getNumContinues() * 4;
                    if (recpos < 0) {
                        recpos = 0;
                    }
                    dlen += recpos;
                    continue;
                }
                rec2.preStream();
                continue;
            }
            Logger.logWarn("Body Rec missing while preStreaming(): " + rec2.toString());
        }
        Iterator e = ((AbstractList)rex).iterator();
        Index lastindex = null;
        int ctr = 0;
        while (e.hasNext()) {
            Continue thiscont;
            rec2 = (BiffRec)e.next();
            if (ctr == 0) {
                rec2.setOffset(0);
                ++ctr;
            } else {
                rec2.setOffset(recpos);
            }
            if (rec2.getOpcode() == 523) {
                if (lastindex != null) {
                    lastindex.updateDbcellPointers();
                }
                lastindex = (Index)rec2;
            }
            if (rec2.getOpcode() == 60 && ((Continue)rec2).maskedMso != null) {
                rec2.setData(((Continue)rec2).maskedMso.getData());
            }
            int rln = rec2.getLength();
            int numcx = rln / 8224;
            if (rln % 8224 <= 4 && numcx > 0) {
                --numcx;
            }
            if (rec2.getOpcode() == 60 && (thiscont = (Continue)rec2).isBigRecContinue()) {
                rln = 0;
            }
            if (rln > 8228 && numcx > 0 && rec2.getOpcode() != 252) {
                dlen += numcx * 4;
                recpos += numcx * 4;
            }
            dlen += rln;
            recpos += rln;
        }
        if (lastindex != null) {
            lastindex.updateDbcellPointers();
        }
        e = ((AbstractList)rex).iterator();
        LEOFile leo = this.workbook.factory.myLEO;
        List storages = null;
        storages = leo.writeBytes(out, dlen);
        BIGBLOCK hdrBlock = new BIGBLOCK();
        hdrBlock.init(leo.getHeader().getBytes(), 0, 0);
        hdrBlock.writeBytes(out);
        while (e.hasNext()) {
            rec2 = (BiffRec)e.next();
            try {
                if (ContinueHandler.createContinues(rec2, out, this)) continue;
                this.writeRecord(out, rec2);
                if (!lockit) continue;
                byte[] op = ByteTools.shortToLEBytes(rec2.getOpcode());
                byte[] dt = rec2.getData();
                byte[] ln = ByteTools.shortToLEBytes((short)dt.length);
                lockdown.append("opc:0x" + Integer.toHexString(rec2.getOpcode()) + " [" + ByteTools.getByteString(op, false) + "]");
                lockdown.append("\r\n");
                lockdown.append("len:0x" + Integer.toHexString(rec2.getLength()) + " [" + ByteTools.getByteString(ln, false) + "]");
                lockdown.append("\r\n");
                lockdown.append(ByteTools.getByteDump(dt, 1));
                lockdown.append("\r\n");
            }
            catch (Exception a) {
                throw new WorkBookException("Streaming WorkBook Bytes failed for record: " + rec2.toString() + ": " + a + " Output Corrupted.", 6, a);
            }
        }
        int nBlocks = Math.max(leo.getMinBlocks(), (int)Math.ceil((double)dlen / 512.0) + 1);
        int leftover = nBlocks * 512 - dlen;
        byte[] filler = new byte[leftover];
        int t = 0;
        while (t < filler.length) {
            filler[t] = 0;
            ++t;
        }
        try {
            out.write(filler);
            for (Storage ob : storages) {
                if (ob == null) continue;
                ob.getName().equals("Root Entry");
                if (ob.getBlockType() == 0) continue;
                ob.writeBytes(out);
            }
        }
        catch (Exception a) {
            Logger.logErr("Streaming WorkBook Storage Bytes failed.", a);
            throw new WorkBookException("ByteStreamer.stream(): Body Rec missing while preStreaming(): " + rec2.toString() + " " + a.toString() + " Output Corrupted.", 6);
        }
        if (lockit) {
            return lockdown;
        }
        return null;
    }

    public void WriteAllRecs(String fName) {
        this.WriteAllRecs(fName, false);
    }

    public void WriteAllRecs(String fName, boolean bWriteSheetRecs) {
        try {
            File f = new File(fName);
            BufferedWriter writer = new BufferedWriter(new FileWriter(f));
            ArrayList<Object> recs = new ArrayList<Object>(Arrays.asList(this.getBiffRecords()));
            int ctr = 0;
            ctr = ByteStreamer.writeRecs(recs, writer, ctr, 0);
            AbstractList sheets = this.workbook.getSheetVect();
            int i = 0;
            while (i < sheets.size()) {
                if (bWriteSheetRecs) {
                    ArrayList lst = (ArrayList)((Boundsheet)sheets.get(i)).assembleSheetRecs();
                    ctr = ByteStreamer.writeRecs(lst, writer, ctr, 0);
                } else {
                    ctr = ByteStreamer.writeRecs((ArrayList)((Boundsheet)sheets.get(i)).getSheetRecs(), writer, ctr, 0);
                }
                ++i;
            }
            writer.flush();
            writer.close();
            writer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int writeRecs(ArrayList recArr, BufferedWriter writer, int ctr, int level) {
        String tabs = "\t\t\t\t\t\t\t\t\t\t";
        int i = 0;
        while (i < recArr.size()) {
            try {
                BiffRec b = (BiffRec)recArr.get(i);
                if (b == null) break;
                writer.write(String.valueOf(tabs.substring(0, level)) + b.getClass().toString().substring(b.getClass().toString().lastIndexOf(46) + 1));
                if (b instanceof SeriesText) {
                    writer.write("\t[" + ((SeriesText)b).toString() + "]");
                } else if (b instanceof Continue) {
                    if (((Continue)b).maskedMso != null) {
                        writer.write("\t[MASKED MSO ******************");
                        writer.write("\t[" + ((Continue)b).maskedMso.toString() + "]");
                        writer.write(((Continue)b).maskedMso.debugOutput());
                        writer.write("\t[" + ByteTools.getByteDump(b.getData(), 0).substring(11) + "]");
                    } else {
                        writer.write("\t[" + ByteTools.getByteDump(b.getData(), 0).substring(11) + "]");
                    }
                } else if (b instanceof MSODrawing) {
                    writer.write("\t[" + ((MSODrawing)b).toString() + "]");
                    writer.write(((MSODrawing)b).debugOutput());
                    writer.write("\t[" + ByteTools.getByteDump(b.getData(), 0).substring(11) + "]");
                } else if (b instanceof Obj) {
                    writer.write(((Obj)b).debugOutput());
                } else if (b instanceof MSODrawingGroup) {
                    writer.write("\t[" + ((MSODrawingGroup)b).toString() + "]");
                } else if (b instanceof Label) {
                    writer.write("\t[" + ((Label)b).getStringVal() + "]");
                } else if (b instanceof Mulblank) {
                    writer.write("\t[" + ((Mulblank)b).getCellAddress() + "]");
                } else if (b instanceof Name) {
                    try {
                        writer.write("\t[" + ((Name)b).getName() + "-" + ((Name)b).getLocation() + "]");
                    }
                    catch (Exception ce) {
                        writer.write("\t[" + ((Name)b).getName() + "-ERROR IN LOCATION]");
                    }
                } else if (b instanceof Sst) {
                    writer.write("\t[" + ((Sst)b).toString() + "]");
                } else if (b instanceof Pls) {
                    writer.write("\t[" + ((Pls)b).toString() + "]");
                } else if (b instanceof Supbook) {
                    writer.write("\t[" + ((Supbook)b).toString() + "]");
                } else if (b instanceof Crn) {
                    writer.write("\t[" + ((Crn)b).toString() + "]");
                } else if (b instanceof Formula || b instanceof Rk || b instanceof NumberRec || b instanceof Blank || b instanceof Labelsst) {
                    writer.write(" " + ((XLSRecord)b).getCellAddressWithSheet() + "\t[" + ByteTools.getByteDump(b.getData(), 0).substring(11) + "]");
                } else {
                    writer.write("\t[" + ByteTools.getByteDump(ByteTools.shortToLEBytes(b.getOpcode()), 0) + "][" + ByteTools.getByteDump(b.getData(), 0).substring(11) + "]");
                }
                writer.newLine();
                if (b instanceof ChartObject) {
                    ByteStreamer.writeRecs(((ChartObject)((Object)b)).getChartRecords(), writer, ctr, level + 1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return ctr;
    }

    public void close() {
        int i = 0;
        while (i < this.records.size()) {
            XLSRecord r2 = (XLSRecord)this.records.get(i);
            r2.close();
            ++i;
        }
        this.records.clear();
        this.workbook = null;
    }
}

