/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.ChartText;
import com.extentech.formats.OOXML.Layout;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.P;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.formats.OOXML.TxPr;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.charts.TextDisp;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class Title
implements OOXMLElement {
    private static final long serialVersionUID = -3889674575558708481L;
    private Layout layout = null;
    private SpPr sp = null;
    private ChartText chartText = null;
    private TxPr txpr = null;

    public Title(ChartText ct, TxPr txpr, Layout l, SpPr sp) {
        this.layout = l;
        this.sp = sp;
        this.chartText = ct;
        this.txpr = txpr;
    }

    public Title(String t) {
        this.chartText = new ChartText(t);
        this.sp = new SpPr("c");
    }

    public Title(TextDisp td, WorkBook bk) {
        P para = new P(td.getFont(bk), td.toString());
        this.chartText = new ChartText(null, para, null);
    }

    public void setLayout(double x, double y) {
        this.layout = new Layout(null, new double[]{x, y, -1.0, -1.0});
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        TxPr txpr = null;
        ChartText ct = null;
        Layout l = null;
        SpPr sp = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block7: {
                    String endTag;
                    block5: {
                        String tnm;
                        block9: {
                            block8: {
                                block6: {
                                    if (eventType != 2) break block5;
                                    tnm = xpp.getName();
                                    if (!tnm.equals("tx")) break block6;
                                    lastTag.push(tnm);
                                    ct = ChartText.parseOOXML(xpp, lastTag, bk);
                                    break block7;
                                }
                                if (!tnm.equals("manualLayout")) break block8;
                                lastTag.push(tnm);
                                l = (Layout)Layout.parseOOXML(xpp, lastTag);
                                break block7;
                            }
                            if (!tnm.equals("spPr")) break block9;
                            lastTag.push(tnm);
                            sp = (SpPr)SpPr.parseOOXML(xpp, lastTag, bk);
                            break block7;
                        }
                        if (!tnm.equals("txPr")) break block7;
                        lastTag.push(tnm);
                        txpr = (TxPr)TxPr.parseOOXML(xpp, lastTag, bk);
                        break block7;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("title")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("title.parseOOXML: " + e.toString());
        }
        Title tt = new Title(ct, txpr, l, sp);
        return tt;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public SpPr getSpPr() {
        return this.sp;
    }

    @Override
    public String getOOXML() {
        StringBuffer tooxml = new StringBuffer();
        tooxml.append("<c:title>");
        if (this.chartText != null) {
            tooxml.append(this.chartText.getOOXML());
        }
        if (this.layout != null) {
            tooxml.append(this.layout.getOOXML());
        }
        if (this.sp != null) {
            tooxml.append(this.sp.getOOXML());
        }
        if (this.txpr != null) {
            tooxml.append(this.txpr.getOOXML());
        }
        tooxml.append("</c:title>");
        return tooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Title(this.chartText, this.txpr, this.layout, this.sp);
    }

    public String getTitle() {
        if (this.chartText != null) {
            return this.chartText.getTitle();
        }
        return "";
    }

    public int getFontId(WorkBookHandle wb) {
        if (this.chartText != null) {
            return this.chartText.getFontId(wb);
        }
        return -1;
    }
}

