/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.ColorChoice;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.SrgbClr;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class SolidFill
implements OOXMLElement {
    private static final long serialVersionUID = 3341509200573989744L;
    private ColorChoice color;

    public SolidFill() {
        this.color = new ColorChoice(null, new SrgbClr("000000", null), null, null, null);
    }

    public SolidFill(ColorChoice c) {
        this.color = c;
    }

    public SolidFill(SolidFill s) {
        this.color = s.color;
    }

    public SolidFill(String clr) {
        if (clr == null) {
            clr = "FFFFFF";
        }
        this.color = new ColorChoice(null, new SrgbClr(clr, null), null, null, null);
    }

    public static SolidFill parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        ColorChoice c = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("hslClr") || tnm.equals("prstClr") || tnm.equals("schemeClr") || tnm.equals("scrgbClr") || tnm.equals("srgbClr") || tnm.equals("sysClr")) {
                        lastTag.push(tnm);
                        c = (ColorChoice)ColorChoice.parseOOXML(xpp, lastTag, bk).cloneElement();
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("solidFill")) {
                    lastTag.pop();
                    break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("solidFill.parseOOXML: " + e.toString());
        }
        SolidFill s = new SolidFill(c);
        return s;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:solidFill>");
        if (this.color != null) {
            ooxml.append(this.color.getOOXML());
        }
        ooxml.append("</a:solidFill>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new SolidFill(this);
    }

    public void setColor(String clr) {
        this.color = new ColorChoice(null, new SrgbClr(clr, null), null, null, null);
    }

    public int getColor() {
        return this.color.getColor();
    }
}

