/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.OutlinePr;
import com.extentech.formats.OOXML.PageSetupPr;
import com.extentech.formats.OOXML.TabColor;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;

public class SheetPr
implements OOXMLElement {
    private static final long serialVersionUID = 1781567781060400234L;
    private HashMap<String, String> attrs;
    private TabColor tab;
    private OutlinePr outlinePr;
    private PageSetupPr pageSetupPr;

    public SheetPr(HashMap<String, String> attrs, TabColor tab, OutlinePr op, PageSetupPr pr) {
        this.attrs = attrs;
        this.tab = tab;
        this.outlinePr = op;
        this.pageSetupPr = pr;
    }

    public SheetPr(SheetPr sp) {
        this.attrs = sp.attrs;
        this.tab = sp.tab;
        this.outlinePr = sp.outlinePr;
        this.pageSetupPr = sp.pageSetupPr;
    }

    public static SheetPr parseOOXML(XmlPullParser xpp) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        TabColor tab = null;
        OutlinePr op = null;
        PageSetupPr pr = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("sheetPr")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                            ++i;
                        }
                    } else if (tnm.equals("pageSetUpPr")) {
                        pr = PageSetupPr.parseOOXML(xpp);
                    } else if (tnm.equals("outlinePr")) {
                        op = OutlinePr.parseOOXML(xpp);
                    } else if (tnm.equals("tabColor")) {
                        tab = TabColor.parseOOXML(xpp);
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("sheetPr")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("sheetPr.parseOOXML: " + e.toString());
        }
        SheetPr sp = new SheetPr(attrs, tab, op, pr);
        return sp;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<sheetPr");
        for (String key : this.attrs.keySet()) {
            String val = this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append(">");
        if (this.tab != null) {
            ooxml.append(this.tab.getOOXML());
        }
        if (this.outlinePr != null) {
            ooxml.append(this.outlinePr.getOOXML());
        }
        if (this.pageSetupPr != null) {
            ooxml.append(this.pageSetupPr.getOOXML());
        }
        ooxml.append("</sheetPr>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new SheetPr(this);
    }

    public String getCodename() {
        if (this.attrs != null) {
            return this.attrs.get("codeName");
        }
        return null;
    }

    public void setCodename(String codename) {
        if (this.attrs == null) {
            this.attrs = new HashMap();
        }
        this.attrs.put("codeName", codename);
    }
}

