/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class Rect
implements OOXMLElement {
    private static final long serialVersionUID = 2790708601254975676L;
    private HashMap<String, String> attrs;

    public Rect(HashMap<String, String> attrs) {
        this.attrs = attrs;
    }

    public Rect(Rect r2) {
        this.attrs = r2.attrs;
    }

    public static Rect parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block8: {
                    String endTag;
                    block6: {
                        String tnm;
                        block7: {
                            if (eventType != 2) break block6;
                            tnm = xpp.getName();
                            if (!tnm.equals("rect")) break block7;
                            int i = 0;
                            while (i < xpp.getAttributeCount()) {
                                attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                                ++i;
                            }
                            break block8;
                        }
                        if (!tnm.equals("CHILDELEMENT")) break block8;
                        lastTag.push(tnm);
                        break block8;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("rect")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("rect.parseOOXML: " + e.toString());
        }
        Rect r2 = new Rect(attrs);
        return r2;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:rect");
        for (String key : this.attrs.keySet()) {
            String val = this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append("/>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Rect(this);
    }
}

