/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class Path
implements OOXMLElement {
    private static final long serialVersionUID = 6906237439620322589L;
    private HashMap<String, String> attrs = null;

    public Path(HashMap<String, String> attrs) {
        this.attrs = attrs;
    }

    public Path(Path p) {
        this.attrs = p.attrs;
    }

    public static Path parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block8: {
                    String endTag;
                    block6: {
                        String tnm;
                        block7: {
                            if (eventType != 2) break block6;
                            tnm = xpp.getName();
                            if (!tnm.equals("path")) break block7;
                            int i = 0;
                            while (i < xpp.getAttributeCount()) {
                                attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                                ++i;
                            }
                            break block8;
                        }
                        if (tnm.equals("moveTo") || tnm.equals("lnTo")) break block8;
                        tnm.equals("close");
                        break block8;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("path")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("path.parseOOXML: " + e.toString());
        }
        Path p = new Path(attrs);
        return p;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:path");
        for (String key : this.attrs.keySet()) {
            String val = this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append("/>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Path(this);
    }
}

