/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.CxnSp;
import com.extentech.formats.OOXML.Ext;
import com.extentech.formats.OOXML.From;
import com.extentech.formats.OOXML.GraphicFrame;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.ObjectChoice;
import com.extentech.formats.OOXML.Pic;
import com.extentech.formats.OOXML.Sp;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class OneCellAnchor
implements OOXMLElement {
    private static final long serialVersionUID = -8498556079325357165L;
    public static final short EMU = 1270;
    private From from;
    private Ext ext;
    private ObjectChoice objectChoice;

    public OneCellAnchor(From f, Ext e, ObjectChoice o) {
        this.from = f;
        this.ext = e;
        this.objectChoice = o;
    }

    public OneCellAnchor(OneCellAnchor oca) {
        this.from = oca.from;
        this.ext = oca.ext;
        this.objectChoice = oca.objectChoice;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        From f = null;
        Ext e = null;
        ObjectChoice o = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block7: {
                    String endTag;
                    block5: {
                        String tnm;
                        block8: {
                            block6: {
                                if (eventType != 2) break block5;
                                tnm = xpp.getName();
                                if (!tnm.equals("from")) break block6;
                                lastTag.push(tnm);
                                f = From.parseOOXML(xpp, lastTag);
                                break block7;
                            }
                            if (!tnm.equals("ext")) break block8;
                            lastTag.push(tnm);
                            e = (Ext)Ext.parseOOXML(xpp, lastTag).cloneElement();
                            break block7;
                        }
                        if (!tnm.equals("cxnSp") && !tnm.equals("graphicFrame") && !tnm.equals("grpSp") && !tnm.equals("pic") && !tnm.equals("sp")) break block7;
                        lastTag.push(tnm);
                        o = (ObjectChoice)ObjectChoice.parseOOXML(xpp, lastTag, bk);
                        break block7;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("oneCellAnchor")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception ex) {
            Logger.logErr("oneCellAnchor.parseOOXML: " + ex.toString());
        }
        OneCellAnchor oca = new OneCellAnchor(f, e, o);
        return oca;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<xdr:oneCellAnchor>");
        if (this.from != null) {
            ooxml.append(this.from.getOOXML());
        }
        ooxml.append(this.ext.getOOXML());
        ooxml.append(this.objectChoice.getOOXML());
        ooxml.append("<xdr:clientData/>");
        ooxml.append("</xdr:oneCellAnchor>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new OneCellAnchor(this);
    }

    public short[] getBounds() {
        short[] bounds = new short[8];
        System.arraycopy(this.from.getBounds(), 0, bounds, 0, 4);
        return bounds;
    }

    public void setBounds(int[] bounds) {
        int[] b = new int[4];
        System.arraycopy(bounds, 0, b, 0, 4);
        if (this.from == null) {
            this.from = new From(b);
        } else {
            this.from.setBounds(b);
        }
    }

    public String getName() {
        if (this.objectChoice != null) {
            return this.objectChoice.getName();
        }
        return null;
    }

    public void setName(String name) {
        if (this.objectChoice != null) {
            this.objectChoice.setName(name);
        }
    }

    public String getDescr() {
        if (this.objectChoice != null) {
            return this.objectChoice.getDescr();
        }
        return null;
    }

    public void setDescr(String descr) {
        if (this.objectChoice != null) {
            this.objectChoice.setDescr(descr);
        }
    }

    public String getMacro() {
        if (this.objectChoice != null) {
            return this.objectChoice.getMacro();
        }
        return null;
    }

    public void setMacro(String macro) {
        if (this.objectChoice != null) {
            this.objectChoice.setMacro(macro);
        }
    }

    public String getURI() {
        if (this.objectChoice != null) {
            return this.objectChoice.getURI();
        }
        return null;
    }

    public void setURI(String uri) {
        if (this.objectChoice != null) {
            this.objectChoice.setURI(uri);
        }
    }

    public String getEmbed() {
        if (this.objectChoice != null) {
            return this.objectChoice.getEmbed();
        }
        return null;
    }

    public String getLink() {
        if (this.objectChoice != null) {
            return this.objectChoice.getLink();
        }
        return null;
    }

    public void setEmbed(String embed) {
        if (this.objectChoice != null) {
            this.objectChoice.setEmbed(embed);
        }
    }

    public void setLink(String link) {
        if (this.objectChoice != null) {
            this.objectChoice.setLink(link);
        }
    }

    public boolean hasImage() {
        if (this.objectChoice != null) {
            return this.objectChoice.getObject() instanceof Pic && this.objectChoice.getEmbed() != null;
        }
        return false;
    }

    public SpPr getSppr() {
        if (this.objectChoice != null) {
            return this.objectChoice.getSppr();
        }
        return null;
    }

    public boolean hasChart() {
        if (this.objectChoice != null) {
            return this.objectChoice.getObject() instanceof GraphicFrame && this.objectChoice.getChartRId() != null;
        }
        return false;
    }

    public boolean hasShape() {
        if (this.objectChoice != null) {
            return this.objectChoice.getObject() instanceof CxnSp || this.objectChoice.getObject() instanceof Sp;
        }
        return false;
    }

    public void setAsChart(int rid, String name, int[] bounds) {
        this.objectChoice = new ObjectChoice();
        this.objectChoice.setObject(new GraphicFrame());
        this.objectChoice.setName(name);
        this.objectChoice.setEmbed("rId" + Integer.valueOf(rid).toString());
        this.objectChoice.setId(rid);
        this.setBounds(bounds);
    }

    public void setAsImage(String rid, String name, String id) {
        ObjectChoice o = new ObjectChoice();
        o.setObject(new Pic());
        o.setName(name);
        o.setEmbed(rid);
    }
}

