/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.CxnSp;
import com.extentech.formats.OOXML.GraphicFrame;
import com.extentech.formats.OOXML.GrpSp;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.Pic;
import com.extentech.formats.OOXML.Sp;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class ObjectChoice
implements OOXMLElement {
    private static final long serialVersionUID = 3548474869557092714L;
    private CxnSp cxnSp = null;
    private GraphicFrame graphicFrame = null;
    private GrpSp grpSp = null;
    private Pic pic = null;
    private Sp sp = null;

    public ObjectChoice() {
    }

    public ObjectChoice(CxnSp c, GraphicFrame g, GrpSp grp, Pic p, Sp s) {
        this.cxnSp = c;
        this.graphicFrame = g;
        this.grpSp = grp;
        this.pic = p;
        this.sp = s;
    }

    public ObjectChoice(ObjectChoice oc) {
        this.cxnSp = oc.cxnSp;
        this.graphicFrame = oc.graphicFrame;
        this.grpSp = oc.grpSp;
        this.pic = oc.pic;
        this.sp = oc.sp;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        CxnSp c = null;
        GraphicFrame g = null;
        GrpSp grp = null;
        Pic p = null;
        Sp s = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("cxnSp")) {
                        lastTag.push(tnm);
                        c = (CxnSp)CxnSp.parseOOXML(xpp, lastTag, bk);
                        break;
                    }
                    if (tnm.equals("graphicFrame")) {
                        lastTag.push(tnm);
                        g = (GraphicFrame)GraphicFrame.parseOOXML(xpp, lastTag);
                        break;
                    }
                    if (tnm.equals("grpSp")) {
                        lastTag.push(tnm);
                        grp = GrpSp.parseOOXML(xpp, lastTag, bk);
                        break;
                    }
                    if (tnm.equals("sp")) {
                        lastTag.push(tnm);
                        s = (Sp)Sp.parseOOXML(xpp, lastTag, bk);
                        break;
                    }
                    if (tnm.equals("pic")) {
                        lastTag.push(tnm);
                        p = (Pic)Pic.parseOOXML(xpp, lastTag, bk);
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("ObjectChoice.parseOOXML: " + e.toString());
        }
        ObjectChoice o = new ObjectChoice(c, g, grp, p, s);
        return o;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        if (this.cxnSp != null) {
            ooxml.append(this.cxnSp.getOOXML());
        }
        if (this.graphicFrame != null) {
            ooxml.append(this.graphicFrame.getOOXML());
        }
        if (this.grpSp != null) {
            ooxml.append(this.grpSp.getOOXML());
        }
        if (this.pic != null) {
            ooxml.append(this.pic.getOOXML());
        }
        if (this.sp != null) {
            ooxml.append(this.sp.getOOXML());
        }
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new ObjectChoice(this);
    }

    public boolean hasImage() {
        return this.getEmbed() != null;
    }

    public boolean hasShape() {
        return this.cxnSp != null || this.sp != null || this.grpSp != null && this.grpSp.hasShape();
    }

    public boolean hasChart() {
        return this.getChartRId() != null;
    }

    public String getName() {
        if (this.cxnSp != null) {
            return this.cxnSp.getName();
        }
        if (this.sp != null) {
            return this.sp.getName();
        }
        if (this.pic != null) {
            return this.pic.getName();
        }
        if (this.graphicFrame != null) {
            return this.graphicFrame.getName();
        }
        if (this.grpSp != null) {
            return this.grpSp.getName();
        }
        return null;
    }

    public void setName(String name) {
        if (this.cxnSp != null) {
            this.cxnSp.setName(name);
        } else if (this.sp != null) {
            this.sp.setName(name);
        } else if (this.pic != null) {
            this.pic.setName(name);
        } else if (this.graphicFrame != null) {
            this.graphicFrame.setName(name);
        } else if (this.grpSp != null) {
            this.grpSp.setName(name);
        }
    }

    public String getDescr() {
        if (this.cxnSp != null) {
            return this.cxnSp.getDescr();
        }
        if (this.sp != null) {
            return this.sp.getDescr();
        }
        if (this.pic != null) {
            return this.pic.getDescr();
        }
        if (this.graphicFrame != null) {
            return this.graphicFrame.getDescr();
        }
        if (this.grpSp != null) {
            return this.grpSp.getDescr();
        }
        return null;
    }

    public void setDescr(String descr) {
        if (this.cxnSp != null) {
            this.cxnSp.setDescr(descr);
        } else if (this.sp != null) {
            this.sp.setDescr(descr);
        } else if (this.pic != null) {
            this.pic.setDescr(descr);
        } else if (this.graphicFrame != null) {
            this.graphicFrame.setDescr(descr);
        } else if (this.grpSp != null) {
            this.grpSp.setDescr(descr);
        }
    }

    public String getMacro() {
        if (this.cxnSp != null) {
            return this.cxnSp.getMacro();
        }
        if (this.graphicFrame != null) {
            return this.graphicFrame.getMacro();
        }
        if (this.sp != null) {
            return this.sp.getMacro();
        }
        return null;
    }

    public void setMacro(String macro) {
        if (this.cxnSp != null) {
            this.cxnSp.setMacro(macro);
        } else if (this.graphicFrame != null) {
            this.graphicFrame.setMacro(macro);
        } else if (this.sp != null) {
            this.sp.setMacro(macro);
        } else if (this.grpSp != null) {
            this.grpSp.setMacro(macro);
        }
    }

    public String getURI() {
        if (this.graphicFrame != null) {
            return this.graphicFrame.getURI();
        }
        return null;
    }

    public void setURI(String uri) {
        if (this.graphicFrame != null) {
            this.graphicFrame.setURI(uri);
        } else if (this.grpSp != null) {
            this.grpSp.setURI(uri);
        }
    }

    public String getEmbed() {
        if (this.sp != null) {
            return this.sp.getEmbed();
        }
        if (this.pic != null) {
            return this.pic.getEmbed();
        }
        if (this.grpSp != null) {
            return this.grpSp.getEmbed();
        }
        return null;
    }

    public String getLink() {
        if (this.sp != null) {
            return this.sp.getLink();
        }
        if (this.pic != null) {
            return this.pic.getLink();
        }
        if (this.grpSp != null) {
            return this.grpSp.getLink();
        }
        return null;
    }

    public void setEmbed(String embed) {
        if (this.sp != null) {
            this.sp.setEmbed(embed);
        } else if (this.pic != null) {
            this.pic.setEmbed(embed);
        } else if (this.grpSp != null) {
            this.grpSp.setEmbed(embed);
        }
    }

    public void setChartRId(String rId) {
        if (this.graphicFrame != null) {
            this.graphicFrame.setChartRId(rId);
        }
    }

    public void setLink(String link) {
        if (this.sp != null) {
            this.sp.setLink(link);
        } else if (this.pic != null) {
            this.pic.setLink(link);
        } else if (this.grpSp != null) {
            this.grpSp.setLink(link);
        }
    }

    public String getChartRId() {
        if (this.graphicFrame != null) {
            return this.graphicFrame.getChartRId();
        }
        if (this.grpSp != null) {
            return this.grpSp.getChartRId();
        }
        return null;
    }

    public void setId(int id) {
        if (this.sp != null) {
            this.sp.setId(id);
        } else if (this.pic != null) {
            this.pic.setId(id);
        } else if (this.graphicFrame != null) {
            this.graphicFrame.setId(id);
        } else if (this.cxnSp != null) {
            this.cxnSp.setId(id);
        } else if (this.grpSp != null) {
            this.grpSp.setId(id);
        }
    }

    public int getId() {
        if (this.sp != null) {
            return this.sp.getId();
        }
        if (this.pic != null) {
            return this.pic.getId();
        }
        if (this.graphicFrame != null) {
            return this.graphicFrame.getId();
        }
        if (this.cxnSp != null) {
            return this.cxnSp.getId();
        }
        if (this.grpSp != null) {
            return this.grpSp.getId();
        }
        return -1;
    }

    public SpPr getSppr() {
        if (this.pic != null) {
            return this.pic.getSppr();
        }
        if (this.grpSp != null) {
            return this.grpSp.getSppr();
        }
        return null;
    }

    public Object getObject() {
        if (this.cxnSp != null) {
            return this.cxnSp;
        }
        if (this.graphicFrame != null) {
            return this.graphicFrame;
        }
        if (this.pic != null) {
            return this.pic;
        }
        if (this.sp != null) {
            return this.sp;
        }
        if (this.grpSp != null) {
            return this.grpSp;
        }
        return null;
    }

    public void setObject(Object o) {
        if (o instanceof GraphicFrame) {
            this.graphicFrame = (GraphicFrame)o;
        } else if (o instanceof Pic) {
            this.pic = (Pic)o;
        } else if (o instanceof Sp) {
            this.sp = (Sp)o;
        } else if (o instanceof CxnSp) {
            this.cxnSp = (CxnSp)o;
        } else if (o instanceof GrpSp) {
            this.grpSp = (GrpSp)o;
        }
    }
}

