/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class JoinGroup
implements OOXMLElement {
    private static final long serialVersionUID = -6107424300366896696L;
    private boolean miter;
    private boolean round;
    private boolean bevel;
    private String miterVal;

    public JoinGroup(String a, boolean m, boolean r2, boolean b) {
        this.miterVal = a;
        this.miter = m;
        this.round = r2;
        this.bevel = b;
    }

    public JoinGroup(JoinGroup j) {
        this.miterVal = j.miterVal;
        this.miter = j.miter;
        this.round = j.round;
        this.bevel = j.bevel;
    }

    public static JoinGroup parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        boolean miter = false;
        boolean round = false;
        boolean bevel = false;
        String a = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block7: {
                    String endTag;
                    block5: {
                        String tnm;
                        block8: {
                            block6: {
                                if (eventType != 2) break block5;
                                tnm = xpp.getName();
                                if (!tnm.equals("bevel")) break block6;
                                bevel = true;
                                break block7;
                            }
                            if (!tnm.equals("round")) break block8;
                            round = true;
                            break block7;
                        }
                        if (!tnm.equals("miter")) break block7;
                        miter = true;
                        a = xpp.getAttributeValue(0);
                        break block7;
                    }
                    if (eventType == 3 && ((endTag = xpp.getName()).equals("bevel") || endTag.equals("round") || endTag.equals("miter"))) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("JoinGroup.parseOOXML: " + e.toString());
        }
        JoinGroup jg = new JoinGroup(a, miter, round, bevel);
        return jg;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        if (this.miter) {
            ooxml.append("<a:miter lim=\"" + this.miterVal + "\"/>");
        } else if (this.round) {
            ooxml.append("<a:round/>");
        } else if (this.bevel) {
            ooxml.append("<a:bevel/>");
        }
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new JoinGroup(this);
    }
}

