/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class HeadEnd
implements OOXMLElement {
    private static final long serialVersionUID = -6744308104003922477L;
    private String len = null;
    private String type = null;
    private String w = null;

    public HeadEnd() {
    }

    public HeadEnd(String len, String type, String w) {
        this.len = len;
        this.type = type;
        this.w = w;
    }

    public HeadEnd(HeadEnd te) {
        this.len = te.len;
        this.type = te.type;
        this.w = te.w;
    }

    public static HeadEnd parseOOXML(XmlPullParser xpp, Stack<String> lastTag) {
        String len = null;
        String type = null;
        String w = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("headEnd")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            String n = xpp.getAttributeName(i);
                            if (n.equals("len")) {
                                len = xpp.getAttributeValue(i);
                            } else if (n.equals("type")) {
                                type = xpp.getAttributeValue(i);
                            } else if (n.equals("w")) {
                                w = xpp.getAttributeValue(i);
                            }
                            ++i;
                        }
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("headEnd")) {
                    lastTag.pop();
                    break;
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("headEnd.parseOOXML: " + e.toString());
        }
        HeadEnd te = new HeadEnd(len, type, w);
        return te;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:headEnd");
        if (this.len != null) {
            ooxml.append(" len=\"" + this.len + "\"");
        }
        if (this.type != null) {
            ooxml.append(" type=\"" + this.type + "\"");
        }
        if (this.w != null) {
            ooxml.append(" w=\"" + this.w + "\"");
        }
        ooxml.append("/>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new HeadEnd(this);
    }
}

