/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.CxnSp;
import com.extentech.formats.OOXML.GraphicFrame;
import com.extentech.formats.OOXML.GrpSpPr;
import com.extentech.formats.OOXML.NvGrpSpPr;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.Pic;
import com.extentech.formats.OOXML.Sp;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class GrpSp
implements OOXMLElement {
    private static final long serialVersionUID = -3276180769601314853L;
    private NvGrpSpPr nvpr = null;
    private GrpSpPr sppr = null;
    private ArrayList<OOXMLElement> choice = null;
    static int SP = 0;
    static int PIC = 1;
    static int CXN = 2;
    static int GRAPHICFRAME = 3;

    public GrpSp(NvGrpSpPr nvpr, GrpSpPr sppr, ArrayList<OOXMLElement> choice) {
        this.nvpr = nvpr;
        this.sppr = sppr;
        this.choice = choice;
    }

    public GrpSp(GrpSp g) {
        this.nvpr = g.nvpr;
        this.sppr = g.sppr;
        this.choice = g.choice;
    }

    public static GrpSp parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        NvGrpSpPr nvpr = null;
        GrpSpPr sppr = null;
        ArrayList<OOXMLElement> choice = new ArrayList<OOXMLElement>();
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block8: {
                    String endTag;
                    block6: {
                        String tnm;
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block7: {
                                                if (eventType != 2) break block6;
                                                tnm = xpp.getName();
                                                if (!tnm.equals("nvGrpSpPr")) break block7;
                                                lastTag.push(tnm);
                                                nvpr = NvGrpSpPr.parseOOXML(xpp, lastTag);
                                                break block8;
                                            }
                                            if (!tnm.equals("grpSpPr")) break block9;
                                            lastTag.push(tnm);
                                            sppr = GrpSpPr.parseOOXML(xpp, lastTag, bk);
                                            break block8;
                                        }
                                        if (!tnm.equals("sp")) break block10;
                                        lastTag.push(tnm);
                                        choice.add((Sp)Sp.parseOOXML(xpp, lastTag, bk));
                                        break block8;
                                    }
                                    if (!tnm.equals("grpSp")) break block11;
                                    if (nvpr != null) {
                                        lastTag.push(tnm);
                                        choice.add(GrpSp.parseOOXML(xpp, lastTag, bk));
                                    }
                                    break block8;
                                }
                                if (!tnm.equals("graphicFrame")) break block12;
                                lastTag.push(tnm);
                                choice.add((GraphicFrame)GraphicFrame.parseOOXML(xpp, lastTag));
                                break block8;
                            }
                            if (!tnm.equals("cxnSp")) break block13;
                            lastTag.push(tnm);
                            choice.add((CxnSp)CxnSp.parseOOXML(xpp, lastTag, bk));
                            break block8;
                        }
                        if (!tnm.equals("pic")) break block8;
                        lastTag.push(tnm);
                        choice.add((Pic)Pic.parseOOXML(xpp, lastTag, bk));
                        break block8;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("grpSp")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("GrpSp.parseOOXML: " + e.toString());
        }
        GrpSp gf = new GrpSp(nvpr, sppr, choice);
        return gf;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<xdr:grpSp>");
        ooxml.append(this.nvpr.getOOXML());
        ooxml.append(this.sppr.getOOXML());
        if (this.choice != null) {
            int i = 0;
            while (i < this.choice.size()) {
                ooxml.append(this.choice.get(i).getOOXML());
                ++i;
            }
        }
        ooxml.append("</xdr:grpSp>");
        return ooxml.toString();
    }

    private OOXMLElement getObject(int type) {
        if (this.choice != null) {
            int i = 0;
            while (i < this.choice.size()) {
                OOXMLElement oe = this.choice.get(i);
                if (oe instanceof Sp && type == SP) {
                    return oe;
                }
                if (oe instanceof Pic && type == PIC) {
                    return oe;
                }
                if (oe instanceof CxnSp && type == CXN) {
                    return oe;
                }
                if (oe instanceof GraphicFrame && type == GRAPHICFRAME) {
                    return oe;
                }
                if (oe instanceof GrpSp) {
                    return ((GrpSp)oe).getObject(type);
                }
                ++i;
            }
        }
        return null;
    }

    public String getName() {
        return this.nvpr.getName();
    }

    public void setName(String name) {
        this.nvpr.setName(name);
    }

    public String getMacro() {
        String macro = null;
        OOXMLElement oe = this.getObject(SP);
        if (oe != null) {
            macro = ((Sp)oe).getMacro();
        }
        if (macro == null) {
            oe = this.getObject(PIC);
        }
        if (oe != null && macro == null) {
            macro = ((Pic)oe).getMacro();
        }
        if (macro == null) {
            oe = this.getObject(CXN);
        }
        if (oe != null && macro == null) {
            macro = ((CxnSp)oe).getMacro();
        }
        return macro;
    }

    public void setMacro(String macro) {
        String m = null;
        OOXMLElement oe = this.getObject(SP);
        if (oe != null) {
            m = ((Sp)oe).getMacro();
        }
        if (m != null) {
            ((Sp)oe).setMacro(macro);
            return;
        }
        oe = this.getObject(PIC);
        if (oe != null) {
            m = ((Pic)oe).getMacro();
        }
        if (m != null) {
            ((Pic)oe).setMacro(macro);
            return;
        }
        oe = this.getObject(CXN);
        if (oe != null) {
            m = ((CxnSp)oe).getMacro();
        }
        if (m != null) {
            ((CxnSp)oe).setMacro(macro);
        }
    }

    public String getDescr() {
        return this.nvpr.getDescr();
    }

    public void setDescr(String descr) {
        this.nvpr.setDescr(descr);
    }

    public String getEmbed() {
        String embed = null;
        OOXMLElement oe = this.getObject(SP);
        if (oe != null) {
            embed = ((Sp)oe).getEmbed();
        }
        if (embed == null) {
            oe = this.getObject(PIC);
        }
        if (oe != null && embed == null) {
            embed = ((Pic)oe).getEmbed();
        }
        if (embed == null) {
            oe = this.getObject(CXN);
        }
        if (oe != null && embed == null) {
            embed = ((CxnSp)oe).getEmbed();
        }
        return embed;
    }

    public void setEmbed(String embed) {
        String e = null;
        OOXMLElement oe = this.getObject(SP);
        if (oe != null) {
            e = ((Sp)oe).getEmbed();
        }
        if (e != null) {
            ((Sp)oe).setEmbed(embed);
            return;
        }
        oe = this.getObject(PIC);
        if (oe != null) {
            e = ((Pic)oe).getEmbed();
        }
        if (e != null) {
            ((Pic)oe).setEmbed(embed);
            return;
        }
        oe = this.getObject(CXN);
        if (oe != null) {
            e = ((CxnSp)oe).getEmbed();
        }
        if (e != null) {
            ((CxnSp)oe).setEmbed(embed);
        }
    }

    public String getLink() {
        String link = null;
        OOXMLElement oe = this.getObject(SP);
        if (oe != null) {
            link = ((Sp)oe).getLink();
        }
        if (link == null) {
            oe = this.getObject(PIC);
        }
        if (oe != null && link == null) {
            link = ((Pic)oe).getLink();
        }
        if (link == null) {
            oe = this.getObject(CXN);
        }
        if (oe != null && link == null) {
            link = ((CxnSp)oe).getLink();
        }
        return link;
    }

    public void setLink(String link) {
        String l = null;
        OOXMLElement oe = this.getObject(SP);
        if (oe != null) {
            l = ((Sp)oe).getLink();
        }
        if (l != null) {
            ((Sp)oe).setLink(link);
            return;
        }
        oe = this.getObject(PIC);
        if (oe != null) {
            l = ((Pic)oe).getLink();
        }
        if (l != null) {
            ((Pic)oe).setLink(link);
            return;
        }
        oe = this.getObject(CXN);
        if (oe != null) {
            l = ((CxnSp)oe).getLink();
        }
        if (l != null) {
            ((CxnSp)oe).setLink(link);
        }
    }

    public String getChartRId() {
        OOXMLElement oe = this.getObject(GRAPHICFRAME);
        if (oe != null) {
            return ((GraphicFrame)oe).getChartRId();
        }
        return null;
    }

    public void setURI(String uri) {
        OOXMLElement oe = this.getObject(GRAPHICFRAME);
        ((GraphicFrame)oe).setURI(uri);
    }

    public SpPr getSppr() {
        OOXMLElement oe = this.getObject(PIC);
        if (oe != null) {
            return ((Pic)oe).getSppr();
        }
        return null;
    }

    public boolean hasShape() {
        return this.getObject(SP) != null || this.getObject(CXN) != null;
    }

    public int getId() {
        if (this.choice != null) {
            OOXMLElement oe = this.choice.get(0);
            if (oe instanceof Sp) {
                return ((Sp)oe).getId();
            }
            if (oe instanceof Pic) {
                return ((Pic)oe).getId();
            }
            if (oe instanceof GraphicFrame) {
                return ((GraphicFrame)oe).getId();
            }
            if (oe instanceof CxnSp) {
                return ((CxnSp)oe).getId();
            }
            if (oe instanceof GrpSp) {
                return ((GrpSp)oe).getId();
            }
        }
        return -1;
    }

    public void setId(int id) {
        if (this.choice != null) {
            OOXMLElement oe = this.choice.get(0);
            if (oe instanceof Sp) {
                ((Sp)oe).setId(id);
            } else if (oe instanceof Pic) {
                ((Pic)oe).setId(id);
            } else if (oe instanceof GraphicFrame) {
                ((GraphicFrame)oe).setId(id);
            } else if (oe instanceof CxnSp) {
                ((CxnSp)oe).setId(id);
            } else if (oe instanceof GrpSp) {
                ((GrpSp)oe).setId(id);
            }
        }
    }

    @Override
    public OOXMLElement cloneElement() {
        return new GrpSp(this);
    }
}

