/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.PPr;
import com.extentech.formats.OOXML.RPr;
import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

class Fld
implements OOXMLElement {
    private static final long serialVersionUID = -7060602732912595402L;
    private String t;
    private RPr rp;
    private PPr p;
    String id;
    String type;

    public Fld(String id, String type, String title, RPr rp, PPr p) {
        this.id = id;
        this.type = type;
        this.rp = rp;
        this.t = title;
        this.p = p;
    }

    public Fld(Fld f) {
        this.id = f.id;
        this.type = f.type;
        this.rp = f.rp;
        this.t = f.t;
        this.p = f.p;
    }

    @Override
    public String getOOXML() {
        if (this.t == null || this.t.equals("")) {
            return "";
        }
        this.t = OOXMLAdapter.stripNonAscii(this.t).toString();
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:fld");
        ooxml.append(" id=\"" + this.id + "\"");
        if (this.type != null) {
            ooxml.append(" type=\"" + this.type + "\"");
        }
        ooxml.append(">");
        if (this.rp != null) {
            ooxml.append(this.rp.getOOXML());
        }
        if (this.p != null) {
            ooxml.append(this.p.getOOXML());
        }
        ooxml.append("<a:t>" + this.t + "</a:t>");
        ooxml.append("</a:fld>");
        return ooxml.toString();
    }

    public static Fld parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        String t = "";
        String id = "";
        String type = "";
        PPr p = null;
        RPr rp = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block11: {
                    String endTag;
                    block9: {
                        String tnm;
                        block13: {
                            block12: {
                                block10: {
                                    if (eventType != 2) break block9;
                                    tnm = xpp.getName();
                                    if (!tnm.equals("fld")) break block10;
                                    int i = 0;
                                    while (i < xpp.getAttributeCount()) {
                                        String n = xpp.getAttributeName(i);
                                        if (n.equals("id")) {
                                            id = xpp.getAttributeValue(i);
                                        } else if (n.equals("type")) {
                                            type = xpp.getAttributeValue(i);
                                        }
                                        ++i;
                                    }
                                    break block11;
                                }
                                if (!tnm.equals("t")) break block12;
                                t = OOXMLAdapter.getNextText(xpp);
                                break block11;
                            }
                            if (!tnm.equals("rPr")) break block13;
                            lastTag.push(tnm);
                            rp = RPr.parseOOXML(xpp, lastTag, bk);
                            break block11;
                        }
                        if (!tnm.equals("pPr")) break block11;
                        lastTag.push(tnm);
                        p = PPr.parseOOXML(xpp, lastTag, bk);
                        break block11;
                    }
                    if (eventType == 3 && (endTag = xpp.getName()).equals("fld")) {
                        lastTag.pop();
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("textRun.parseOOXML: " + e.toString());
        }
        Fld f = new Fld(id, type, t, rp, p);
        return f;
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Fld(this);
    }

    public String getTitle() {
        return this.t;
    }
}

