/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;

class Filters
implements OOXMLElement {
    private static final long serialVersionUID = 921424089049938924L;
    private HashMap<String, String> attrs = null;

    public Filters(HashMap<String, String> attrs) {
        this.attrs = attrs;
    }

    public Filters(Filters f) {
        this.attrs = f.attrs;
    }

    public static Filters parseOOXML(XmlPullParser xpp) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("filters")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                            ++i;
                        }
                    } else if (!tnm.equals("filter")) {
                        tnm.equals("dateGroupItem");
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("filters")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("filters.parseOOXML: " + e.toString());
        }
        Filters oe = new Filters(attrs);
        return oe;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<filters");
        for (String key : this.attrs.keySet()) {
            String val = this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append(">");
        ooxml.append("</filters>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Filters(this);
    }
}

