/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.formats.OOXML.Color;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.Theme;
import com.extentech.toolkit.Logger;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;

class FgColor
implements OOXMLElement {
    private static final long serialVersionUID = -1274598491373019241L;
    private HashMap<String, String> attrs = null;

    protected FgColor(HashMap<String, String> attrs) {
        this.attrs = attrs;
    }

    protected FgColor(FgColor f) {
        this.attrs = (HashMap)f.attrs.clone();
    }

    protected FgColor(int c) {
        this.attrs = new HashMap();
        this.attrs.put("indexed", String.valueOf(c));
    }

    protected HashMap<String, String> getAttrs() {
        return this.attrs;
    }

    protected static FgColor parseOOXML(XmlPullParser xpp) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("fgColor")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                            ++i;
                        }
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("fgColor")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("fgColor.parseOOXML: " + e.toString());
        }
        FgColor f = new FgColor(attrs);
        return f;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<fgColor");
        for (String key : this.attrs.keySet()) {
            String val = this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append("/>");
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new FgColor(this);
    }

    protected String getColorAsRGB(Theme t) {
        String val = this.attrs.get("rgb");
        if (val != null) {
            return val;
        }
        val = this.attrs.get("indexed");
        if (val != null) {
            if (Integer.parseInt(val) == 64) {
                return null;
            }
            return Color.parseColor(val, Color.COLORTYPEINDEXED, FormatHandle.colorFOREGROUND, t);
        }
        val = this.attrs.get("theme");
        if (val != null) {
            return Color.parseColor(val, Color.COLORTYPETHEME, FormatHandle.colorFOREGROUND, t);
        }
        val = this.attrs.get("auto");
        if (val != null) {
            return "#000000";
        }
        return null;
    }

    protected void setColor(int c) {
        this.attrs.clear();
        this.attrs.put("indexed", String.valueOf(c));
    }

    protected int getColorAsInt(Theme t) {
        String val = this.attrs.get("auto");
        if (val != null) {
            return 0;
        }
        val = this.attrs.get("rgb");
        if (val != null) {
            return Color.parseColorInt(val, Color.COLORTYPERGB, FormatHandle.colorFOREGROUND, t);
        }
        val = this.attrs.get("indexed");
        if (val != null) {
            return Integer.valueOf(val);
        }
        val = this.attrs.get("theme");
        if (val != null) {
            return Color.parseColorInt(val, Color.COLORTYPETHEME, FormatHandle.colorFOREGROUND, t);
        }
        return -1;
    }

    public String toString() {
        if (this.attrs != null) {
            String s = this.attrs.toString();
            return s.substring(1, s.length() - 1);
        }
        return "none";
    }
}

