/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.Alignment;
import com.extentech.formats.OOXML.Border;
import com.extentech.formats.OOXML.Fill;
import com.extentech.formats.OOXML.NumFmt;
import com.extentech.formats.OOXML.OOXMLConstants;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.XLS.Font;
import com.extentech.toolkit.Logger;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;

public class Dxf
implements OOXMLElement {
    private static final long serialVersionUID = -5999328795988018131L;
    private Font font = null;
    private NumFmt numFmt = null;
    private Fill fill = null;
    private Alignment alignment = null;
    private Border border = null;
    private WorkBookHandle wbh = null;

    public Dxf(Font fnt, NumFmt nf, Fill f, Alignment a, Border b, WorkBookHandle wbh) {
        this.font = fnt;
        this.numFmt = nf;
        this.fill = f;
        this.alignment = a;
        this.border = b;
        this.wbh = wbh;
    }

    public Dxf(Dxf d) {
        this.font = d.font;
        this.numFmt = d.numFmt;
        this.fill = d.fill;
        this.alignment = d.alignment;
        this.border = d.border;
        this.wbh = d.wbh;
    }

    public Dxf() {
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, WorkBookHandle bk) {
        Font fnt = null;
        NumFmt nf = null;
        Fill f = null;
        Alignment a = null;
        Border b = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("font")) {
                        fnt = Font.parseOOXML(xpp, bk);
                    } else if (tnm.equals("numFmt")) {
                        nf = (NumFmt)NumFmt.parseOOXML(xpp);
                    } else if (tnm.equals("fill")) {
                        f = (Fill)Fill.parseOOXML(xpp, true, bk);
                    } else if (tnm.equals("alignment")) {
                        a = (Alignment)Alignment.parseOOXML(xpp);
                    } else if (tnm.equals("border")) {
                        b = (Border)Border.parseOOXML(xpp, bk);
                    } else {
                        tnm.equals("protection");
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("dxf")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("dxf.parseOOXML: " + e.toString());
        }
        Dxf d = new Dxf(fnt, nf, f, a, b, bk);
        return d;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<dxf>");
        if (this.font != null) {
            ooxml.append(this.font.getOOXML());
        }
        if (this.numFmt != null) {
            ooxml.append(this.numFmt.getOOXML());
        }
        if (this.fill != null) {
            ooxml.append(this.fill.getOOXML(true));
        }
        if (this.alignment != null) {
            ooxml.append(this.alignment.getOOXML());
        }
        if (this.border != null) {
            ooxml.append(this.border.getOOXML());
        }
        ooxml.append("</dxf>");
        return ooxml.toString();
    }

    public int[] getBorderColors() {
        if (this.border != null) {
            return this.border.getBorderColorInts();
        }
        return null;
    }

    public int[] getBorderStyles() {
        if (this.border != null) {
            int[] styles = this.border.getBorderStyles();
            if (Arrays.equals(new int[4], styles)) {
                return null;
            }
            return styles;
        }
        return null;
    }

    public int[] getBorderSizes() {
        if (this.border != null) {
            return this.border.getBorderSizes();
        }
        return null;
    }

    public boolean isStriken() {
        if (this.font != null) {
            return this.font.getStricken();
        }
        return false;
    }

    public int getFg() {
        if (this.fill != null) {
            return this.fill.getFgColorAsInt(this.wbh.getWorkBook().getTheme());
        }
        return -1;
    }

    public int getFillPatternInt() {
        if (this.fill != null) {
            return this.fill.getFillPatternInt();
        }
        return -1;
    }

    public Fill getFill() {
        return this.fill;
    }

    public int getBg() {
        if (this.fill != null) {
            return this.fill.getBgColorAsInt(this.wbh.getWorkBook().getTheme());
        }
        return -1;
    }

    public String getBgColorAsString() {
        if (this.fill != null) {
            return this.fill.getBgColorAsRGB(this.wbh.getWorkBook().getTheme());
        }
        return null;
    }

    public String getHorizontalAlign() {
        if (this.alignment != null) {
            return this.alignment.getAlignment("horizontal");
        }
        return null;
    }

    public String getVerticalAlign() {
        if (this.alignment != null) {
            return this.alignment.getAlignment("vertical");
        }
        return null;
    }

    public String getNumberFormat() {
        if (this.numFmt != null) {
            return this.numFmt.getFormatId();
        }
        return null;
    }

    public Font getFont() {
        return this.font;
    }

    public int getFontHeight() {
        if (this.font != null) {
            return this.font.getFontHeight();
        }
        return -1;
    }

    public int getFontWeight() {
        if (this.font != null) {
            return this.font.getFontWeight();
        }
        return -1;
    }

    public String getFontName() {
        if (this.font != null) {
            return this.font.getFontName();
        }
        return null;
    }

    public int getFontColor() {
        if (this.font != null) {
            return this.font.getColor();
        }
        return -1;
    }

    public boolean isItalic() {
        if (this.font != null) {
            return this.font.getItalic();
        }
        return false;
    }

    public int getFontUnderline() {
        if (this.font != null) {
            return this.font.getUnderlineStyle();
        }
        return -1;
    }

    public String getStyleProps() {
        String s;
        StringBuffer props = new StringBuffer();
        if (this.fill != null) {
            props.append("pattern:" + this.fill.getFillPatternInt() + ";");
            s = this.fill.getFgColorAsRGB(this.wbh.getWorkBook().getTheme());
            if (s != null) {
                props.append("patterncolor:#" + s + ";");
            }
            if ((s = this.fill.getBgColorAsRGB(this.wbh.getWorkBook().getTheme())) != null) {
                props.append("background:#" + s + ";");
            }
        }
        if (this.font != null) {
            if (!this.font.getFontName().equals("")) {
                props.append("font-name" + this.font.getFontName() + ";");
            }
            if (this.font.getFontWeight() > -1) {
                props.append("font-weight:" + this.font.getFontWeight() + ";");
            }
            if (this.font.getFontHeight() > -1) {
                props.append("font-Height:" + this.font.getFontHeight() + ";");
            }
            props.append("font-ColorIndex:" + this.font.getColor() + ";");
            if (this.font.getStricken()) {
                props.append("font-Striken:" + this.font.getStricken() + ";");
            }
            if (this.font.getItalic()) {
                props.append("font-italic:" + this.font.getItalic() + ";");
            }
            if (this.font.getUnderlineStyle() != 0) {
                props.append("font-UnderlineStyle:" + this.font.getUnderlineStyle() + ";");
            }
        }
        if (this.border != null) {
            int[] sizes = this.border.getBorderSizes();
            int[] styles = this.border.getBorderStyles();
            String[] colors = this.border.getBorderColors();
            props.append("border-top:" + sizes[0] + " " + FormatHandle.BORDER_NAMES[styles[0]] + " " + colors[0] + ";");
            props.append("border-left:" + sizes[1] + " " + FormatHandle.BORDER_NAMES[styles[1]] + " " + colors[1] + ";");
            props.append("border-bottom:" + sizes[2] + " " + FormatHandle.BORDER_NAMES[styles[2]] + " " + colors[2] + ";");
            props.append("border-right:" + sizes[3] + " " + FormatHandle.BORDER_NAMES[styles[3]] + " " + colors[3] + ";");
        }
        if (this.alignment != null) {
            s = this.alignment.getAlignment("vertical");
            if (s != null) {
                props.append("alignment-vertical" + s + ";");
            }
            if ((s = this.alignment.getAlignment("horizontal")) != null) {
                props.append("alignment-horizontal" + s + ";");
            }
        }
        if (this.numFmt != null) {
            s = this.numFmt.getFormatId();
            props.append("numberformat:" + s + ";");
        }
        return props.toString();
    }

    public void createFont(int w, boolean i, int ustyle, int cl, int h) {
        this.font = new Font("", w, h);
        if (w == 700) {
            this.font.setBold(true);
        }
        if (i) {
            this.font.setItalic(i);
        }
        if (ustyle != 0) {
            this.font.setUnderlineStyle((byte)ustyle);
        }
        this.font.setColor(cl);
    }

    public void setFill(Fill f) {
        this.fill = (Fill)f.cloneElement();
    }

    public void setFont(Font f) {
        this.font = f;
    }

    public void createFill(int fs, int fg, int bg, WorkBookHandle bk) {
        this.fill = fs < 0 || fs > OOXMLConstants.patternFill.length ? new Fill(null, fg, bg, bk.getWorkBook().getTheme()) : new Fill(OOXMLConstants.patternFill[fs], fg, bg, bk.getWorkBook().getTheme());
    }

    public void createBorder(WorkBookHandle bk, int[] styles, int[] colors) {
        this.border = new Border(bk, styles, colors);
    }

    @Override
    public OOXMLElement cloneElement() {
        return new Dxf(this);
    }
}

