/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.OOXML.PrstClr;
import com.extentech.formats.OOXML.SchemeClr;
import com.extentech.formats.OOXML.ScrgbClr;
import com.extentech.formats.OOXML.SrgbClr;
import com.extentech.formats.OOXML.SysClr;
import com.extentech.formats.OOXML.Theme;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class ColorChoice
implements OOXMLElement {
    private static final long serialVersionUID = -4117811305941771643L;
    private SchemeClr s;
    private SrgbClr srgb;
    private SysClr sys;
    private ScrgbClr scrgb;
    private PrstClr p;
    public Theme theme;

    public ColorChoice(SchemeClr s, SrgbClr srgb, SysClr sys, ScrgbClr scrgb, PrstClr p) {
        this.s = s;
        this.srgb = srgb;
        this.sys = sys;
        this.scrgb = scrgb;
        this.p = p;
    }

    private void setTheme(Theme t) {
        this.theme = t;
    }

    public ColorChoice(ColorChoice c) {
        this.s = c.s;
        this.srgb = c.srgb;
        this.sys = c.sys;
        this.scrgb = c.scrgb;
        this.p = c.p;
    }

    public static OOXMLElement parseOOXML(XmlPullParser xpp, Stack<String> lastTag, WorkBookHandle bk) {
        SchemeClr s = null;
        SrgbClr srgb = null;
        SysClr sys = null;
        ScrgbClr scrgb = null;
        PrstClr p = null;
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("schemeClr")) {
                        lastTag.push(tnm);
                        s = SchemeClr.parseOOXML(xpp, lastTag, bk);
                        lastTag.pop();
                        break;
                    }
                    if (tnm.equals("srgbClr")) {
                        lastTag.push(tnm);
                        srgb = SrgbClr.parseOOXML(xpp, lastTag);
                        lastTag.pop();
                        break;
                    }
                    if (tnm.equals("sysClr")) {
                        lastTag.push(tnm);
                        sys = SysClr.parseOOXML(xpp, lastTag);
                        lastTag.pop();
                        break;
                    }
                    if (tnm.equals("scrgbClr")) {
                        lastTag.push(tnm);
                        scrgb = ScrgbClr.parseOOXML(xpp, lastTag);
                        lastTag.pop();
                        break;
                    }
                    if (tnm.equals("prstClr")) {
                        lastTag.push(tnm);
                        p = PrstClr.parseOOXML(xpp, lastTag);
                        lastTag.pop();
                        break;
                    }
                } else if (eventType == 3) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("ColorChoice.parseOOXML: " + e.toString());
        }
        ColorChoice c = new ColorChoice(s, srgb, sys, scrgb, p);
        c.setTheme(bk.getWorkBook().getTheme());
        return c;
    }

    @Override
    public String getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        if (this.s != null) {
            ooxml.append(this.s.getOOXML());
        } else if (this.sys != null) {
            ooxml.append(this.sys.getOOXML());
        } else if (this.srgb != null) {
            ooxml.append(this.srgb.getOOXML());
        } else if (this.scrgb != null) {
            ooxml.append(this.scrgb.getOOXML());
        } else if (this.p != null) {
            ooxml.append(this.p.getOOXML());
        }
        return ooxml.toString();
    }

    @Override
    public OOXMLElement cloneElement() {
        return new ColorChoice(this);
    }

    public int getColor() {
        if (this.s != null) {
            return this.s.getColor();
        }
        if (this.sys != null) {
            this.sys.getColor();
        } else if (this.srgb != null) {
            this.srgb.getColor();
        } else if (this.scrgb != null) {
            this.scrgb.getColor();
        } else if (this.p != null) {
            this.p.getColor();
        }
        return -1;
    }
}

