/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.OOXML;

import com.extentech.formats.OOXML.OOXMLElement;
import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;

public class CfRule
implements OOXMLElement {
    private static final long serialVersionUID = 8509907308100079138L;
    private HashMap<String, String> attrs;
    private ArrayList<String> formulas;

    public CfRule(HashMap<String, String> attrs, ArrayList<String> formulas) {
        this.attrs = attrs;
        this.formulas = formulas;
    }

    public CfRule(CfRule cf) {
        this.attrs = cf.attrs;
        this.formulas = cf.formulas;
    }

    public static CfRule parseOOXML(XmlPullParser xpp) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        ArrayList<String> formulas = new ArrayList<String>();
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                String endTag;
                if (eventType == 2) {
                    String tnm = xpp.getName();
                    if (tnm.equals("cfRule")) {
                        int i = 0;
                        while (i < xpp.getAttributeCount()) {
                            attrs.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                            ++i;
                        }
                    } else if (tnm.equals("formula")) {
                        formulas.add(OOXMLAdapter.getNextText(xpp));
                    }
                } else if (eventType == 3 && (endTag = xpp.getName()).equals("cfRule")) break;
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("cfRule.parseOOXML: " + e.toString());
        }
        CfRule cf = new CfRule(attrs, formulas);
        return cf;
    }

    public String getOOXML(int priority) {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<cfRule");
        for (String key : this.attrs.keySet()) {
            String val = this.attrs.get(key);
            ooxml.append(" " + key + "=\"" + val + "\"");
        }
        ooxml.append(">");
        if (this.formulas != null) {
            int j = 0;
            while (j < this.formulas.size()) {
                ooxml.append("<formula>" + OOXMLAdapter.stripNonAsciiRetainQuote(this.formulas.get(j)) + "</formula>");
                ++j;
            }
        }
        ooxml.append("</cfRule>");
        return ooxml.toString();
    }

    public int getDxfId() {
        if (this.attrs != null) {
            try {
                return Integer.valueOf(this.attrs.get("dxfId"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public void setDxfId(int dxfId) {
        if (this.attrs == null) {
            this.attrs = new HashMap();
        }
        this.attrs.put("dxfId", Integer.valueOf(dxfId).toString());
    }

    @Override
    public OOXMLElement cloneElement() {
        return new CfRule(this);
    }

    @Override
    public String getOOXML() {
        return null;
    }

    public String getOperator() {
        if (this.attrs != null) {
            return this.attrs.get("operator");
        }
        return null;
    }

    public String getType() {
        String type = null;
        if (this.attrs != null) {
            type = this.attrs.get("type");
        }
        if (type == null) {
            type = "cellIs";
        }
        return type;
    }

    public String getContainsText() {
        if (this.attrs != null) {
            return this.attrs.get("text");
        }
        return null;
    }

    public String getFormula1() {
        if (this.formulas != null && this.formulas.size() > 0) {
            return this.formulas.get(0);
        }
        return null;
    }

    public String getFormula2() {
        if (this.formulas != null && this.formulas.size() > 1) {
            return this.formulas.get(1);
        }
        return null;
    }
}

