/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.LEO;

import com.extentech.formats.LEO.InvalidFileException;
import com.extentech.toolkit.TempFileManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class FileBuffer {
    private transient ByteBuffer buffer = null;
    private File tempfile = null;
    FileChannel channel = null;
    FileInputStream input = null;

    public void close() throws IOException {
        this.input.close();
        this.channel.close();
        if (this.tempfile != null) {
            this.tempfile.deleteOnExit();
            this.tempfile.delete();
        }
        this.tempfile = null;
    }

    public static FileBuffer readFile(String fpath) {
        try {
            File fx0 = new File(fpath);
            return FileBuffer.readFile(fx0);
        }
        catch (Throwable e) {
            throw new InvalidFileException("LEO FileBuffer.readFile() failed: " + e.toString());
        }
    }

    public static FileBuffer readFile(File fx0) {
        try {
            FileBuffer fb = new FileBuffer();
            fb.input = new FileInputStream(fx0);
            fb.channel = fb.input.getChannel();
            int fileLength = (int)fb.channel.size();
            fb.buffer = fb.channel.map(FileChannel.MapMode.READ_ONLY, 0L, fileLength);
            fb.buffer.order(ByteOrder.LITTLE_ENDIAN);
            return fb;
        }
        catch (Throwable e) {
            throw new InvalidFileException("LEO FileBuffer.readFile() failed: " + e.toString());
        }
    }

    public static FileBuffer readFileUsingTemp(String fpath) {
        return FileBuffer.readFileUsingTemp(new File(fpath));
    }

    public static FileBuffer readFileUsingTemp(File fx0) {
        try {
            FileBuffer fb = new FileBuffer();
            fb.tempfile = TempFileManager.createTempFile("LEOFile_", ".tmp");
            fb.tempfile.delete();
            FileInputStream input0 = new FileInputStream(fx0);
            FileChannel channel0 = input0.getChannel();
            FileOutputStream output0 = new FileOutputStream(fb.tempfile);
            FileChannel channel1 = output0.getChannel();
            channel0.transferTo(0L, fx0.length(), channel1);
            channel0.close();
            channel1.close();
            input0.close();
            output0.close();
            fb.input = new FileInputStream(fb.tempfile);
            fb.channel = fb.input.getChannel();
            int fileLength = (int)fb.channel.size();
            fb.buffer = fb.channel.map(FileChannel.MapMode.READ_ONLY, 0L, fileLength);
            fb.buffer.order(ByteOrder.LITTLE_ENDIAN);
            return fb;
        }
        catch (Throwable e) {
            throw new InvalidFileException("LEO FileBuffer.readFile() failed: " + e.toString());
        }
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ByteBuffer b) {
        this.buffer = b;
    }
}

