/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.LEO;

import com.extentech.formats.LEO.BIGBLOCK;
import com.extentech.formats.LEO.Block;
import com.extentech.formats.LEO.BlockImpl;
import com.extentech.formats.LEO.LEOFile;
import com.extentech.formats.LEO.SMALLBLOCK;
import com.extentech.toolkit.ByteTools;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BlockFactory {
    public static final Block getPrototypeBlock(int type) {
        BlockImpl retblock = null;
        ByteBuffer dta = null;
        switch (type) {
            case 1: {
                dta = ByteBuffer.allocate(512);
                retblock = new BIGBLOCK();
                break;
            }
            case 0: {
                dta = ByteBuffer.allocate(64);
                retblock = new SMALLBLOCK();
            }
        }
        dta.order(ByteOrder.LITTLE_ENDIAN);
        retblock.setBytes(dta);
        return retblock;
    }

    public static final Block[] getBlocksFromOutputStream(OutputStream bbuf, int blen, int type) {
        int SIZE = 0;
        switch (type) {
            case 1: {
                SIZE = 512;
                break;
            }
            case 0: {
                SIZE = 64;
            }
        }
        int sz = LEOFile.getSizeInBlocks(blen, SIZE);
        if (bbuf == null) {
            return null;
        }
        int len = blen / SIZE;
        int pos = 0;
        int sizeDiff = 0;
        int size = 0;
        if (len * SIZE < blen) {
            sizeDiff = ++len * SIZE - blen;
        }
        Block[] blockarr = new Block[len];
        ByteArrayInputStream ins = null;
        int i = 0;
        while (i < len) {
            Block bbd = BlockFactory.getPrototypeBlock(type);
            byte[] bb = bbd.getBytes();
            int filepos = i * SIZE;
            if (type == 0) {
                filepos = 0;
            }
            if (blen - pos < (size = SIZE)) {
                size = blen - pos;
            }
            ins.read(bb, pos, size);
            bbd.init(ByteBuffer.wrap(bb), i, filepos);
            pos += SIZE;
            blockarr[i] = bbd;
            ++i;
        }
        return blockarr;
    }

    public static final Block[] getBlocksFromByteArray(byte[] bbuf, int type) {
        int SIZE = 0;
        switch (type) {
            case 1: {
                SIZE = 512;
                break;
            }
            case 0: {
                SIZE = 64;
            }
        }
        if (bbuf == null) {
            return null;
        }
        int len = bbuf.length / SIZE;
        int pos = 0;
        int sizeDiff = 0;
        int size = 0;
        if (len * SIZE < bbuf.length) {
            sizeDiff = ++len * SIZE - bbuf.length;
            byte[] bb = new byte[sizeDiff];
            bbuf = ByteTools.append(bb, bbuf);
        }
        Block[] blockarr = new Block[len];
        boolean start = true;
        if (type == 0) {
            start = false;
        }
        int i = 0;
        while (i < len) {
            Block bbd = BlockFactory.getPrototypeBlock(type);
            byte[] bb = bbd.getBytes();
            size = SIZE;
            if (bbuf.length - pos < size) {
                size = bbuf.length - pos;
            }
            System.arraycopy(bbuf, pos, bb, 0, size);
            bbd.init(ByteBuffer.wrap(bb), i, 0);
            pos += size;
            blockarr[i] = bbd;
            ++i;
        }
        return blockarr;
    }
}

