/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.CellRange;
import com.extentech.ExtenXLS.ChartHandle;
import com.extentech.ExtenXLS.DateConverter;
import com.extentech.ExtenXLS.DocumentHandle;
import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.ExtenXLS.FormulaHandle;
import com.extentech.ExtenXLS.Handle;
import com.extentech.ExtenXLS.ImageHandle;
import com.extentech.ExtenXLS.NameHandle;
import com.extentech.ExtenXLS.PivotTableHandle;
import com.extentech.ExtenXLS.WorkBook;
import com.extentech.ExtenXLS.WorkBookException;
import com.extentech.ExtenXLS.WorkSheetHandle;
import com.extentech.formats.LEO.BlockByteReader;
import com.extentech.formats.LEO.InvalidFileException;
import com.extentech.formats.LEO.LEOFile;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.BookProtectionManager;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.CellNotFoundException;
import com.extentech.formats.XLS.ChartNotFoundException;
import com.extentech.formats.XLS.Condfmt;
import com.extentech.formats.XLS.Font;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.FormulaNotFoundException;
import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.Hlink;
import com.extentech.formats.XLS.ImageNotFoundException;
import com.extentech.formats.XLS.Mergedcells;
import com.extentech.formats.XLS.Mulblank;
import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.OOXMLAdapter;
import com.extentech.formats.XLS.OOXMLReader;
import com.extentech.formats.XLS.OOXMLWriter;
import com.extentech.formats.XLS.PivotCache;
import com.extentech.formats.XLS.PivotTableNotFoundException;
import com.extentech.formats.XLS.Sxview;
import com.extentech.formats.XLS.WorkBookFactory;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.extentech.formats.XLS.Xf;
import com.extentech.formats.XLS.charts.Chart;
import com.extentech.formats.XLS.charts.OOXMLChart;
import com.extentech.toolkit.JFileWriter;
import com.extentech.toolkit.Logger;
import com.extentech.toolkit.ProgressListener;
import com.extentech.toolkit.ResourceLoader;
import com.extentech.toolkit.StringTool;
import com.extentech.toolkit.TempFileManager;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class WorkBookHandle
extends DocumentHandle
implements WorkBook,
Handle {
    private static final long serialVersionUID = -7040065539645064209L;
    public static Writer dump_input = null;
    protected com.extentech.formats.XLS.WorkBook mybook;
    protected LEOFile myLEOFile;
    protected WorkBookFactory myfactory = null;
    protected ProgressListener plist;
    public static final int FORMAT_XLS = 100;
    public static final int FORMAT_XLSX = 101;
    public static final int FORMAT_XLSM = 102;
    public static final int FORMAT_XLTX = 103;
    public static final int FORMAT_XLTM = 104;
    private static byte[] protobook;
    private static byte[] protochart;
    private static byte[] protosheet;
    public static SimpleDateFormat simpledateformat;
    public static int RECURSION_LEVELS_ALLOWED;
    public static String CONVERTMULBLANKS;
    Hashtable sheethandles = new Hashtable();

    static {
        simpledateformat = new SimpleDateFormat();
        RECURSION_LEVELS_ALLOWED = 107;
        CONVERTMULBLANKS = "deprecated";
    }

    protected static byte[] getPrototypeBook() {
        if (protobook == null) {
            try {
                protobook = ResourceLoader.getBytesFromJar("/com/extentech/ExtenXLS/templates/prototype.ser");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return protobook;
    }

    protected static byte[] getPrototypeSheet() {
        if (protosheet == null) {
            try {
                WorkBookHandle bookhandle = new WorkBookHandle();
                com.extentech.formats.XLS.WorkBook book = bookhandle.getWorkBook();
                Boundsheet sheet = book.getWorkSheetByNumber(0);
                protosheet = sheet.getSheetBytes();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return protosheet;
    }

    protected static byte[] getPrototypeChart() {
        if (protochart == null) {
            try {
                byte[] bookbytes = ResourceLoader.getBytesFromJar("/com/extentech/ExtenXLS/templates/prototypechart.ser");
                WorkBookHandle chartBook = new WorkBookHandle(bookbytes);
                ChartHandle ch = chartBook.getCharts()[0];
                protochart = ch.getSerialBytes();
                return protochart;
            }
            catch (IOException e) {
                Logger.logErr("Unable to get default chart bytes");
            }
        }
        return protochart;
    }

    public WorkBookFactory getFactory() {
        return this.myfactory;
    }

    public LEOFile getLEOFile() {
        return this.myLEOFile;
    }

    public int searchAndReplace(String searchfor, String replacewith) {
        CellHandle[] cx = this.getCells();
        int foundcount = 0;
        int t = 0;
        while (t < cx.length) {
            String v;
            if (!(cx[t].getCell() instanceof Formula) && !cx[t].isNumber() && (v = cx[t].getStringVal()).indexOf(searchfor) > -1) {
                cx[t].setVal(StringTool.replaceText(v, searchfor, replacewith));
                ++foundcount;
            }
            ++t;
        }
        return foundcount;
    }

    public String[] getAllStrings() {
        return this.mybook.getAllStrings();
    }

    @Override
    public Color[] getColorTable() {
        return this.getWorkBook().getColorTable();
    }

    @Deprecated
    public boolean is1904() {
        return this.mybook.is1904();
    }

    @Override
    public DateConverter.DateFormat getDateFormat() {
        return this.mybook.getDateFormat();
    }

    public String getXLSVersionString() {
        return this.mybook.getXLSVersionString();
    }

    public String getStats(boolean usehtml) {
        return this.mybook.getStats(usehtml);
    }

    public String getStats() {
        return this.mybook.getStats();
    }

    @Override
    public CellHandle getCell(String address) throws CellNotFoundException, WorkSheetNotFoundException {
        int shtpos = address.indexOf("!");
        if (shtpos < 0) {
            throw new CellNotFoundException(String.valueOf(address) + " not found.  You need to specify a location in the format: Sheet1!A1");
        }
        String sheetstr = address.substring(0, shtpos);
        WorkSheetHandle sht = this.getWorkSheet(sheetstr);
        String celstr = address.substring(shtpos + 1);
        return sht.getCell(celstr);
    }

    public CellRange[] getCellRanges() {
        return this.mybook.getRefTracker().getCellRanges();
    }

    @Override
    public PivotTableHandle getPivotTable(String ptname) throws PivotTableNotFoundException {
        Sxview st = this.mybook.getPivotTableView(ptname);
        if (st == null) {
            throw new PivotTableNotFoundException(ptname);
        }
        return new PivotTableHandle(st, this);
    }

    @Override
    public PivotTableHandle[] getPivotTables() throws PivotTableNotFoundException {
        Sxview[] sxv = this.mybook.getAllPivotTableViews();
        if (sxv == null || sxv.length == 0) {
            throw new PivotTableNotFoundException("There are no PivotTables defined in: " + this.getName());
        }
        PivotTableHandle[] pth = new PivotTableHandle[sxv.length];
        int t = 0;
        while (t < pth.length) {
            pth[t] = new PivotTableHandle(sxv[t], this);
            ++t;
        }
        return pth;
    }

    @Override
    public void setFormulaCalculationMode(int CalcMode2) {
        this.mybook.setCalcMode(CalcMode2);
    }

    @Override
    public int getFormulaCalculationMode() {
        return this.mybook.getCalcMode();
    }

    @Override
    public void setProtected(boolean protect) {
        BookProtectionManager protector = this.mybook.getProtectionManager();
        if (protect) {
            protector.setPassword("VelvetSweatshop");
        } else {
            protector.setPassword(null);
        }
        protector.setProtected(protect);
    }

    @Override
    public void setDefaultRowHeight(int t) {
        this.mybook.setDefaultRowHeight(t);
    }

    @Override
    public void setDefaultColWidth(int t) {
        this.mybook.setDefaultColWidth(t);
    }

    public FormulaHandle getFormulaHandle(String celladdress) throws FormulaNotFoundException {
        Formula formula = this.mybook.getFormula(celladdress);
        return new FormulaHandle(formula, this);
    }

    public ImageHandle[] getImages() {
        Vector<ImageHandle> ret = new Vector<ImageHandle>();
        int t = 0;
        while (t < this.getNumWorkSheets()) {
            try {
                ImageHandle[] r2 = this.getWorkSheet(t).getImages();
                int x = 0;
                while (x < r2.length) {
                    ret.add(r2[x]);
                    ++x;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++t;
        }
        ImageHandle[] retx = new ImageHandle[ret.size()];
        ret.toArray(retx);
        return retx;
    }

    public ImageHandle getImage(String imagename) throws ImageNotFoundException {
        int t = 0;
        while (t < this.getNumWorkSheets()) {
            try {
                ImageHandle[] r2 = this.getWorkSheet(t).getImages();
                int x = 0;
                while (x < r2.length) {
                    if (r2[x].getName().equals(imagename)) {
                        return r2[x];
                    }
                    ++x;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++t;
        }
        throw new ImageNotFoundException("Image not found: " + imagename + " in " + this.toString());
    }

    @Override
    public NameHandle getNamedRange(String rangename) throws CellNotFoundException {
        Name nand = this.mybook.getName(rangename.toUpperCase());
        if (nand == null) {
            throw new CellNotFoundException(rangename);
        }
        return new NameHandle(nand, this);
    }

    public NameHandle getNamedRangeInScope(String rangename) throws CellNotFoundException {
        Name nand = this.mybook.getScopedName(rangename);
        if (nand == null) {
            throw new CellNotFoundException(rangename);
        }
        return new NameHandle(nand, this);
    }

    public NameHandle createNamedRange(String name, String rangeDef) {
        NameHandle nh = new NameHandle(name, rangeDef, this);
        return nh;
    }

    @Override
    public ChartHandle getChart(String chartname) throws ChartNotFoundException {
        return new ChartHandle(this.mybook.getChart(chartname), this);
    }

    @Override
    public ChartHandle[] getCharts() {
        AbstractList cv = this.mybook.getChartVect();
        ChartHandle[] cht = new ChartHandle[cv.size()];
        int x = 0;
        while (x < cv.size()) {
            cht[x] = new ChartHandle((Chart)cv.get(x), this);
            ++x;
        }
        return cht;
    }

    public ChartHandle getChartById(int id) throws ChartNotFoundException {
        AbstractList cv = this.mybook.getChartVect();
        Chart cht = null;
        int x = 0;
        while (x < cv.size()) {
            cht = (Chart)cv.get(x);
            if (cht.getId() == id) {
                return new ChartHandle(cht, this);
            }
            ++x;
        }
        throw new ChartNotFoundException("Id " + id);
    }

    @Override
    public NameHandle[] getNamedRanges() {
        Name[] nand = this.mybook.getNames();
        NameHandle[] nands = new NameHandle[nand.length];
        int x = 0;
        while (x < nand.length) {
            nands[x] = new NameHandle(nand[x], this);
            ++x;
        }
        return nands;
    }

    public NameHandle[] getNamedRangesInScope() {
        Name[] nand = this.mybook.getWorkbookScopedNames();
        NameHandle[] nands = new NameHandle[nand.length];
        int x = 0;
        while (x < nand.length) {
            nands[x] = new NameHandle(nand[x], this);
            ++x;
        }
        return nands;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "New Spreadsheet";
    }

    @Override
    public CellHandle[] getCells() {
        BiffRec[] allcz = this.mybook.getCells();
        CellHandle[] ret = new CellHandle[allcz.length];
        Mulblank aMul = null;
        int c = -1;
        int t = 0;
        while (t < ret.length) {
            ret[t] = new CellHandle(allcz[t], this);
            if (allcz[t].getOpcode() == 190) {
                if (allcz[t] == aMul) {
                    c = (short)(c + 1);
                } else {
                    aMul = (Mulblank)allcz[t];
                    c = (short)aMul.getColFirst();
                }
                ret[t].setBlankRef(c);
            }
            ++t;
        }
        return ret;
    }

    @Override
    public int getNumCells() {
        return this.mybook.getNumCells();
    }

    public boolean showSheetTabs() {
        return this.mybook.showSheetTabs();
    }

    public void setShowSheetTabs(boolean show) {
        this.mybook.setShowSheetTabs(show);
    }

    @Override
    @Deprecated
    public byte[] getBytes() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.writeBytes(bout);
            return bout.toByteArray();
        }
        catch (Exception e1) {
            Logger.logErr("Getting Spreadsheet bytes failed.", e1);
            return null;
        }
    }

    @Deprecated
    public void write(String path) {
        String ext = path.toLowerCase();
        this.write(path, ext.endsWith(".xlsx") || ext.endsWith(".xlsm"));
    }

    @Deprecated
    public void write(String path, boolean ooxml) {
        int format;
        if (ooxml) {
            format = this.getIsExcel2007() ? this.getFormat(path) : 101;
            path = !OOXMLAdapter.hasMacros(this) ? StringTool.replaceExtension(path, ".xlsx") : StringTool.replaceExtension(path, ".xlsm");
        } else {
            format = 100;
        }
        try {
            this.write(new File(path), format);
        }
        catch (Exception e) {
            throw new WorkBookException("error writing workbook", 6, e);
        }
    }

    @Deprecated
    public void write(OutputStream dest, boolean ooxml) {
        int format = ooxml ? (this.getIsExcel2007() ? this.getFormat() : 101) : 100;
        try {
            if (format > 100 && this.file != null) {
                OOXMLAdapter.refreshPassThroughFiles(this);
            }
            this.write(dest, format);
        }
        catch (Exception e) {
            throw new WorkBookException("error writing workbook", 6, e);
        }
    }

    @Override
    public int getFormat() {
        String name = this.getFileName().toLowerCase();
        if (this.getIsExcel2007()) {
            if (OOXMLAdapter.hasMacros(this)) {
                return name.endsWith(".xltm") ? 104 : 102;
            }
            return name.endsWith(".xltx") ? 103 : 101;
        }
        return 100;
    }

    public int getFormat(String path) {
        if (path == null) {
            return this.getFormat();
        }
        if (this.getIsExcel2007()) {
            if (OOXMLAdapter.hasMacros(this)) {
                return path.endsWith(".xltm") ? 104 : 102;
            }
            return path.endsWith(".xltx") ? 103 : 101;
        }
        return 100;
    }

    @Override
    public String getFileExtension() {
        switch (this.getFormat()) {
            case 101: {
                return ".xlsx";
            }
            case 102: {
                return ".xlsm";
            }
            case 103: {
                return ".xltx";
            }
            case 104: {
                return ".xltm";
            }
            case 100: {
                return ".xls";
            }
        }
        return "";
    }

    @Override
    public void write(OutputStream dest, int format) throws IOException {
        if (format == 0) {
            format = this.getFormat();
        }
        switch (format) {
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                try {
                    if (this.file != null) {
                        OOXMLAdapter.refreshPassThroughFiles(this);
                    }
                    OOXMLWriter adapter = new OOXMLWriter();
                    adapter.setFormat(format);
                    adapter.getOOXML(this, dest);
                    break;
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WorkBookException("error writing workbook", 6, e);
                }
            }
            case 100: {
                try {
                    this.mybook.getStreamer().writeOut(dest);
                    break;
                }
                catch (com.extentech.formats.XLS.WorkBookException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw e;
                }
            }
            default: {
                throw new IllegalArgumentException("unknown output format");
            }
        }
    }

    @Deprecated
    public void writeXLSXBytes(OutputStream dest, int format) throws Exception {
        this.write(dest, format);
    }

    @Deprecated
    public void writeXLSXBytes(OutputStream dest) throws Exception {
        this.write(dest, true);
    }

    public boolean getIsExcel2007() {
        return this.mybook.getIsExcel2007();
    }

    public void setIsExcel2007(boolean isExcel2007) {
        this.mybook.setIsExcel2007(isExcel2007);
    }

    @Override
    @Deprecated
    public StringBuffer writeBytes(OutputStream dest) {
        StringBuffer sb = this.mybook.getStreamer().writeOut(dest);
        return sb;
    }

    public WorkBookHandle() {
        this.initDefault();
    }

    public WorkBookHandle(boolean Excel2007) {
        this.initDefault();
        this.setIsExcel2007(Excel2007);
    }

    protected void initDefault() {
        try {
            byte[] b = WorkBookHandle.getPrototypeBook();
            if (b == null) {
                throw new com.extentech.formats.XLS.WorkBookException("Unable to load prototype workbook.", 2);
            }
            ByteBuffer bbf = ByteBuffer.wrap(b);
            bbf.order(ByteOrder.LITTLE_ENDIAN);
            this.myLEOFile = new LEOFile(bbf);
        }
        catch (Exception e) {
            throw new InvalidFileException("WorkBook could not be instantiated: " + e.toString());
        }
        this.initFromLeoFile(this.myLEOFile);
    }

    public WorkBookHandle(InputStream inx) {
        this.initFromStream(inx);
    }

    private void initFromLeoFile(LEOFile leo) {
        this.myLEOFile = leo;
        try {
            BlockByteReader bar = this.myLEOFile.getXLSBlockBytes();
            this.initBytes(bar);
            this.setIsExcel2007(false);
            this.myLEOFile.clearAfterInit();
        }
        catch (Exception e) {
            if (e instanceof com.extentech.formats.XLS.WorkBookException) {
                throw (com.extentech.formats.XLS.WorkBookException)e;
            }
            throw new com.extentech.formats.XLS.WorkBookException("ERROR: instantiating WorkBookHandle failed: " + e, 3, e);
        }
    }

    protected void initFromStream(InputStream input) {
        try {
            File target = TempFileManager.createTempFile("WBP", ".tmp");
            JFileWriter.writeToFile(input, target);
            this.initFromFile(target.getAbsoluteFile());
            if (this.myLEOFile != null) {
                this.myLEOFile.closefb();
            }
            input.close();
            File fdel = new File(target.toString());
            if (!fdel.delete() && this.DEBUGLEVEL > 50) {
                Logger.logWarn("Could not delete tempfile: " + target.toString());
            }
        }
        catch (IOException ex) {
            Logger.logErr("Initializing WorkBookHandle failed.", ex);
        }
    }

    public WorkBookHandle(byte[] barray) {
        this.initializeFromByteArray(barray);
    }

    protected void initializeFromByteArray(byte[] barray) {
        if ((char)barray[0] == 'P' && (char)barray[1] == 'K') {
            try {
                File ftmp = TempFileManager.createTempFile("WBP", ".tmp");
                FileOutputStream fous = new FileOutputStream(ftmp);
                fous.write(barray);
                fous.flush();
                fous.close();
                this.initFromFile(ftmp);
                return;
            }
            catch (Exception e) {
                Logger.logErr("Could not parse XLSX from bytes." + e.toString());
                return;
            }
        }
        ByteBuffer bbf = ByteBuffer.wrap(barray);
        bbf.order(ByteOrder.LITTLE_ENDIAN);
        this.myLEOFile = new LEOFile(bbf);
        if (this.myLEOFile.hasWorkBook()) {
            try {
                BlockByteReader bar = this.myLEOFile.getXLSBlockBytes();
                this.initBytes(bar);
            }
            catch (Throwable e) {
                if (e instanceof OutOfMemoryError) {
                    throw (Error)e;
                }
                if (e instanceof WorkBookException) {
                    throw (WorkBookException)e;
                }
                String errstr = "Instantiating WorkBookHandle failed: " + e.toString();
                throw new com.extentech.formats.XLS.WorkBookException(errstr, 3);
            }
        } else {
            Logger.logWarn("Initializing WorkBookHandle failed: byte array does not contain a supported Excel WorkBook.");
            throw new InvalidFileException("byte array does not contian a supported Excel WorkBook.");
        }
    }

    public WorkBookHandle(URL url) {
        this(WorkBookHandle.getFileFromURL(url));
    }

    public WorkBookHandle(String filePath) {
        this(filePath, 0);
    }

    public WorkBookHandle(String filePath, int debug) {
        this.setDebugLevel(debug);
        File f = new File(filePath);
        this.initFromFile(f);
        this.file = f;
    }

    public WorkBookHandle(File fx) {
        this.initFromFile(fx);
    }

    protected void initWorkBookFactory() {
        this.myfactory = new WorkBookFactory();
    }

    private boolean initXLSX(String fname) {
        this.initWorkBookFactory();
        this.myfactory.setDebugLevel(this.DEBUGLEVEL);
        this.myfactory.setFileName(this.name);
        if (this.plist != null) {
            this.myfactory.register(this.plist);
        }
        try {
            OOXMLReader oe = new OOXMLReader();
            WorkBookHandle bk = new WorkBookHandle();
            bk.removeAllWorkSheets();
            this.myfactory.setDebugLevel(this.DEBUGLEVEL);
            bk.DEBUGLEVEL = this.DEBUGLEVEL;
            oe.parseNBind(bk, fname);
            this.sheethandles = bk.sheethandles;
            this.mybook = bk.mybook;
        }
        catch (Exception e) {
            throw new WorkBookException("WorkBookHandle OOXML Read failed: " + e.toString(), 3, e);
        }
        this.mybook.setIsExcel2007(true);
        return true;
    }

    protected void initFromFile(File fx) {
        String fname = fx.getPath();
        String finch = "";
        try {
            FileReader fincheck = new FileReader(fx);
            if (fx.length() > 100L) {
                char[] cbuf = new char[100];
                fincheck.read(cbuf);
                finch = new String(cbuf);
            }
            fincheck.close();
        }
        catch (FileNotFoundException e) {
            Logger.logErr("WorkBookHandle: Cannot open file " + fname + ": " + e);
        }
        catch (Exception e1) {
            Logger.logErr("Invalid XLSX/OOXML File.");
        }
        this.name = fname;
        if (finch.toUpperCase().startsWith("PK")) {
            if (this.file != null) {
                OOXMLAdapter.refreshPassThroughFiles(this);
            }
            if (this.initXLSX(fname)) {
                return;
            }
        }
        try {
            this.myLEOFile = new LEOFile(fx, this.DEBUGLEVEL);
        }
        catch (InvalidFileException ifx) {
            if (finch.indexOf(",") > -1 && finch.indexOf(",") > -1) {
                this.initDefault();
                try {
                    WorkSheetHandle sheet = this.getWorkSheet(0);
                    sheet.readCSV(new BufferedReader(new FileReader(fx)));
                    return;
                }
                catch (Exception e) {
                    throw new WorkBookException("Error encountered importing CSV: " + e.toString(), 11);
                }
            }
            throw ifx;
        }
        if (!this.myLEOFile.hasWorkBook()) {
            Logger.logErr("Initializing WorkBookHandle failed: " + fname + " does not contain a supported Excel WorkBook.");
            throw new InvalidFileException(String.valueOf(fname) + " does not contian a supported Excel WorkBook.");
        }
        this.initFromLeoFile(this.myLEOFile);
    }

    public WorkBookHandle(ProgressListener pn) {
        this.plist = pn;
        try {
            byte[] b = WorkBookHandle.getPrototypeBook();
            ByteBuffer bbf = ByteBuffer.wrap(b);
            bbf.order(ByteOrder.LITTLE_ENDIAN);
            this.myLEOFile = new LEOFile(bbf);
        }
        catch (Exception e) {
            throw new InvalidFileException("WorkBook could not be instantiated: " + e.toString());
        }
        this.initFromLeoFile(this.myLEOFile);
    }

    public WorkBookHandle(String fname, ProgressListener pn) {
        this.plist = pn;
        this.initFromFile(new File(fname));
    }

    protected WorkBookHandle(LEOFile leo) {
        this.initFromLeoFile(leo);
    }

    protected synchronized void initBytes(BlockByteReader blockByteReader) {
        this.initWorkBookFactory();
        if (this.plist != null) {
            this.myfactory.register(this.plist);
        }
        this.myfactory.setDebugLevel(this.DEBUGLEVEL);
        this.mybook = (com.extentech.formats.XLS.WorkBook)this.myfactory.getWorkBook(blockByteReader, this.myLEOFile);
        if (dump_input != null) {
            try {
                dump_input.flush();
                dump_input.close();
                dump_input = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.postLoad();
    }

    void postLoad() {
        this.initHlinks();
        this.initMerges();
        this.mybook.initializeNames();
        this.mybook.mergeMSODrawingRecords();
        this.mybook.initializeIndirectFormulas();
        this.initPivotCache();
    }

    void initMerges() {
        AbstractList mergelookup = this.mybook.getMergecelllookup();
        int t = 0;
        while (t < mergelookup.size()) {
            Mergedcells mc = (Mergedcells)mergelookup.get(t);
            mc.initCells(this);
            ++t;
        }
    }

    void initHlinks() {
        AbstractList hlinklookup = this.mybook.getHlinklookup();
        int t = 0;
        while (t < hlinklookup.size()) {
            Hlink hl = (Hlink)hlinklookup.get(t);
            hl.initCells(this);
            ++t;
        }
    }

    void initPivotCache() {
        if (this.myLEOFile.hasPivotCache()) {
            PivotCache pc = new PivotCache();
            try {
                pc.init(this.myLEOFile.getDirectoryArray(), this);
                this.mybook.setPivotCache(pc);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
        block4: {
            try {
                if (this.myLEOFile != null) {
                    this.myLEOFile.shutdown();
                }
                this.myLEOFile = null;
            }
            catch (Exception e) {
                if (this.DEBUGLEVEL <= 3) break block4;
                Logger.logWarn("Closing Document: " + this.toString() + " failed: " + e.toString());
            }
        }
        if (this.mybook != null) {
            this.mybook.close();
        }
        this.mybook = null;
        this.myfactory = null;
        this.name = null;
        this.sheethandles = null;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public void reset() {
        this.initFromFile(new File(this.myLEOFile.getFileName()));
    }

    @Override
    public WorkSheetHandle[] getWorkSheets() {
        try {
            if (this.myfactory != null) {
                int numsheets = this.mybook.getNumWorkSheets();
                if (numsheets == 0) {
                    throw new WorkSheetNotFoundException("WorkBook has No Sheets.");
                }
                WorkSheetHandle[] sheets = new WorkSheetHandle[numsheets];
                int i = 0;
                while (i < numsheets) {
                    Boundsheet bs = this.mybook.getWorkSheetByNumber(i);
                    bs.setWorkBook(this.mybook);
                    sheets[i] = new WorkSheetHandle(bs, this);
                    ++i;
                }
                return sheets;
            }
            return null;
        }
        catch (WorkSheetNotFoundException a) {
            Logger.logWarn("getWorkSheets() failed: " + a);
            return null;
        }
    }

    @Override
    public WorkSheetHandle getWorkSheet(int sheetnum) throws WorkSheetNotFoundException {
        Boundsheet st = this.mybook.getWorkSheetByNumber(sheetnum);
        if (this.sheethandles.get(st.getSheetName()) != null) {
            return (WorkSheetHandle)this.sheethandles.get(st.getSheetName());
        }
        WorkSheetHandle shth = new WorkSheetHandle(st, this);
        this.sheethandles.put(st.getSheetName(), shth);
        return shth;
    }

    @Override
    public WorkSheetHandle getWorkSheet(String handstr) throws WorkSheetNotFoundException {
        if (this.sheethandles.get(handstr) != null) {
            if (this.mybook.getWorkSheetByName(handstr) != null) {
                return (WorkSheetHandle)this.sheethandles.get(handstr);
            }
            throw new WorkSheetNotFoundException(String.valueOf(handstr) + " not found");
        }
        if (this.myfactory != null) {
            Boundsheet bs = this.mybook.getWorkSheetByName(handstr);
            if (bs != null) {
                bs.setWorkBook(this.mybook);
                WorkSheetHandle ret = new WorkSheetHandle(bs, this);
                this.sheethandles.put(handstr, ret);
                return ret;
            }
            throw new WorkSheetNotFoundException(handstr);
        }
        throw new WorkSheetNotFoundException("Cannot find WorkSheet " + handstr);
    }

    public WorkSheetHandle getActiveSheet() throws WorkSheetNotFoundException {
        return this.getWorkSheet(this.getWorkBook().getSelectedSheetNum());
    }

    @Override
    public com.extentech.formats.XLS.WorkBook getWorkBook() {
        return this.mybook;
    }

    @Override
    public void setStringEncodingMode(int mode) {
        this.mybook.setStringEncodingMode(mode);
    }

    @Override
    public void setDupeStringMode(int mode) {
        this.mybook.setDupeStringMode(mode);
    }

    @Override
    public void copyChartToSheet(String chartname, String sheetname) throws ChartNotFoundException, WorkSheetNotFoundException {
        this.mybook.copyChartToSheet(chartname, sheetname);
    }

    @Override
    public void copyChartToSheet(ChartHandle chart, WorkSheetHandle sheet) throws ChartNotFoundException, WorkSheetNotFoundException {
        this.mybook.copyChartToSheet(chart.getTitle(), sheet.getSheetName());
    }

    @Override
    public WorkSheetHandle copyWorkSheet(String SourceSheetName, String NewSheetName) throws WorkSheetNotFoundException {
        try {
            this.mybook.copyWorkSheet(SourceSheetName, NewSheetName);
        }
        catch (Exception e) {
            throw new WorkBookException("Failed to copy WorkSheet: " + SourceSheetName + ": " + e.toString(), 4);
        }
        this.mybook.getRefTracker().clearPtgLocationCaches(NewSheetName);
        WorkSheetHandle wsh = this.getWorkSheet(NewSheetName);
        if (wsh != null) {
            List mc = wsh.getMysheet().getMergedCellsRecs();
            int i = 0;
            while (i < mc.size()) {
                Mergedcells mrg = (Mergedcells)mc.get(i);
                if (mrg != null) {
                    mrg.initCells(this);
                }
                ++i;
            }
        }
        return wsh;
    }

    @Override
    public void calculateFormulas() {
        this.markFormulasDirty();
        this.recalc();
    }

    public void markFormulasDirty() {
        Formula[] formulas = this.mybook.getFormulas();
        int idx = 0;
        while (idx < formulas.length) {
            formulas[idx].clearCachedValue();
            ++idx;
        }
    }

    public void recalc() {
        int calcmode = this.mybook.getCalcMode();
        this.mybook.setCalcMode(2);
        Formula[] formulas = this.mybook.getFormulas();
        int idx = 0;
        while (idx < formulas.length) {
            try {
                formulas[idx].clearCachedValue();
                formulas[idx].calculate();
            }
            catch (FunctionNotSupportedException fe) {
                Logger.logErr("WorkBookHandle.recalc:  Error calculating Formula " + fe.toString());
            }
            ++idx;
        }
        this.getWorkBook().getRefTracker().clearLookupCaches();
        this.mybook.setCalcMode(calcmode);
    }

    @Override
    public void removeAllWorkSheets() {
        try {
            Object ob = this.mybook.getTabID().getTabIDs().get(0);
            this.mybook.getTabID().getTabIDs().removeAllElements();
            this.mybook.getTabID().getTabIDs().add(ob);
            this.mybook.getTabID().updateRecord();
        }
        catch (Exception ob) {
            // empty catch block
        }
        WorkSheetHandle[] ws = this.getWorkSheets();
        try {
            int x = 0;
            while (x < ws.length) {
                try {
                    ws[x].remove();
                }
                catch (WorkBookException workBookException) {
                    // empty catch block
                }
                ++x;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sheethandles.clear();
        this.mybook.closeSheets();
    }

    @Override
    public WorkBookHandle getNoSheetWorkBook() {
        Object[] recs = this.getWorkBook().getStreamer().getBiffRecords();
        byte[] gb = this.getBytes();
        WorkBookHandle ret = new WorkBookHandle(gb);
        this.getWorkBook().getStreamer().setBiffRecords(Arrays.asList(recs));
        ret.removeAllWorkSheets();
        return ret;
    }

    @Override
    @Deprecated
    public boolean addSheetFromWorkBook(WorkBookHandle sourceBook, String sourceSheetName, String destSheetName) {
        try {
            WorkSheetHandle sheet = this.addWorkSheet(sourceBook.getWorkSheet(sourceSheetName), destSheetName);
            return true;
        }
        catch (WorkSheetNotFoundException e) {
            Logger.logErr("Error adding sheet from workbook" + e);
            return false;
        }
    }

    @Deprecated
    public boolean addSheetFromWorkBookWithFormatting(WorkBookHandle sourceBook, String sourceSheetName, String destSheetName) {
        try {
            WorkSheetHandle sheet = this.addWorkSheet(sourceBook.getWorkSheet(sourceSheetName), destSheetName);
            return true;
        }
        catch (WorkSheetNotFoundException e) {
            Logger.logErr("Error adding sheet from workbook" + e);
            return false;
        }
    }

    public WorkSheetHandle addWorkSheet(WorkSheetHandle sourceSheet) {
        return this.addWorkSheet(sourceSheet, sourceSheet.getSheetName());
    }

    @Override
    public WorkSheetHandle addWorkSheet(WorkSheetHandle sourceSheet, String NewSheetName) {
        sourceSheet.getSheet().populateForTransfer();
        List chts = sourceSheet.getSheet().getCharts();
        int i = 0;
        while (i < chts.size()) {
            Chart cxi = (Chart)chts.get(i);
            cxi.populateForTransfer();
            ++i;
        }
        byte[] bao = sourceSheet.getSerialBytes();
        try {
            this.mybook.addBoundsheet(bao, sourceSheet.getSheetName(), NewSheetName, StringTool.stripPath(sourceSheet.getWorkBook().getName()), true);
            WorkSheetHandle wsh = this.getWorkSheet(NewSheetName);
            if (wsh != null) {
                List mc = wsh.getMysheet().getMergedCellsRecs();
                int i2 = 0;
                while (i2 < mc.size()) {
                    Mergedcells mrg = (Mergedcells)mc.get(i2);
                    if (mrg != null) {
                        mrg.initCells(this);
                    }
                    ++i2;
                }
            }
            return wsh;
        }
        catch (Exception e) {
            throw new WorkBookException("Failed to copy WorkSheet: " + e.toString(), 4);
        }
    }

    public FormatHandle transferExternalFormatHandle(FormatHandle externalFormat) {
        Xf xf = externalFormat.getXf();
        FormatHandle newHandle = new FormatHandle(this);
        newHandle.addXf(xf);
        return newHandle;
    }

    public ChartHandle createChart(String name, WorkSheetHandle wsh) {
        try {
            Font f;
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(WorkBookHandle.getPrototypeChart()));
            Chart newchart = (Chart)ois.readObject();
            newchart.setWorkBook(this.getWorkBook());
            if (this.getIsExcel2007()) {
                newchart = new OOXMLChart(newchart, this);
            }
            this.mybook.addPreChart();
            this.mybook.addChart(newchart, name, wsh.getSheet());
            ChartHandle bs = new ChartHandle(newchart, this);
            int nfonts = this.mybook.getNumFonts();
            while (nfonts < 8) {
                f = new Font("Arial", 400, 200);
                this.mybook.insertFont(f);
                ++nfonts;
            }
            f = this.mybook.getFont(8);
            if (f.toString().equals("Arial,400,200 java.awt.Color[r=0,g=0,b=0] font style:[falsefalsefalsefalse00]")) {
                f = new Font("Arial", 700, 240);
                bs.setAxisFont(f);
            }
            if ((f = this.mybook.getFont(7)).toString().equals("Arial,400,200 java.awt.Color[r=0,g=0,b=0] font style:[falsefalsefalsefalse00]")) {
                f = new Font("Arial", 700, 360);
                bs.setTitleFont(f);
            }
            bs.removeSeries(0);
            bs.setAxisTitle(0, null);
            bs.setAxisTitle(1, null);
            return bs;
        }
        catch (Exception e) {
            Logger.logErr("Creating New Chart: " + name + " failed: " + e);
            return null;
        }
    }

    public void deleteChart(String chartname, WorkSheetHandle wsh) throws ChartNotFoundException {
        try {
            this.mybook.deleteChart(chartname, wsh.getSheet());
        }
        catch (ChartNotFoundException e) {
            throw new ChartNotFoundException("Removing Chart: " + chartname + " failed: " + e);
        }
        catch (Exception e) {
            Logger.logErr("Removing Chart: " + chartname + " failed: " + e);
        }
    }

    public int getNumWorkSheets() {
        return this.mybook.getNumWorkSheets();
    }

    public WorkSheetHandle createWorkSheet(String name, int sheetpos) {
        if (sheetpos > this.getNumWorkSheets()) {
            sheetpos = this.getNumWorkSheets();
        }
        if (sheetpos < 0) {
            sheetpos = 0;
        }
        WorkSheetHandle s = this.createWorkSheet(name);
        s.setTabIndex(sheetpos);
        return s;
    }

    @Override
    public WorkSheetHandle createWorkSheet(String name) {
        try {
            this.getWorkSheet(name);
            throw new WorkBookException("Attempting to add worksheet with duplicate name. " + name + " already exists in " + this.toString(), 4);
        }
        catch (WorkSheetNotFoundException workSheetNotFoundException) {
            Boundsheet bo = null;
            try {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(WorkBookHandle.getPrototypeSheet()));
                bo = (Boundsheet)ois.readObject();
                this.mybook.addBoundsheet(bo, null, name, null, false);
                try {
                    WorkSheetHandle bs = this.getWorkSheet(name);
                    if (this.mybook.getNumWorkSheets() == 1) {
                        bs.setSelected(true);
                    } else {
                        bs.setSelected(false);
                    }
                    return bs;
                }
                catch (WorkSheetNotFoundException e) {
                    Logger.logWarn("Creating New Sheet: " + name + " failed: " + e);
                    return null;
                }
            }
            catch (Exception e) {
                Logger.logWarn("Error loading prototype sheet: " + e);
                return null;
            }
        }
    }

    @Override
    public FormatHandle[] getFormats() {
        AbstractList l = this.mybook.getXfrecs();
        FormatHandle[] formats = new FormatHandle[l.size()];
        Iterator its = l.iterator();
        int i = 0;
        while (its.hasNext()) {
            Xf x = (Xf)its.next();
            try {
                formats[i] = new FormatHandle();
                formats[i].setWorkBook(this.getWorkBook());
                formats[i].setXf(x);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return formats;
    }

    public FormatHandle[] getConditionalFormats() {
        Vector<FormatHandle> retl = new Vector<FormatHandle>();
        AbstractList v = this.mybook.getSheetVect();
        for (Boundsheet shtx : v) {
            List fmtlist = shtx.getConditionalFormats();
            for (Condfmt cfm : fmtlist) {
                int cfxe = cfm.getCfxe();
                FormatHandle fz = new FormatHandle(cfm, this, cfxe, null);
                fz.setFormatId(cfxe);
                retl.add(fz);
            }
        }
        FormatHandle[] formats = new FormatHandle[retl.size()];
        int t = 0;
        while (t < formats.length) {
            formats[t] = (FormatHandle)retl.get(t);
            ++t;
        }
        return formats;
    }

    public static void setFormulaRecursionLevels(int recursion_allowed) {
        RECURSION_LEVELS_ALLOWED = recursion_allowed;
    }

    public boolean isPublic() {
        return false;
    }

    public String getMemeId() {
        return null;
    }

    public int getOwnerId() {
        return 0;
    }
}

