/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.ExtenXLS;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.Handle;
import com.extentech.formats.XLS.Note;
import com.extentech.toolkit.Logger;

public class CommentHandle
implements Handle {
    private Note note;

    protected CommentHandle(Note n) {
        this.note = n;
    }

    public String getCommentText() {
        if (this.note != null) {
            return this.note.getText();
        }
        return null;
    }

    public void setCommentText(String text) {
        if (this.note != null) {
            try {
                this.note.setText(text);
            }
            catch (IllegalArgumentException e) {
                Logger.logErr(e.toString());
            }
        }
    }

    public String getAuthor() {
        if (this.note != null) {
            return this.note.getAuthor();
        }
        return null;
    }

    public void setAuthor(String author) {
        if (this.note != null) {
            this.note.setAuthor(author);
        }
    }

    public void remove() {
        this.note.getSheet().removeNote(this.note);
        this.note = null;
    }

    public void show() {
        if (this.note != null) {
            this.note.setHidden(false);
        }
    }

    public void hide() {
        if (this.note != null) {
            this.note.setHidden(true);
        }
    }

    public boolean getIsHidden() {
        if (this.note != null) {
            return this.note.getHidden();
        }
        return false;
    }

    public void setRowCol(int row, int col) {
        if (this.note != null) {
            this.note.setRowCol(row, col);
        }
    }

    public String getAddress() {
        if (this.note != null) {
            return this.note.getCellAddressWithSheet();
        }
        return null;
    }

    public String toString() {
        if (this.note != null) {
            return this.note.toString();
        }
        return "Not initialized";
    }

    public int getRowNum() {
        if (this.note != null) {
            return this.note.getRowNumber();
        }
        return -1;
    }

    public int getColNum() {
        if (this.note != null) {
            return this.note.getColNumber();
        }
        return -1;
    }

    public void setTextBoxSize(int width, int height) {
        if (this.note != null) {
            this.note.setTextBoxWidth((short)width);
            this.note.setTextBoxHeight((short)height);
        }
    }

    public short[] getTextBoxBounds() {
        if (this.note != null) {
            return this.note.getTextBoxBounds();
        }
        return null;
    }

    public void setTextBoxBounds(short[] bounds) {
        if (this.note != null) {
            this.note.setTextBoxBounds(bounds);
        }
    }

    public Note getInternalNoteRec() {
        return this.note;
    }

    public String getOOXML(int authId) {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<comment ref=\"" + ExcelTools.formatLocation(new int[]{this.note.getRowNumber(), this.note.getColNumber()}) + "\" authorId=\"" + authId + "\">");
        ooxml.append(this.note.getOOXML());
        ooxml.append("</comment>");
        return ooxml.toString();
    }
}

