/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function.spif;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.SPIF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.BinaryFunction;

public class Mod
extends BinaryFunction {
    @Override
    public String getURI() {
        return SPIF.MOD_FUNCTION.toString();
    }

    @Override
    protected Value evaluate(ValueFactory valueFactory, Value arg1, Value arg2) throws ValueExprEvaluationException {
        if (!(arg1 instanceof Literal) || !(arg2 instanceof Literal)) {
            throw new ValueExprEvaluationException("Both arguments must be numeric literals");
        }
        Literal leftLit = (Literal)arg1;
        Literal rightLit = (Literal)arg2;
        IRI leftDatatype = leftLit.getDatatype();
        IRI rightDatatype = rightLit.getDatatype();
        if (!XMLDatatypeUtil.isNumericDatatype(leftDatatype)) {
            throw new ValueExprEvaluationException("Not a number: " + leftLit);
        }
        if (!XMLDatatypeUtil.isNumericDatatype(rightDatatype)) {
            throw new ValueExprEvaluationException("Not a number: " + rightLit);
        }
        IRI commonDatatype = leftDatatype.equals(XMLSchema.DOUBLE) || rightDatatype.equals(XMLSchema.DOUBLE) ? XMLSchema.DOUBLE : (leftDatatype.equals(XMLSchema.FLOAT) || rightDatatype.equals(XMLSchema.FLOAT) ? XMLSchema.FLOAT : (leftDatatype.equals(XMLSchema.DECIMAL) || rightDatatype.equals(XMLSchema.DECIMAL) ? XMLSchema.DECIMAL : XMLSchema.INTEGER));
        if (XMLSchema.DOUBLE.equals(commonDatatype)) {
            double left2 = leftLit.doubleValue();
            double right2 = rightLit.doubleValue();
            return valueFactory.createLiteral(left2 % right2);
        }
        if (XMLSchema.FLOAT.equals(commonDatatype)) {
            float left3 = leftLit.floatValue();
            float right3 = rightLit.floatValue();
            return valueFactory.createLiteral(left3 % right3);
        }
        if (XMLSchema.DECIMAL.equals(commonDatatype)) {
            BigDecimal left4 = leftLit.decimalValue();
            BigDecimal right4 = rightLit.decimalValue();
            return valueFactory.createLiteral(left4.remainder(right4, MathContext.UNLIMITED));
        }
        BigInteger left5 = leftLit.integerValue();
        BigInteger right5 = rightLit.integerValue();
        return valueFactory.createLiteral(left5.remainder(right5));
    }
}

