/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class WeakObjectRegistry<E>
extends AbstractSet<E> {
    private final Map<E, WeakReference<E>> objectMap = new WeakHashMap<E, WeakReference<E>>();

    public WeakObjectRegistry() {
    }

    public WeakObjectRegistry(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    public E get(Object key2) {
        WeakReference<E> weakRef = this.objectMap.get(key2);
        if (weakRef != null) {
            return (E)weakRef.get();
        }
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        return this.objectMap.keySet().iterator();
    }

    @Override
    public int size() {
        return this.objectMap.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.get(o) != null;
    }

    @Override
    public boolean add(E object) {
        WeakReference<E> ref2 = new WeakReference<E>(object);
        if ((ref2 = this.objectMap.put(object, ref2)) != null && ref2.get() != null) {
            this.objectMap.put(ref2.get(), ref2);
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        WeakReference<E> ref2 = this.objectMap.remove(o);
        return ref2 != null && ref2.get() != null;
    }

    @Override
    public void clear() {
        this.objectMap.clear();
    }
}

