/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import com.google.common.collect.Sets;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.ScoreDoc;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.sail.lucene.DocumentDistance;
import org.eclipse.rdf4j.sail.lucene.LuceneDocumentResult;
import org.eclipse.rdf4j.sail.lucene.LuceneIndex;
import org.eclipse.rdf4j.sail.lucene.util.GeoUnits;

public class LuceneDocumentDistance
extends LuceneDocumentResult
implements DocumentDistance {
    private final String geoProperty;
    private final URI units;
    private final Point origin;

    private static Set<String> requiredFields(String geoProperty, boolean includeContext) {
        HashSet<String> fields = Sets.newHashSet("uri", geoProperty);
        if (includeContext) {
            fields.add("context");
        }
        return fields;
    }

    public LuceneDocumentDistance(ScoreDoc doc2, String geoProperty, URI units, Point origin, boolean includeContext, LuceneIndex index2) {
        super(doc2, index2, LuceneDocumentDistance.requiredFields(geoProperty, includeContext));
        this.geoProperty = geoProperty;
        this.units = units;
        this.origin = origin;
    }

    @Override
    public double getDistance() {
        List<String> wkts = this.getDocument().getProperty(this.geoProperty);
        double min2 = Double.POSITIVE_INFINITY;
        for (String wkt : wkts) {
            try {
                Shape shape = this.index.getSpatialContext(this.geoProperty).readShapeFromWkt(wkt);
                double dist = this.index.getSpatialContext(this.geoProperty).calcDistance(shape.getCenter(), this.origin);
                min2 = Math.min(dist, min2);
            }
            catch (ParseException parseException) {}
        }
        return GeoUnits.fromDegrees(min2, this.units);
    }
}

